/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Ellipsoid3DBasics
extends Ellipsoid3DReadOnly,
Shape3DBasics {
    public Vector3DBasics getRadii();

    @Override
    public Shape3DPoseBasics getPose();

    default public RotationMatrixBasics getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public Point3DBasics getPosition() {
        return this.getPose().getShapePosition();
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier var1);

    @Override
    default public boolean containsNaN() {
        return Ellipsoid3DReadOnly.super.containsNaN();
    }

    default public void setToNaN() {
        this.getPose().setToNaN();
        this.getRadii().setToNaN();
    }

    default public void setToZero() {
        this.getPose().setToZero();
        this.getRadii().setToZero();
    }

    default public void set(Ellipsoid3DReadOnly other) {
        this.getPose().set(other.getPose());
        this.getRadii().set((Tuple3DReadOnly)other.getRadii());
    }

    default public void set(Point3DReadOnly position, Orientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        this.getPose().set(orientation, (Tuple3DReadOnly)position);
        this.getRadii().set(radiusX, radiusY, radiusZ);
    }

    default public void set(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly radii) {
        this.getPose().set(orientation, (Tuple3DReadOnly)position);
        this.getRadii().set((Tuple3DReadOnly)radii);
    }

    default public void set(Pose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.getPose().set(pose);
        this.getRadii().set(radiusX, radiusY, radiusZ);
    }

    default public void set(Pose3DReadOnly pose, Vector3DReadOnly radii) {
        this.getPose().set(pose);
        this.getRadii().set((Tuple3DReadOnly)radii);
    }

    default public void set(RigidBodyTransformReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.getPose().set(pose);
        this.getRadii().set(radiusX, radiusY, radiusZ);
    }

    default public void set(RigidBodyTransformReadOnly pose, Vector3DReadOnly radii) {
        this.getPose().set(pose);
        this.getRadii().set((Tuple3DReadOnly)radii);
    }

    default public void set(RigidBodyTransformReadOnly pose, double[] radii) {
        this.getPose().set(pose);
        this.getRadii().set(radii[0], radii[1], radii[2]);
    }

    default public void setRadiusX(double radiusX) {
        this.getRadii().setX(radiusX);
    }

    default public void setRadiusY(double radiusY) {
        this.getRadii().setY(radiusY);
    }

    default public void setRadiusZ(double radiusZ) {
        this.getRadii().setZ(radiusZ);
    }

    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((RigidBodyTransformBasics)this.getPose());
    }

    default public void applyTransform(Transform transform) {
        transform.transform((RigidBodyTransformBasics)this.getPose());
    }
}

