/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Ellipsoid3D
implements Ellipsoid3DBasics,
Settable<Ellipsoid3D> {
    private final Shape3DPose pose = new Shape3DPose();
    private IntermediateVariableSupplier supplier = IntermediateVariableSupplier.defaultIntermediateVariableSupplier();
    private final Vector3DBasics radii = EuclidCoreFactories.newObservableVector3DBasics((axis, newValue) -> this.checkRadiusPositive((Axis3D)axis), null);

    public Ellipsoid3D() {
        this(1.0, 1.0, 1.0);
    }

    public Ellipsoid3D(double radiusX, double radiusY, double radiusZ) {
        this.getRadii().set(radiusX, radiusY, radiusZ);
    }

    public Ellipsoid3D(Vector3DReadOnly radii) {
        this.getRadii().set((Tuple3DReadOnly)radii);
    }

    public Ellipsoid3D(Point3DReadOnly position, Orientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        this.set(position, orientation, radiusX, radiusY, radiusZ);
    }

    public Ellipsoid3D(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly radii) {
        this.set(position, orientation, radii);
    }

    public Ellipsoid3D(Pose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.set(pose, radiusX, radiusY, radiusZ);
    }

    public Ellipsoid3D(Pose3DReadOnly pose, Vector3DReadOnly radii) {
        this.set(pose, radii);
    }

    public Ellipsoid3D(RigidBodyTransformReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.set(pose, radiusX, radiusY, radiusZ);
    }

    public Ellipsoid3D(RigidBodyTransformReadOnly pose, Vector3DReadOnly radii) {
        this.set(pose, radii);
    }

    public Ellipsoid3D(Ellipsoid3DReadOnly other) {
        this.set(other);
    }

    @Override
    public Shape3DPose getPose() {
        return this.pose;
    }

    @Override
    public Vector3DBasics getRadii() {
        return this.radii;
    }

    @Override
    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.supplier;
    }

    @Override
    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.supplier = newSupplier;
    }

    public void set(Ellipsoid3D other) {
        Ellipsoid3DBasics.super.set(other);
    }

    @Override
    public Ellipsoid3D copy() {
        return new Ellipsoid3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Ellipsoid3DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.pose.hashCode(), (long)this.radii.hashCode());
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

