/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Torus3D
implements Torus3DBasics {
    private final Point3D position = new Point3D();
    private final UnitVector3D axis = new UnitVector3D((Tuple3DReadOnly)Axis3D.Z);
    private double radius;
    private double tubeRadius;

    public Torus3D() {
        this(1.0, 0.1);
    }

    public Torus3D(double radius, double tubeRadius) {
        this.setRadii(radius, tubeRadius);
    }

    public Torus3D(Point3DReadOnly position, Vector3DReadOnly axis, double radius, double tubeRadius) {
        this.set(position, axis, radius, tubeRadius);
    }

    public Torus3D(Torus3DReadOnly other) {
        this.set(other);
    }

    @Override
    public void setRadii(double radius, double tubeRadius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a " + this.getClass().getSimpleName() + " cannot be negative: " + radius);
        }
        if (tubeRadius < 0.0) {
            throw new IllegalArgumentException("The tube radius of a " + this.getClass().getSimpleName() + " cannot be negative: " + tubeRadius);
        }
        this.radius = radius;
        this.tubeRadius = tubeRadius;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public double getTubeRadius() {
        return this.tubeRadius;
    }

    @Override
    public Point3DBasics getPosition() {
        return this.position;
    }

    @Override
    public UnitVector3DBasics getAxis() {
        return this.axis;
    }

    @Override
    public Torus3D copy() {
        return new Torus3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Torus3DReadOnly) {
            return Torus3DBasics.super.equals((Torus3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.addToHashCode((long)hash, (double)this.radius);
        hash = EuclidHashCodeTools.addToHashCode((long)hash, (double)this.tubeRadius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.position.hashCode());
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.axis.hashCode());
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

