/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Cylinder3D
implements Cylinder3DBasics {
    private final Point3D position = new Point3D();
    private final UnitVector3D axis = new UnitVector3D((Tuple3DReadOnly)Axis3D.Z);
    private double radius;
    private double length;
    private double halfLength;
    private final Point3DReadOnly topCenter = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.halfLength * this.axis.getX() + this.position.getX(), () -> this.halfLength * this.axis.getY() + this.position.getY(), () -> this.halfLength * this.axis.getZ() + this.position.getZ());
    private final Point3DReadOnly bottomCenter = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> -this.halfLength * this.axis.getX() + this.position.getX(), () -> -this.halfLength * this.axis.getY() + this.position.getY(), () -> -this.halfLength * this.axis.getZ() + this.position.getZ());

    public Cylinder3D() {
        this(1.0, 0.5);
    }

    public Cylinder3D(double length, double radius) {
        this.setSize(length, radius);
    }

    public Cylinder3D(Point3DReadOnly position, Vector3DReadOnly axis, double length, double radius) {
        this.set(position, axis, length, radius);
    }

    public Cylinder3D(Cylinder3DReadOnly other) {
        this.set(other);
    }

    @Override
    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Cylinder3D cannot be negative: " + radius);
        }
        this.radius = radius;
    }

    @Override
    public void setLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("The length of a Cylinder3D cannot be negative: " + length);
        }
        this.length = length;
        this.halfLength = 0.5 * length;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public double getHalfLength() {
        return this.halfLength;
    }

    @Override
    public Point3DBasics getPosition() {
        return this.position;
    }

    @Override
    public UnitVector3DBasics getAxis() {
        return this.axis;
    }

    @Override
    public Point3DReadOnly getTopCenter() {
        return this.topCenter;
    }

    @Override
    public Point3DReadOnly getBottomCenter() {
        return this.bottomCenter;
    }

    @Override
    public Cylinder3D copy() {
        return new Cylinder3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Cylinder3DReadOnly) {
            return Cylinder3DBasics.super.equals((Cylinder3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.toLongHashCode((double)this.length, (double)this.radius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((Object)this.position, (Object)this.axis));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

