/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.BoxPolytope3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Box3D
implements Box3DBasics {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private final Shape3DPose pose = new Shape3DPose();
    private IntermediateVariableSupplier supplier = IntermediateVariableSupplier.defaultIntermediateVariableSupplier();
    private final Vector3DBasics size = EuclidCoreFactories.newObservableVector3DBasics((axis, newValue) -> {
        this.checkSizePositive((Axis3D)axis);
        this.notifyChangeListeners();
    }, null);
    private BoxPolytope3D polytopeView = null;

    public Box3D() {
        this(1.0, 1.0, 1.0);
    }

    public Box3D(double sizeX, double sizeY, double sizeZ) {
        this.getSize().set(sizeX, sizeY, sizeZ);
    }

    public Box3D(Vector3DReadOnly size) {
        this.getSize().set((Tuple3DReadOnly)size);
    }

    public Box3D(Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.set(position, orientation, sizeX, sizeY, sizeZ);
    }

    public Box3D(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.set(position, orientation, size);
    }

    public Box3D(Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
    }

    public Box3D(Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
    }

    public Box3D(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
    }

    public Box3D(RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
    }

    public Box3D(Box3DReadOnly other) {
        this.set(other);
    }

    @Override
    public Shape3DPose getPose() {
        return this.pose;
    }

    @Override
    public Vector3DBasics getSize() {
        return this.size;
    }

    @Override
    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.supplier;
    }

    @Override
    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.supplier = newSupplier;
    }

    @Override
    public Box3D copy() {
        return new Box3D(this);
    }

    @Override
    public BoxPolytope3DView asConvexPolytope() {
        if (this.polytopeView == null) {
            this.polytopeView = new BoxPolytope3D(this);
        }
        return this.polytopeView;
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
        this.pose.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        boolean hasBeenRemoved = this.changeListeners.remove(listener);
        return hasBeenRemoved |= this.pose.removeChangeListener(listener);
    }

    public boolean equals(Object object) {
        if (object instanceof Box3DReadOnly) {
            return Box3DBasics.super.equals((Box3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.pose, (Object)this.size);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

