/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.SymmetricEigenDecomposition3D;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidPolytopeConstructionTools {
    public static final double DEFAULT_CONSTRUCTION_EPSILON = 1.0E-10;

    private EuclidPolytopeConstructionTools() {
    }

    public static <Vertex extends AbstractVertex3D<Vertex, Edge, Face>, Edge extends AbstractHalfEdge3D<Vertex, Edge, Face>, Face extends AbstractFace3D<Vertex, Edge, Face>> List<Face> computeVertexNeighborFaces(Face3DFactory<Face> faceFactory, Vertex vertex, List<Edge> silhouetteEdges, Collection<Face> inPlaneFaces, double epsilon) {
        if (EuclidPolytopeTools.distanceToClosestHalfEdge3D(vertex, silhouetteEdges) <= epsilon) {
            return null;
        }
        if (!EuclidPolytopeConstructionTools.filterInPlaneFaces(vertex, silhouetteEdges, inPlaneFaces, epsilon)) {
            return null;
        }
        Vector3D towardOutside = new Vector3D();
        for (AbstractHalfEdge3D silhouetteEdge : silhouetteEdges) {
            Face3DReadOnly face = silhouetteEdge.getFace();
            if (inPlaneFaces.contains(face)) continue;
            towardOutside.cross((Tuple3DReadOnly)((AbstractFace3D)face).getNormal(), (Tuple3DReadOnly)silhouetteEdge.getDirection(false));
            if (!(EuclidGeometryTools.isPoint3DAbovePlane3D(vertex, (Point3DReadOnly)((AbstractFace3D)face).getCentroid(), (Vector3DReadOnly)((AbstractFace3D)face).getNormal()) ? EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D(vertex, (Point3DReadOnly)silhouetteEdge.getOrigin(), silhouetteEdge.getDestination(), (Vector3DReadOnly)towardOutside) : EuclidPolytopeTools.isPoint3DOnRightSideOfLine3D(vertex, (Point3DReadOnly)silhouetteEdge.getOrigin(), silhouetteEdge.getDestination(), (Vector3DReadOnly)towardOutside))) continue;
            return null;
        }
        for (AbstractHalfEdge3D silhouetteEdge : silhouetteEdges) {
            EuclidPolytopeConstructionTools.destroyTwinFace(silhouetteEdge);
        }
        if (!inPlaneFaces.isEmpty()) {
            silhouetteEdges = new ArrayList<Edge>(silhouetteEdges);
            inPlaneFaces = new ArrayList<Face>(inPlaneFaces);
            for (int i = 0; i < silhouetteEdges.size() && !inPlaneFaces.isEmpty(); ++i) {
                AbstractHalfEdge3D silhouetteEdge;
                silhouetteEdge = (AbstractHalfEdge3D)silhouetteEdges.get(i);
                Face3DReadOnly faceToExtend = silhouetteEdge.getFace();
                if (!inPlaneFaces.remove(faceToExtend)) continue;
                silhouetteEdges.removeAll(((AbstractFace3D)faceToExtend).lineOfSight(vertex, epsilon));
                --i;
                boolean wasModified = ((AbstractFace3D)faceToExtend).addVertex(vertex);
                assert (wasModified);
            }
        }
        ArrayList<Face> newFaces = new ArrayList<Face>();
        int forloopStart = 0;
        int forloopEnd = silhouetteEdges.size() - 1;
        if (!silhouetteEdges.isEmpty()) {
            HalfEdge3DReadOnly newEdge;
            AbstractHalfEdge3D nextSilhouetteEdge;
            int i;
            AbstractHalfEdge3D firstSilhouetteEdge = (AbstractHalfEdge3D)silhouetteEdges.get(0);
            Face newFace = EuclidPolytopeConstructionTools.newFace3DFromVertexAndTwinEdge(faceFactory, vertex, firstSilhouetteEdge, epsilon);
            forloopStart = 1;
            AbstractHalfEdge3D previousSilhouetteEdge = firstSilhouetteEdge;
            for (i = 1; i < silhouetteEdges.size(); ++i) {
                nextSilhouetteEdge = (AbstractHalfEdge3D)silhouetteEdges.get(i);
                if (previousSilhouetteEdge.getDestination() != nextSilhouetteEdge.getOrigin() || !EuclidPolytopeTools.arePoint3DAndFace3DInPlane(nextSilhouetteEdge.getDestination(), newFace, epsilon) || !newFace.canObserverSeeEdge((Point3DReadOnly)nextSilhouetteEdge.getDestination(), ((AbstractHalfEdge3D)previousSilhouetteEdge.getTwin()).getPrevious()) || !((AbstractFace3D)newFace).addVertex((Vertex3DReadOnly)nextSilhouetteEdge.getDestination(), vertex, true)) break;
                newEdge = ((AbstractVertex3D)nextSilhouetteEdge.getDestination()).getEdgeTo(nextSilhouetteEdge.getOrigin());
                nextSilhouetteEdge.setTwin(newEdge);
                ((AbstractHalfEdge3D)newEdge).setTwin(nextSilhouetteEdge);
                forloopStart = i + 1;
                previousSilhouetteEdge = nextSilhouetteEdge;
            }
            nextSilhouetteEdge = firstSilhouetteEdge;
            for (i = silhouetteEdges.size() - 1; i >= forloopStart && (previousSilhouetteEdge = (AbstractHalfEdge3D)silhouetteEdges.get(i)).getDestination() == nextSilhouetteEdge.getOrigin() && EuclidPolytopeTools.arePoint3DAndFace3DInPlane(previousSilhouetteEdge.getOrigin(), newFace, epsilon) && newFace.canObserverSeeEdge((Point3DReadOnly)previousSilhouetteEdge.getOrigin(), ((AbstractHalfEdge3D)nextSilhouetteEdge.getTwin()).getNext()) && ((AbstractFace3D)newFace).addVertex((Vertex3DReadOnly)previousSilhouetteEdge.getOrigin(), vertex, true); --i) {
                newEdge = ((AbstractVertex3D)previousSilhouetteEdge.getDestination()).getEdgeTo(previousSilhouetteEdge.getOrigin());
                previousSilhouetteEdge.setTwin(newEdge);
                ((AbstractHalfEdge3D)newEdge).setTwin(previousSilhouetteEdge);
                forloopEnd = i - 1;
                nextSilhouetteEdge = previousSilhouetteEdge;
            }
            newFaces.add(newFace);
        }
        for (int i = forloopStart; i <= forloopEnd; ++i) {
            AbstractHalfEdge3D silhouetteEdge = (AbstractHalfEdge3D)silhouetteEdges.get(i);
            Face newFace = EuclidPolytopeConstructionTools.newFace3DFromVertexAndTwinEdge(faceFactory, vertex, silhouetteEdge, epsilon);
            AbstractHalfEdge3D previousSilhouetteEdge = silhouetteEdge;
            int j = i + 1;
            while (j < forloopEnd) {
                AbstractHalfEdge3D nextSilhouetteEdge = (AbstractHalfEdge3D)silhouetteEdges.get(j);
                if (previousSilhouetteEdge.getDestination() != nextSilhouetteEdge.getOrigin() || !EuclidPolytopeTools.arePoint3DAndFace3DInPlane(nextSilhouetteEdge.getDestination(), newFace, epsilon) || !newFace.canObserverSeeEdge((Point3DReadOnly)nextSilhouetteEdge.getDestination(), ((AbstractHalfEdge3D)previousSilhouetteEdge.getTwin()).getPrevious()) || !((AbstractFace3D)newFace).addVertex((Vertex3DReadOnly)nextSilhouetteEdge.getDestination(), vertex, true)) break;
                HalfEdge3DReadOnly newEdge = ((AbstractVertex3D)nextSilhouetteEdge.getDestination()).getEdgeTo(nextSilhouetteEdge.getOrigin());
                nextSilhouetteEdge.setTwin(newEdge);
                ((AbstractHalfEdge3D)newEdge).setTwin(nextSilhouetteEdge);
                i = j++;
                previousSilhouetteEdge = nextSilhouetteEdge;
            }
            newFaces.add(newFace);
        }
        for (AbstractHalfEdge3D startingFrom : vertex.getAssociatedEdges()) {
            HalfEdge3DReadOnly endingTo = ((AbstractVertex3D)startingFrom.getDestination()).getEdgeTo(vertex);
            startingFrom.setTwin(endingTo);
            ((AbstractHalfEdge3D)endingTo).setTwin(startingFrom);
        }
        return newFaces;
    }

    private static boolean filterInPlaneFaces(Vertex3DReadOnly vertex, List<? extends HalfEdge3DReadOnly> silhouetteEdges, Collection<? extends Face3DReadOnly> inPlaneFaces, double epsilon) {
        if (inPlaneFaces.isEmpty()) {
            return true;
        }
        boolean hasInPlaneFacesBeenModified = false;
        HashSet<HalfEdge3DReadOnly> edgesToSkip = new HashSet<HalfEdge3DReadOnly>();
        for (HalfEdge3DReadOnly halfEdge3DReadOnly : silhouetteEdges) {
            Face3DReadOnly face;
            if (edgesToSkip.contains(halfEdge3DReadOnly) || !inPlaneFaces.contains(face = halfEdge3DReadOnly.getFace())) continue;
            List<? extends HalfEdge3DReadOnly> lineOfSight = face.lineOfSight(vertex);
            if (lineOfSight.isEmpty()) {
                inPlaneFaces.remove(face);
                hasInPlaneFacesBeenModified = true;
                continue;
            }
            boolean faceRemovedFromInPlaneList = false;
            if (!lineOfSight.contains(halfEdge3DReadOnly)) {
                return false;
            }
            for (HalfEdge3DReadOnly halfEdge3DReadOnly2 : lineOfSight) {
                if (halfEdge3DReadOnly2 == halfEdge3DReadOnly) continue;
                if (silhouetteEdges.contains(halfEdge3DReadOnly2)) {
                    if (halfEdge3DReadOnly == halfEdge3DReadOnly2) continue;
                    edgesToSkip.add(halfEdge3DReadOnly2);
                    continue;
                }
                if (!EuclidPolytopeTools.arePoint3DAndHalfEdge3DInLine(vertex, halfEdge3DReadOnly2, epsilon)) {
                    faceRemovedFromInPlaneList = true;
                    inPlaneFaces.remove(face);
                    hasInPlaneFacesBeenModified = true;
                    break;
                }
                if (inPlaneFaces.contains(halfEdge3DReadOnly2.getTwin().getFace())) continue;
                faceRemovedFromInPlaneList = true;
                inPlaneFaces.remove(face);
                hasInPlaneFacesBeenModified = true;
                break;
            }
            if (faceRemovedFromInPlaneList) continue;
            HalfEdge3DReadOnly edgeBeforeLineOfSight = lineOfSight.get(0).getPrevious();
            HalfEdge3DReadOnly halfEdge3DReadOnly3 = lineOfSight.get(lineOfSight.size() - 1).getNext();
            if (!silhouetteEdges.contains(edgeBeforeLineOfSight) && (edgeBeforeLineOfSight.distanceFromSupportLine(vertex) < epsilon || EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)edgeBeforeLineOfSight.getDestination(), (Point3DReadOnly)vertex, (Point3DReadOnly)edgeBeforeLineOfSight.getOrigin()) < epsilon) && !inPlaneFaces.contains(edgeBeforeLineOfSight.getTwin().getFace())) {
                inPlaneFaces.remove(face);
                hasInPlaneFacesBeenModified = true;
            }
            if (silhouetteEdges.contains(halfEdge3DReadOnly3) || !(halfEdge3DReadOnly3.distanceFromSupportLine(vertex) < epsilon) && !(EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)halfEdge3DReadOnly3.getOrigin(), (Point3DReadOnly)vertex, (Point3DReadOnly)halfEdge3DReadOnly3.getDestination()) < epsilon) || inPlaneFaces.contains(halfEdge3DReadOnly3.getTwin().getFace())) continue;
            inPlaneFaces.remove(face);
            hasInPlaneFacesBeenModified = true;
        }
        if (hasInPlaneFacesBeenModified) {
            return EuclidPolytopeConstructionTools.filterInPlaneFaces(vertex, silhouetteEdges, inPlaneFaces, epsilon);
        }
        return true;
    }

    private static void destroyTwinFace(AbstractHalfEdge3D<?, ?, ?> edge) {
        HalfEdge3DReadOnly twin = edge.getTwin();
        if (twin == null) {
            return;
        }
        Face3DReadOnly face = ((AbstractHalfEdge3D)twin).getFace();
        if (face == null) {
            return;
        }
        ((AbstractFace3D)face).destroy();
    }

    public static <Vertex extends AbstractVertex3D<Vertex, Edge, Face>, Edge extends AbstractHalfEdge3D<Vertex, Edge, Face>, Face extends AbstractFace3D<Vertex, Edge, Face>> Face newFace3DFromVertexAndTwinEdge(Face3DFactory<Face> faceFactory, Vertex vertex, Edge twinEdge, double epsilon) {
        Vertex3DReadOnly v1 = ((AbstractHalfEdge3D)twinEdge).getDestination();
        Vertex3DReadOnly v2 = ((AbstractHalfEdge3D)twinEdge).getOrigin();
        Vertex v3 = vertex;
        Vector3D initialNormal = EuclidPolytopeTools.crossProductOfLineSegment3Ds(v1, v2, v2, v3);
        initialNormal.negate();
        AbstractFace3D face = (AbstractFace3D)faceFactory.newInstance((Vector3DReadOnly)initialNormal, epsilon);
        boolean wasModified = face.addVertex(v1);
        assert (wasModified);
        wasModified = face.addVertex(v2);
        assert (wasModified);
        HalfEdge3DReadOnly faceFirstEdge = face.getEdge(0);
        ((AbstractHalfEdge3D)twinEdge).setTwin((HalfEdge3DReadOnly)faceFirstEdge);
        ((AbstractHalfEdge3D)faceFirstEdge).setTwin(twinEdge);
        wasModified = face.addVertex(v3, null, true);
        assert (wasModified);
        HalfEdge3DReadOnly vertexToOrigin = vertex.getEdgeTo(((AbstractHalfEdge3D)twinEdge).getOrigin());
        HalfEdge3DReadOnly originToVertex = ((AbstractVertex3D)((AbstractHalfEdge3D)twinEdge).getOrigin()).getEdgeTo(vertex);
        if (vertexToOrigin != null) {
            ((AbstractHalfEdge3D)vertexToOrigin).setTwin(originToVertex);
        }
        if (originToVertex != null) {
            ((AbstractHalfEdge3D)originToVertex).setTwin(vertexToOrigin);
        }
        HalfEdge3DReadOnly vertexToDestination = vertex.getEdgeTo(((AbstractHalfEdge3D)twinEdge).getDestination());
        HalfEdge3DReadOnly destinationToVertex = ((AbstractVertex3D)((AbstractHalfEdge3D)twinEdge).getDestination()).getEdgeTo(vertex);
        if (vertexToDestination != null) {
            ((AbstractHalfEdge3D)vertexToDestination).setTwin(destinationToVertex);
        }
        if (destinationToVertex != null) {
            ((AbstractHalfEdge3D)destinationToVertex).setTwin(vertexToDestination);
        }
        return (Face)face;
    }

    public static boolean updateFace3DNormal(List<? extends Point3DReadOnly> vertices, Point3DBasics averageToPack, Vector3DBasics normalToUpdate) {
        Matrix3D covarianceMatrix = new Matrix3D();
        EuclidPolytopeConstructionTools.computeCovariance3D(vertices, (Tuple3DBasics)averageToPack, (Matrix3DBasics)covarianceMatrix);
        return EuclidPolytopeConstructionTools.updateFace3DNormal((Matrix3DReadOnly)covarianceMatrix, normalToUpdate);
    }

    public static boolean updateFace3DNormal(Matrix3DReadOnly covarianceMatrix, Vector3DBasics normalToUpdate) {
        return EuclidPolytopeConstructionTools.updateFace3DNormal(new SymmetricEigenDecomposition3D(), covarianceMatrix, normalToUpdate);
    }

    public static boolean updateFace3DNormal(SymmetricEigenDecomposition3D eigenDecomposition, Matrix3DReadOnly covarianceMatrix, Vector3DBasics normalToUpdate) {
        boolean negate;
        if (!eigenDecomposition.decompose(covarianceMatrix)) {
            return false;
        }
        Vector3D newNormal = eigenDecomposition.getEigenVector(2);
        boolean bl = negate = newNormal.dot((Tuple3DReadOnly)normalToUpdate) < 0.0;
        if (negate) {
            normalToUpdate.setAndNegate((Tuple3DReadOnly)newNormal);
        } else {
            normalToUpdate.set((Tuple3DReadOnly)newNormal);
        }
        return true;
    }

    public static void computeCovariance3D(List<? extends Tuple3DReadOnly> input, Matrix3DBasics covarianceToPack) {
        EuclidPolytopeConstructionTools.computeCovariance3D(input, null, covarianceToPack);
    }

    public static void computeCovariance3D(List<? extends Tuple3DReadOnly> input, Tuple3DBasics averageToPack, Matrix3DBasics covarianceToPack) {
        double meanX = 0.0;
        double meanY = 0.0;
        double meanZ = 0.0;
        for (int i = 0; i < input.size(); ++i) {
            Tuple3DReadOnly element = input.get(i);
            meanX += element.getX();
            meanY += element.getY();
            meanZ += element.getZ();
        }
        double inverseOfInputSize = 1.0 / (double)input.size();
        meanX *= inverseOfInputSize;
        meanY *= inverseOfInputSize;
        meanZ *= inverseOfInputSize;
        if (averageToPack != null) {
            averageToPack.set(meanX, meanY, meanZ);
        }
        double covXX = 0.0;
        double covYY = 0.0;
        double covZZ = 0.0;
        double covXY = 0.0;
        double covXZ = 0.0;
        double covYZ = 0.0;
        for (int i = 0; i < input.size(); ++i) {
            Tuple3DReadOnly element = input.get(i);
            double devX = element.getX() - meanX;
            double devY = element.getY() - meanY;
            double devZ = element.getZ() - meanZ;
            covXX += devX * devX * inverseOfInputSize;
            covYY += devY * devY * inverseOfInputSize;
            covZZ += devZ * devZ * inverseOfInputSize;
            covXY += devX * devY * inverseOfInputSize;
            covXZ += devX * devZ * inverseOfInputSize;
            covYZ += devY * devZ * inverseOfInputSize;
        }
        covarianceToPack.set(covXX, covXY, covXZ, covXY, covYY, covYZ, covXZ, covYZ, covZZ);
    }

    public static double computeConvexPolygon3DArea(List<? extends Point3DReadOnly> convexPolygon3D, Vector3DReadOnly normal, int numberOfVertices, boolean clockwiseOrdered, Point3DBasics centroidToPack) {
        double weight;
        double wz;
        double wy;
        double wx;
        Point3DReadOnly ci;
        int i;
        EuclidPolytopeConstructionTools.checkNumberOfVertices(convexPolygon3D, numberOfVertices);
        if (numberOfVertices == 0) {
            if (centroidToPack != null) {
                centroidToPack.setToNaN();
            }
            return Double.NaN;
        }
        if (numberOfVertices < 3) {
            if (centroidToPack != null) {
                centroidToPack.setToZero();
                for (int i2 = 0; i2 < numberOfVertices; ++i2) {
                    centroidToPack.add((Tuple3DReadOnly)convexPolygon3D.get(i2));
                }
                centroidToPack.scale(1.0 / (double)numberOfVertices);
            }
            return 0.0;
        }
        double area = 0.0;
        double Cx = 0.0;
        double Cy = 0.0;
        double Cz = 0.0;
        if (clockwiseOrdered) {
            for (i = 0; i < numberOfVertices; ++i) {
                ci = convexPolygon3D.get(i);
                Point3DReadOnly ciMinus1 = convexPolygon3D.get(EuclidGeometryPolygonTools.previous((int)i, (int)numberOfVertices));
                wx = ci.getY() * ciMinus1.getZ() - ci.getZ() * ciMinus1.getY();
                wy = ci.getZ() * ciMinus1.getX() - ci.getX() * ciMinus1.getZ();
                wz = ci.getX() * ciMinus1.getY() - ci.getY() * ciMinus1.getX();
                weight = TupleTools.dot((double)wx, (double)wy, (double)wz, (Tuple3DReadOnly)normal);
                Cx += (ci.getX() + ciMinus1.getX()) * weight;
                Cy += (ci.getY() + ciMinus1.getY()) * weight;
                Cz += (ci.getZ() + ciMinus1.getZ()) * weight;
                area += weight;
            }
        } else {
            for (i = 0; i < numberOfVertices; ++i) {
                ci = convexPolygon3D.get(i);
                Point3DReadOnly ciPlus1 = convexPolygon3D.get(EuclidGeometryPolygonTools.next((int)i, (int)numberOfVertices));
                wx = ci.getY() * ciPlus1.getZ() - ci.getZ() * ciPlus1.getY();
                wy = ci.getZ() * ciPlus1.getX() - ci.getX() * ciPlus1.getZ();
                wz = ci.getX() * ciPlus1.getY() - ci.getY() * ciPlus1.getX();
                weight = TupleTools.dot((double)wx, (double)wy, (double)wz, (Tuple3DReadOnly)normal);
                Cx += (ci.getX() + ciPlus1.getX()) * weight;
                Cy += (ci.getY() + ciPlus1.getY()) * weight;
                Cz += (ci.getZ() + ciPlus1.getZ()) * weight;
                area += weight;
            }
        }
        area *= 0.5;
        if (centroidToPack != null) {
            if (area < 1.0E-12) {
                centroidToPack.setToZero();
                for (i = 0; i < numberOfVertices; ++i) {
                    centroidToPack.add((Tuple3DReadOnly)convexPolygon3D.get(i));
                }
                centroidToPack.scale(1.0 / (double)numberOfVertices);
            } else {
                double scale = 1.0 / (6.0 * area);
                centroidToPack.set(Cx *= scale, Cy *= scale, Cz *= scale);
                double dot = TupleTools.dot((double)Cx, (double)Cy, (double)Cz, (Tuple3DReadOnly)normal);
                centroidToPack.scaleAdd(-dot, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)centroidToPack);
                double average = 0.0;
                for (int i3 = 0; i3 < numberOfVertices; ++i3) {
                    Point3DReadOnly vertex = convexPolygon3D.get(i3);
                    average += TupleTools.dot((Tuple3DReadOnly)vertex, (Tuple3DReadOnly)normal) / (double)numberOfVertices;
                }
                centroidToPack.scaleAdd(average, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)centroidToPack);
            }
        }
        return area;
    }

    public static double computeConvexPolytope3DVolume(ConvexPolytope3DReadOnly convexPolytope3D, Point3DBasics centroidToPack) {
        centroidToPack.setToZero();
        double volume = 0.0;
        if (convexPolytope3D.getNumberOfVertices() <= 4) {
            for (int vertexIndex = 0; vertexIndex < convexPolytope3D.getNumberOfVertices(); ++vertexIndex) {
                centroidToPack.add((Tuple3DReadOnly)convexPolytope3D.getVertex(vertexIndex));
            }
            centroidToPack.scale(1.0 / (double)convexPolytope3D.getNumberOfVertices());
            volume = convexPolytope3D.getNumberOfVertices() == 4 ? EuclidShapeTools.tetrahedronVolume(convexPolytope3D.getVertex(0), convexPolytope3D.getVertex(1), convexPolytope3D.getVertex(2), convexPolytope3D.getVertex(3)) : 0.0;
            return volume;
        }
        Vertex3DReadOnly a = convexPolytope3D.getFace(0).getVertex(0);
        for (int faceIndex = 1; faceIndex < convexPolytope3D.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face3DReadOnly = convexPolytope3D.getFace(faceIndex);
            int numberOfTriangles = face3DReadOnly.getNumberOfEdges() - 2;
            Vertex3DReadOnly b = face3DReadOnly.getVertex(0);
            for (int triangleIndex = 0; triangleIndex < numberOfTriangles; ++triangleIndex) {
                Vertex3DReadOnly c = face3DReadOnly.getVertex(triangleIndex + 1);
                Vertex3DReadOnly d = face3DReadOnly.getVertex(triangleIndex + 2);
                double tetrahedronVolume = EuclidShapeTools.tetrahedronVolume(a, b, c, d);
                double scale = 0.25 * tetrahedronVolume;
                centroidToPack.scaleAdd(scale, (Tuple3DReadOnly)a, (Tuple3DReadOnly)centroidToPack);
                centroidToPack.scaleAdd(scale, (Tuple3DReadOnly)b, (Tuple3DReadOnly)centroidToPack);
                centroidToPack.scaleAdd(scale, (Tuple3DReadOnly)c, (Tuple3DReadOnly)centroidToPack);
                centroidToPack.scaleAdd(scale, (Tuple3DReadOnly)d, (Tuple3DReadOnly)centroidToPack);
                volume += tetrahedronVolume;
            }
        }
        if (volume <= 1.0E-12) {
            for (Point3DReadOnly point3DReadOnly : convexPolytope3D.getVertices()) {
                centroidToPack.add((Tuple3DReadOnly)point3DReadOnly);
            }
            centroidToPack.scale(1.0 / (double)convexPolytope3D.getNumberOfVertices());
        } else {
            centroidToPack.scale(1.0 / volume);
        }
        return volume;
    }

    static void checkNumberOfVertices(List<? extends Point3DReadOnly> convexPolygon3D, int numberOfVertices) {
        if (numberOfVertices < 0 || numberOfVertices > convexPolygon3D.size()) {
            throw new IllegalArgumentException("Illegal numberOfVertices: " + numberOfVertices + ", expected a value in ] 0, " + convexPolygon3D.size() + "].");
        }
    }
}

