/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.interfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Face3DReadOnly
extends SupportingVertexHolder {
    public Point3DReadOnly getCentroid();

    public Vector3DReadOnly getNormal();

    public double getArea();

    public BoundingBox3DReadOnly getBoundingBox();

    public List<? extends HalfEdge3DReadOnly> getEdges();

    default public HalfEdge3DReadOnly getEdge(int index) {
        return this.getEdges().get(index);
    }

    default public List<? extends Vertex3DReadOnly> getVertices() {
        return this.getEdges().stream().map(HalfEdge3DReadOnly::getOrigin).collect(Collectors.toList());
    }

    default public Vertex3DReadOnly getVertex(int index) {
        return this.getEdge(index).getOrigin();
    }

    default public int getNumberOfEdges() {
        return this.getEdges().size();
    }

    default public boolean isEmpty() {
        return this.getEdges().isEmpty();
    }

    default public boolean containsNaN() {
        if (this.isEmpty()) {
            return false;
        }
        for (int edgeIndex = 0; edgeIndex < this.getNumberOfEdges(); ++edgeIndex) {
            if (!this.getEdge(edgeIndex).getOrigin().containsNaN()) continue;
            return true;
        }
        return false;
    }

    default public List<? extends HalfEdge3DReadOnly> lineOfSight(Point3DReadOnly observer) {
        HalfEdge3DReadOnly currentEdge = this.lineOfSightStart(observer);
        if (currentEdge == null) {
            return Collections.emptyList();
        }
        ArrayList<HalfEdge3DReadOnly> lineOfSight = new ArrayList<HalfEdge3DReadOnly>();
        for (int i = 0; i < this.getNumberOfEdges(); ++i) {
            lineOfSight.add(currentEdge);
            currentEdge = currentEdge.getNext();
            if (!this.canObserverSeeEdge(observer, currentEdge)) break;
        }
        return lineOfSight;
    }

    default public List<? extends HalfEdge3DReadOnly> lineOfSight(Point3DReadOnly observer, double epsilon) {
        HalfEdge3DReadOnly currentEdge = this.lineOfSightStart(observer);
        if (currentEdge == null) {
            return Collections.emptyList();
        }
        ArrayList<HalfEdge3DReadOnly> lineOfSight = new ArrayList<HalfEdge3DReadOnly>();
        for (int i = 0; i < this.getNumberOfEdges(); ++i) {
            lineOfSight.add(currentEdge);
            currentEdge = currentEdge.getNext();
            if (!this.canObserverSeeEdge(observer, currentEdge)) break;
        }
        HalfEdge3DReadOnly firstVisibleEdge = (HalfEdge3DReadOnly)lineOfSight.get(0);
        HalfEdge3DReadOnly lastVisibleEdge = (HalfEdge3DReadOnly)lineOfSight.get(lineOfSight.size() - 1);
        HalfEdge3DReadOnly edgeBeforeLineOfSight = firstVisibleEdge.getPrevious();
        HalfEdge3DReadOnly edgeAfterLineOfSight = lastVisibleEdge.getNext();
        if (edgeBeforeLineOfSight.distanceFromSupportLine(observer) < epsilon) {
            firstVisibleEdge = edgeBeforeLineOfSight;
            lineOfSight.add(0, firstVisibleEdge);
        } else if (EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)edgeBeforeLineOfSight.getDestination(), (Point3DReadOnly)observer, (Point3DReadOnly)edgeBeforeLineOfSight.getOrigin()) < epsilon) {
            firstVisibleEdge = edgeBeforeLineOfSight;
            lineOfSight.add(0, firstVisibleEdge);
        }
        if (edgeAfterLineOfSight.distanceFromSupportLine(observer) < epsilon) {
            lastVisibleEdge = edgeAfterLineOfSight;
            lineOfSight.add(lastVisibleEdge);
        } else if (EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)edgeAfterLineOfSight.getOrigin(), (Point3DReadOnly)observer, (Point3DReadOnly)edgeAfterLineOfSight.getDestination()) < epsilon) {
            lastVisibleEdge = edgeAfterLineOfSight;
            lineOfSight.add(lastVisibleEdge);
        }
        return lineOfSight;
    }

    default public HalfEdge3DReadOnly lineOfSightStart(Point3DReadOnly observer) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.getNumberOfEdges() <= 2) {
            return this.getEdge(0);
        }
        HalfEdge3DReadOnly startEdge = this.getEdge(0);
        HalfEdge3DReadOnly currentEdge = startEdge;
        boolean edgeVisible = this.canObserverSeeEdge(observer, currentEdge);
        if (edgeVisible) {
            do {
                if (this.canObserverSeeEdge(observer, currentEdge = currentEdge.getPrevious())) continue;
                return currentEdge.getNext();
            } while (currentEdge != startEdge);
        } else {
            do {
                if (!this.canObserverSeeEdge(observer, currentEdge = currentEdge.getNext())) continue;
                return currentEdge;
            } while (currentEdge != startEdge);
        }
        return null;
    }

    default public HalfEdge3DReadOnly lineOfSightEnd(Point3DReadOnly observer) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.getNumberOfEdges() <= 2) {
            return this.getEdge(0);
        }
        HalfEdge3DReadOnly startEdge = this.getEdge(0);
        HalfEdge3DReadOnly currentEdge = startEdge;
        boolean edgeVisible = this.canObserverSeeEdge(observer, currentEdge);
        if (edgeVisible) {
            do {
                if (this.canObserverSeeEdge(observer, currentEdge = currentEdge.getNext())) continue;
                return currentEdge.getPrevious();
            } while (currentEdge != startEdge);
        } else {
            do {
                if (!this.canObserverSeeEdge(observer, currentEdge = currentEdge.getPrevious())) continue;
                return currentEdge;
            } while (currentEdge != startEdge);
        }
        return null;
    }

    default public boolean canObserverSeeEdge(Point3DReadOnly observer, int index) {
        return this.canObserverSeeEdge(observer, this.getEdge(index));
    }

    default public boolean canObserverSeeEdge(Point3DReadOnly observer, HalfEdge3DReadOnly edge) {
        return EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D(observer, (Point3DReadOnly)edge.getOrigin(), edge.getDestination(), this.getNormal());
    }

    default public boolean canObserverSeeFace(Point3DReadOnly observer) {
        return EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)observer, (Point3DReadOnly)this.getCentroid(), (Vector3DReadOnly)this.getNormal());
    }

    default public boolean canObserverSeeFace(Point3DReadOnly observer, double epsilon) {
        return this.signedDistanceFromSupportPlane(observer) > epsilon;
    }

    default public boolean isPointInFaceSupportPlane(Point3DReadOnly query, double epsilon) {
        if (this.getNumberOfEdges() < 3) {
            return this.getEdge(0).distanceSquared(query) <= epsilon * epsilon;
        }
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)query, (Point3DReadOnly)this.getCentroid(), (Vector3DReadOnly)this.getNormal()) < epsilon;
    }

    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        if (this.getNumberOfEdges() < 3) {
            return this.getEdge(0).distanceSquared(query) <= epsilon * epsilon;
        }
        if (!this.getBoundingBox().isInsideEpsilon(query, epsilon)) {
            return false;
        }
        return this.isPointInFaceSupportPlane(query, epsilon) && this.isPointDirectlyAboveOrBelow(query);
    }

    default public boolean isPointDirectlyAboveOrBelow(Point3DReadOnly query) {
        HalfEdge3DReadOnly startEdge;
        if (this.getNumberOfEdges() < 3) {
            return false;
        }
        HalfEdge3DReadOnly edge = startEdge = this.getEdge(0);
        do {
            if (!this.canObserverSeeEdge(query, edge)) continue;
            return false;
        } while ((edge = edge.getNext()) != startEdge);
        return true;
    }

    default public Face3DReadOnly getNeighbor(int index) {
        HalfEdge3DReadOnly twinEdge = this.getEdge(index).getTwin();
        if (twinEdge == null) {
            return null;
        }
        return twinEdge.getFace();
    }

    default public HalfEdge3DReadOnly getCommonEdgeWith(Face3DReadOnly neighbor) {
        for (int i = 0; i < this.getNumberOfEdges(); ++i) {
            if (this.getNeighbor(i) != neighbor) continue;
            return this.getEdge(i);
        }
        return null;
    }

    default public HalfEdge3DReadOnly getClosestEdge(Point3DReadOnly query) {
        HalfEdge3DReadOnly startEdge;
        HalfEdge3DReadOnly closestEdge = startEdge = this.getEdge(0);
        double minDistanceSquared = startEdge.distanceSquared(query);
        for (HalfEdge3DReadOnly currentEdge = startEdge.getNext(); currentEdge != startEdge; currentEdge = currentEdge.getNext()) {
            double distanceSquared = currentEdge.distanceSquared(query);
            if (!(distanceSquared < minDistanceSquared)) continue;
            closestEdge = currentEdge;
            minDistanceSquared = distanceSquared;
        }
        return closestEdge;
    }

    default public HalfEdge3DReadOnly getClosestVisibleEdge(Point3DReadOnly query) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.getNumberOfEdges() < 3) {
            return this.getEdge(0);
        }
        HalfEdge3DReadOnly closestVisibleEdge = null;
        double distanceSquaredToClosestVisibleEdge = Double.POSITIVE_INFINITY;
        HalfEdge3DReadOnly startEdge = this.getEdge(0);
        HalfEdge3DReadOnly currentEdge = startEdge;
        boolean edgeVisible = this.canObserverSeeEdge(query, currentEdge);
        if (edgeVisible) {
            double distanceSquared;
            distanceSquaredToClosestVisibleEdge = startEdge.distanceSquared(query);
            closestVisibleEdge = startEdge;
            while (this.canObserverSeeEdge(query, currentEdge = currentEdge.getPrevious())) {
                distanceSquared = currentEdge.distanceSquared(query);
                if (distanceSquared < distanceSquaredToClosestVisibleEdge) {
                    closestVisibleEdge = currentEdge;
                    distanceSquaredToClosestVisibleEdge = distanceSquared;
                }
                if (currentEdge != startEdge) continue;
            }
            currentEdge = startEdge;
            while (this.canObserverSeeEdge(query, currentEdge = currentEdge.getNext())) {
                distanceSquared = currentEdge.distanceSquared(query);
                if (distanceSquared < distanceSquaredToClosestVisibleEdge) {
                    closestVisibleEdge = currentEdge;
                    distanceSquaredToClosestVisibleEdge = distanceSquared;
                }
                if (currentEdge != startEdge) continue;
                break;
            }
        } else {
            do {
                if (this.canObserverSeeEdge(query, currentEdge = currentEdge.getNext())) {
                    double distanceSquared = currentEdge.distanceSquared(query);
                    if (!(distanceSquared < distanceSquaredToClosestVisibleEdge)) continue;
                    closestVisibleEdge = currentEdge;
                    distanceSquaredToClosestVisibleEdge = distanceSquared;
                    continue;
                }
                if (closestVisibleEdge != null) break;
            } while (currentEdge != startEdge);
        }
        return closestVisibleEdge;
    }

    default public double signedDistanceFromSupportPlane(Point3DReadOnly query) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)query, (Point3DReadOnly)this.getCentroid(), (Vector3DReadOnly)this.getNormal());
    }

    default public double distance(Point3DReadOnly query) {
        HalfEdge3DReadOnly closestVisibleEdge = this.getClosestVisibleEdge(query);
        if (closestVisibleEdge == null) {
            return this.distanceFromSupportPlane(query);
        }
        return closestVisibleEdge.distance(query);
    }

    default public double distanceFromSupportPlane(Point3DReadOnly query) {
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)query, (Point3DReadOnly)this.getCentroid(), (Vector3DReadOnly)this.getNormal());
    }

    default public Point3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        Point3D projection = new Point3D();
        if (this.orthogonalProjection(pointToProject, (Point3DBasics)projection)) {
            return projection;
        }
        return null;
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        HalfEdge3DReadOnly closestVisibleEdge = this.getClosestVisibleEdge(pointToProject);
        if (closestVisibleEdge == null) {
            return EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)this.getCentroid(), (Vector3DReadOnly)this.getNormal(), (Point3DBasics)projectionToPack);
        }
        return closestVisibleEdge.orthogonalProjection(pointToProject, projectionToPack);
    }

    @Override
    default public Vertex3DReadOnly getSupportingVertex(Vector3DReadOnly supportDirection) {
        if (this.isEmpty()) {
            return null;
        }
        HalfEdge3DReadOnly startEdge = this.getEdge(0);
        Vertex3DReadOnly supportingVertex = startEdge.getOrigin();
        double maxDot = supportingVertex.dot(supportDirection);
        for (HalfEdge3DReadOnly currentEdge = startEdge.getNext(); currentEdge != startEdge; currentEdge = currentEdge.getNext()) {
            Vertex3DReadOnly candidate = currentEdge.getOrigin();
            double currentDot = candidate.dot(supportDirection);
            if (!(currentDot > maxDot)) continue;
            maxDot = currentDot;
            supportingVertex = candidate;
        }
        return supportingVertex;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        if (this.isEmpty()) {
            return false;
        }
        supportingVertexToPack.set((Tuple3DReadOnly)this.getSupportingVertex(supportDirection));
        return true;
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Face3DReadOnly)) {
            return false;
        }
        Face3DReadOnly other = (Face3DReadOnly)geometry;
        if (this.getNumberOfEdges() != other.getNumberOfEdges()) {
            return false;
        }
        for (int edgeIndex = 0; edgeIndex < this.getNumberOfEdges(); ++edgeIndex) {
            if (this.getEdge(edgeIndex).epsilonEquals((EuclidGeometry)other.getEdge(edgeIndex), epsilon)) continue;
            return false;
        }
        return true;
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Face3DReadOnly)) {
            return false;
        }
        Face3DReadOnly other = (Face3DReadOnly)geometry;
        if (this.getNumberOfEdges() != other.getNumberOfEdges()) {
            return false;
        }
        HalfEdge3DReadOnly startEdge = null;
        HalfEdge3DReadOnly otherCurrentEdge = other.getEdge(0);
        HalfEdge3DReadOnly thisCurrentEdge = null;
        for (int edgeIndex = 0; edgeIndex < this.getNumberOfEdges(); ++edgeIndex) {
            thisCurrentEdge = this.getEdge(edgeIndex);
            if (thisCurrentEdge.geometricallyEquals((EuclidGeometry)otherCurrentEdge, epsilon)) continue;
            startEdge = thisCurrentEdge;
            break;
        }
        if (startEdge == null) {
            return false;
        }
        do {
            otherCurrentEdge.getNext();
            thisCurrentEdge.getNext();
            if (thisCurrentEdge.geometricallyEquals((EuclidGeometry)otherCurrentEdge, epsilon)) continue;
            return false;
        } while (thisCurrentEdge != startEdge);
        return true;
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Face3DReadOnly)) {
            return false;
        }
        Face3DReadOnly other = (Face3DReadOnly)geometry;
        if (this.getNumberOfEdges() != other.getNumberOfEdges()) {
            return false;
        }
        for (int edgeIndex = 0; edgeIndex < this.getNumberOfEdges(); ++edgeIndex) {
            if (this.getEdge(edgeIndex).equals((EuclidGeometry)other.getEdge(edgeIndex))) continue;
            return false;
        }
        return true;
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getFace3DString(format, this);
    }
}

