/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.epa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.collision.epa.EPAHalfEdge3D;
import us.ihmc.euclid.shape.collision.gjk.GJKVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class EPAVertex3D
implements Vertex3DReadOnly {
    private final double x;
    private final double y;
    private final double z;
    private final Point3DReadOnly vertexOnShapeA;
    private final Point3DReadOnly vertexOnShapeB;
    private final List<EPAHalfEdge3D> associatedEdges = new ArrayList<EPAHalfEdge3D>();

    public EPAVertex3D(GJKVertex3D gjkVertex3D) {
        this.vertexOnShapeA = gjkVertex3D.getVertexOnShapeA();
        this.vertexOnShapeB = gjkVertex3D.getVertexOnShapeB();
        this.x = gjkVertex3D.getX();
        this.y = gjkVertex3D.getY();
        this.z = gjkVertex3D.getZ();
    }

    public EPAVertex3D(Point3DReadOnly vertexOnShapeA, Point3DReadOnly vertexOnShapeB) {
        this.vertexOnShapeA = vertexOnShapeA;
        this.vertexOnShapeB = vertexOnShapeB;
        this.x = vertexOnShapeA.getX() - vertexOnShapeB.getX();
        this.y = vertexOnShapeA.getY() - vertexOnShapeB.getY();
        this.z = vertexOnShapeA.getZ() - vertexOnShapeB.getZ();
    }

    public void removeAssociatedEdge(int indexOfEdgeToRemove) {
        int indexOfLastElement = this.associatedEdges.size() - 1;
        if (indexOfEdgeToRemove != indexOfLastElement) {
            Collections.swap(this.associatedEdges, indexOfEdgeToRemove, indexOfLastElement);
        }
        this.associatedEdges.remove(indexOfLastElement);
    }

    public boolean removeAssociatedEdge(EPAHalfEdge3D edgeToRemove) {
        return this.associatedEdges.remove(edgeToRemove);
    }

    public void clearAssociatedEdgeList() {
        this.associatedEdges.clear();
    }

    public boolean addAssociatedEdge(EPAHalfEdge3D edgeToAdd) {
        if (!this.isEdgeAssociated(edgeToAdd)) {
            if (edgeToAdd.getOrigin() != this) {
                throw new IllegalArgumentException("A vertex's associated edges should originate from this same vertex.");
            }
            this.associatedEdges.add(edgeToAdd);
            return true;
        }
        return false;
    }

    @Override
    public EPAHalfEdge3D getEdgeTo(Vertex3DReadOnly destination) {
        return (EPAHalfEdge3D)Vertex3DReadOnly.super.getEdgeTo(destination);
    }

    @Override
    public int getNumberOfAssociatedEdges() {
        return this.associatedEdges.size();
    }

    public List<EPAHalfEdge3D> getAssociatedEdges() {
        return this.associatedEdges;
    }

    @Override
    public EPAHalfEdge3D getAssociatedEdge(int index) {
        return this.associatedEdges.get(index);
    }

    public Point3DReadOnly getVertexOnShapeA() {
        return this.vertexOnShapeA;
    }

    public Point3DReadOnly getVertexOnShapeB() {
        return this.vertexOnShapeB;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex3DReadOnly) {
            return this.equals((EuclidGeometry)((Vertex3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        long hashCode = 1L;
        hashCode = EuclidHashCodeTools.addToHashCode((long)hashCode, (double)this.x);
        hashCode = EuclidHashCodeTools.addToHashCode((long)hashCode, (double)this.y);
        hashCode = EuclidHashCodeTools.addToHashCode((long)hashCode, (double)this.z);
        return EuclidHashCodeTools.toIntHashCode((long)hashCode);
    }

    public String toString() {
        return "EPA " + this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

