/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.impl;

import us.ihmc.euclid.geometry.interfaces.LineSegment3DBasics;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;

public abstract class AbstractHalfEdge3D<Vertex extends AbstractVertex3D<Vertex, Edge, Face>, Edge extends AbstractHalfEdge3D<Vertex, Edge, Face>, Face extends AbstractFace3D<Vertex, Edge, Face>>
implements HalfEdge3DReadOnly,
LineSegment3DBasics {
    private Vertex origin;
    private Vertex destination;
    private Edge twin;
    private Edge next;
    private Edge previous;
    private Face face;

    public AbstractHalfEdge3D(Vertex origin, Vertex destination) {
        this.setOrigin(origin);
        this.setDestination(destination);
    }

    public void setOrigin(Vertex origin) {
        if (this.origin != null) {
            ((AbstractVertex3D)this.origin).removeAssociatedEdge((AbstractHalfEdge3D)this);
        }
        this.origin = origin;
        if (this.origin != null) {
            ((AbstractVertex3D)this.origin).addAssociatedEdge((AbstractHalfEdge3D)this);
        }
    }

    public Vertex getOrigin() {
        return this.origin;
    }

    public void setDestination(Vertex destination) {
        this.destination = destination;
    }

    public Vertex getDestination() {
        return this.destination;
    }

    public void setTwin(Edge twin) {
        if (twin != null && (((AbstractHalfEdge3D)twin).getDestination() != this.origin || ((AbstractHalfEdge3D)twin).getOrigin() != this.destination)) {
            throw new IllegalArgumentException("Twin does not match: this edge:\n" + this + "\ntwin:\n" + twin);
        }
        this.twin = twin;
    }

    public Edge getTwin() {
        return this.twin;
    }

    public void setNext(Edge next) {
        if (next != null && (((AbstractHalfEdge3D)next).getOrigin() != this.getDestination() || ((AbstractHalfEdge3D)next).getFace() != this.getFace())) {
            throw new IllegalArgumentException("Mismatch between vertices, destination vertex: " + ((AbstractVertex3D)this.getDestination()).toString() + " , next origin: " + ((AbstractVertex3D)((AbstractHalfEdge3D)next).getOrigin()).toString());
        }
        this.next = next;
    }

    public Edge getNext() {
        return this.next;
    }

    public void setPrevious(Edge previous) {
        if (previous != null && (((AbstractHalfEdge3D)previous).getDestination() != this.getOrigin() || ((AbstractHalfEdge3D)previous).getFace() != this.getFace())) {
            throw new IllegalArgumentException("Mismatch between vertices, origin vertex: " + ((AbstractVertex3D)this.getOrigin()).toString() + " , previous destination: " + ((AbstractVertex3D)((AbstractHalfEdge3D)previous).getDestination()).toString());
        }
        this.previous = previous;
    }

    public Edge getPrevious() {
        return this.previous;
    }

    public void setFace(Face face) {
        this.face = face;
    }

    public Face getFace() {
        return this.face;
    }

    public Point3DBasics getFirstEndpoint() {
        return this.getOrigin();
    }

    public Point3DBasics getSecondEndpoint() {
        return this.getDestination();
    }

    public void destroy() {
        if (this.twin != null && ((AbstractHalfEdge3D)this.twin).getTwin() == this) {
            ((AbstractHalfEdge3D)this.twin).setTwin(null);
        }
        if (this.next != null && ((AbstractHalfEdge3D)this.next).getPrevious() == this) {
            ((AbstractHalfEdge3D)this.next).setPrevious(null);
        }
        if (this.previous != null && ((AbstractHalfEdge3D)this.previous).getNext() == this) {
            ((AbstractHalfEdge3D)this.previous).setNext(null);
        }
        this.setTwin(null);
        this.setNext(null);
        this.setPrevious(null);
        this.setFace(null);
        this.setOrigin(null);
        this.setDestination(null);
    }

    public void flip() {
        Vertex newDestination = this.origin;
        this.setOrigin(this.destination);
        this.setDestination(newDestination);
        Edge newNext = this.previous;
        this.previous = this.next;
        this.next = newNext;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HalfEdge3DReadOnly) {
            return HalfEdge3DReadOnly.super.equals((HalfEdge3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getOrigin(), (Object)this.getDestination());
    }

    public String toString() {
        return EuclidShapeIOTools.getHalfEdge3DString(this);
    }
}

