/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.RampPolytope3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.RampPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Ramp3D
implements Ramp3DBasics,
GeometryObject<Ramp3D> {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private final Shape3DPose pose = new Shape3DPose();
    private IntermediateVariableSupplier supplier = IntermediateVariableSupplier.defaultIntermediateVariableSupplier();
    private final Vector3DBasics size = EuclidCoreFactories.newObservableVector3DBasics((axis, newValue) -> {
        this.checkSizePositive((Axis3D)axis);
        this.notifyChangeListeners();
    }, null);
    private boolean rampSurfaceNormalDirty = true;
    private final Vector3DBasics rampSurfaceNormal = EuclidCoreFactories.newObservableVector3DBasics(null, axis -> this.updateRampSurfaceNormal());
    private boolean rampFeaturesDirty = true;
    private double rampLength;
    private double angleOfRampIncline;
    private boolean centroidDirty = true;
    private final Point3DBasics centroid = EuclidCoreFactories.newObservablePoint3DBasics(null, axis -> this.updateCentroid());
    private RampPolytope3D polytopeView = null;

    public Ramp3D() {
        this(1.0, 1.0, 1.0);
    }

    public Ramp3D(double sizeX, double sizeY, double sizeZ) {
        this.getSize().set(sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public Ramp3D(Vector3DReadOnly size) {
        this.getSize().set((Tuple3DReadOnly)size);
        this.setupListeners();
    }

    public Ramp3D(Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.set(position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public Ramp3D(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.set(position, orientation, size);
        this.setupListeners();
    }

    public Ramp3D(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public Ramp3D(RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        this.setupListeners();
    }

    public Ramp3D(Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public Ramp3D(Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        this.setupListeners();
    }

    public Ramp3D(Ramp3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.changeListeners.add(() -> {
            this.rampSurfaceNormalDirty = true;
            this.rampFeaturesDirty = true;
            this.centroidDirty = true;
        });
        this.pose.addChangeListeners(this.changeListeners);
    }

    private void updateRamp() {
        if (!this.rampFeaturesDirty) {
            return;
        }
        this.rampLength = EuclidShapeTools.computeRamp3DLength(this.size.getX(), this.size.getZ());
        this.angleOfRampIncline = EuclidShapeTools.computeRamp3DIncline(this.size.getX(), this.size.getZ());
        this.rampFeaturesDirty = false;
    }

    private void updateRampSurfaceNormal() {
        if (!this.rampSurfaceNormalDirty) {
            return;
        }
        this.rampSurfaceNormal.set(-this.getSizeZ() / this.getRampLength(), 0.0, this.getSizeX() / this.getRampLength());
        this.transformToWorld((Transformable)this.rampSurfaceNormal);
        this.rampSurfaceNormalDirty = false;
    }

    private void updateCentroid() {
        if (!this.centroidDirty) {
            return;
        }
        EuclidShapeTools.computeRamp3DCentroid(this.pose, (Vector3DReadOnly)this.size, this.centroid);
        this.centroidDirty = false;
    }

    public void set(Ramp3D other) {
        Ramp3DBasics.super.set(other);
    }

    @Override
    public Shape3DPose getPose() {
        return this.pose;
    }

    @Override
    public Vector3DBasics getSize() {
        return this.size;
    }

    @Override
    public Point3DReadOnly getCentroid() {
        return this.centroid;
    }

    @Override
    public Vector3DReadOnly getRampSurfaceNormal() {
        return this.rampSurfaceNormal;
    }

    @Override
    public void getRampSurfaceNormal(Vector3DBasics surfaceNormalToPack) {
        surfaceNormalToPack.set((Tuple3DReadOnly)this.rampSurfaceNormal);
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
        this.pose.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        boolean hasBeenRemoved = this.changeListeners.remove(listener);
        return hasBeenRemoved |= this.pose.removeChangeListener(listener);
    }

    @Override
    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.supplier;
    }

    @Override
    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.supplier = newSupplier;
    }

    @Override
    public double getRampLength() {
        this.updateRamp();
        return this.rampLength;
    }

    @Override
    public double getRampIncline() {
        this.updateRamp();
        return this.angleOfRampIncline;
    }

    @Override
    public Ramp3D copy() {
        return new Ramp3D(this);
    }

    @Override
    public RampPolytope3DView asConvexPolytope() {
        if (this.polytopeView == null) {
            this.polytopeView = new RampPolytope3D(this);
        }
        return this.polytopeView;
    }

    public boolean epsilonEquals(Ramp3D other, double epsilon) {
        return Ramp3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(Ramp3D other, double epsilon) {
        return Ramp3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof Ramp3DReadOnly) {
            return Ramp3DBasics.super.equals((Ramp3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.pose, (Object)this.size);
    }

    public String toString() {
        return EuclidShapeIOTools.getRamp3DString(this);
    }
}

