/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Capsule3D
implements Capsule3DBasics,
GeometryObject<Capsule3D> {
    private final Point3D position = new Point3D();
    private final UnitVector3D axis = new UnitVector3D((Tuple3DReadOnly)Axis3D.Z);
    private double radius;
    private double length;
    private double halfLength;
    private final Point3DReadOnly topCenter = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.halfLength * this.axis.getX() + this.position.getX(), () -> this.halfLength * this.axis.getY() + this.position.getY(), () -> this.halfLength * this.axis.getZ() + this.position.getZ());
    private final Point3DReadOnly bottomCenter = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> -this.halfLength * this.axis.getX() + this.position.getX(), () -> -this.halfLength * this.axis.getY() + this.position.getY(), () -> -this.halfLength * this.axis.getZ() + this.position.getZ());

    public Capsule3D() {
        this(1.0, 0.5);
    }

    public Capsule3D(double length, double radius) {
        this.setSize(length, radius);
    }

    public Capsule3D(Point3DReadOnly position, Vector3DReadOnly axis, double length, double radius) {
        this.set(position, axis, length, radius);
    }

    public Capsule3D(Capsule3DReadOnly other) {
        this.set(other);
    }

    public void set(Capsule3D other) {
        Capsule3DBasics.super.set(other);
    }

    @Override
    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Capsule3D cannot be negative: " + radius);
        }
        this.radius = radius;
    }

    @Override
    public void setLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("The length of a Capsule3D cannot be negative: " + length);
        }
        this.length = length;
        this.halfLength = 0.5 * length;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public double getHalfLength() {
        return this.halfLength;
    }

    @Override
    public Point3DBasics getPosition() {
        return this.position;
    }

    @Override
    public UnitVector3DBasics getAxis() {
        return this.axis;
    }

    @Override
    public Point3DReadOnly getTopCenter() {
        return this.topCenter;
    }

    @Override
    public Point3DReadOnly getBottomCenter() {
        return this.bottomCenter;
    }

    @Override
    public Capsule3D copy() {
        return new Capsule3D(this);
    }

    public boolean epsilonEquals(Capsule3D other, double epsilon) {
        return Capsule3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(Capsule3D other, double epsilon) {
        return Capsule3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof Capsule3DReadOnly) {
            return Capsule3DBasics.super.equals((Capsule3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.toLongHashCode((double)this.length, (double)this.radius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((Object)this.position, (Object)this.axis));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return EuclidShapeIOTools.getCapsule3DString(this);
    }
}

