/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.interfaces;

import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface EuclidShape3DCollisionResultReadOnly {
    public boolean areShapesColliding();

    default public double getDistance() {
        return Math.abs(this.getSignedDistance());
    }

    public double getSignedDistance();

    public Shape3DReadOnly getShapeA();

    public Shape3DReadOnly getShapeB();

    public Point3DReadOnly getPointOnA();

    public Point3DReadOnly getPointOnB();

    public Vector3DReadOnly getNormalOnA();

    public Vector3DReadOnly getNormalOnB();

    default public boolean containsNaN() {
        if (Double.isNaN(this.getSignedDistance())) {
            return true;
        }
        if (this.getPointOnA().containsNaN() || this.getNormalOnA().containsNaN()) {
            return true;
        }
        return this.getPointOnB().containsNaN() || this.getNormalOnB().containsNaN();
    }

    default public boolean epsilonEquals(EuclidShape3DCollisionResultReadOnly other, double epsilon) {
        if (this.getShapeA() != other.getShapeA()) {
            return false;
        }
        if (this.getShapeB() != other.getShapeB()) {
            return false;
        }
        if (this.areShapesColliding() != other.areShapesColliding()) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getSignedDistance(), (double)other.getSignedDistance(), (double)epsilon)) {
            return false;
        }
        if (this.getPointOnA().containsNaN() ? !other.getPointOnA().containsNaN() : !this.getPointOnA().epsilonEquals((Tuple3DReadOnly)other.getPointOnA(), epsilon)) {
            return false;
        }
        if (this.getPointOnB().containsNaN() ? !other.getPointOnB().containsNaN() : !this.getPointOnB().epsilonEquals((Tuple3DReadOnly)other.getPointOnB(), epsilon)) {
            return false;
        }
        if (this.getNormalOnA().containsNaN() ? !other.getNormalOnA().containsNaN() : !this.getNormalOnA().epsilonEquals((Tuple3DReadOnly)other.getNormalOnA(), epsilon)) {
            return false;
        }
        return !(this.getNormalOnB().containsNaN() ? !other.getNormalOnB().containsNaN() : !this.getNormalOnB().epsilonEquals((Tuple3DReadOnly)other.getNormalOnB(), epsilon));
    }

    default public boolean geometricallyEquals(EuclidShape3DCollisionResultReadOnly other, double epsilon) {
        return this.geometricallyEquals(other, epsilon, epsilon, epsilon);
    }

    default public boolean geometricallyEquals(EuclidShape3DCollisionResultReadOnly other, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        Vector3DReadOnly otherNormalOnB;
        if (this.areShapesColliding() != other.areShapesColliding()) {
            return false;
        }
        if (Double.isNaN(this.getSignedDistance()) ? !Double.isNaN(other.getSignedDistance()) : !EuclidCoreTools.epsilonEquals((double)this.getSignedDistance(), (double)other.getSignedDistance(), (double)distanceEpsilon)) {
            return false;
        }
        boolean swap = this.getShapeA() != null || this.getShapeB() != null || other.getShapeA() != null || other.getShapeB() != null ? this.getShapeA() != other.getShapeA() : !this.getPointOnA().geometricallyEquals(other.getPointOnA(), pointTangentialEpsilon);
        Shape3DReadOnly otherShapeA = swap ? other.getShapeB() : other.getShapeA();
        Shape3DReadOnly otherShapeB = swap ? other.getShapeA() : other.getShapeB();
        Point3DReadOnly otherPointOnA = swap ? other.getPointOnB() : other.getPointOnA();
        Point3DReadOnly otherPointOnB = swap ? other.getPointOnA() : other.getPointOnB();
        Vector3DReadOnly otherNormalOnA = swap ? other.getNormalOnB() : other.getNormalOnA();
        Vector3DReadOnly vector3DReadOnly = otherNormalOnB = swap ? other.getNormalOnA() : other.getNormalOnB();
        if (this.getShapeA() != otherShapeA) {
            return false;
        }
        if (this.getShapeB() != otherShapeB) {
            return false;
        }
        if (this.getPointOnA().containsNaN() || this.getPointOnB().containsNaN() || distanceEpsilon == pointTangentialEpsilon) {
            if (this.getPointOnA().containsNaN() ? !otherPointOnA.containsNaN() : !this.getPointOnA().geometricallyEquals(otherPointOnA, distanceEpsilon)) {
                return false;
            }
            if (this.getPointOnB().containsNaN() ? !otherPointOnB.containsNaN() : !this.getPointOnB().geometricallyEquals(otherPointOnB, distanceEpsilon)) {
                return false;
            }
        } else {
            double collisionVectorX = (this.getPointOnA().getX() - this.getPointOnB().getX()) / this.getDistance();
            double collisionVectorY = (this.getPointOnA().getY() - this.getPointOnB().getY()) / this.getDistance();
            double collisionVectorZ = (this.getPointOnA().getZ() - this.getPointOnB().getZ()) / this.getDistance();
            if (!EuclidShapeTools.geometricallyEquals(this.getPointOnA(), otherPointOnA, collisionVectorX, collisionVectorY, collisionVectorZ, distanceEpsilon, pointTangentialEpsilon)) {
                return false;
            }
            if (!EuclidShapeTools.geometricallyEquals(this.getPointOnB(), otherPointOnB, collisionVectorX, collisionVectorY, collisionVectorZ, distanceEpsilon, pointTangentialEpsilon)) {
                return false;
            }
        }
        if (this.getNormalOnA().containsNaN() ? !otherNormalOnA.containsNaN() : !this.getNormalOnA().geometricallyEquals(otherNormalOnA, normalEpsilon)) {
            return false;
        }
        return !(this.getNormalOnB().containsNaN() ? !otherNormalOnB.containsNaN() : !this.getNormalOnB().geometricallyEquals(otherNormalOnB, normalEpsilon));
    }

    default public boolean equals(EuclidShape3DCollisionResultReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.areShapesColliding() != other.areShapesColliding()) {
            return false;
        }
        if (Double.compare(this.getSignedDistance(), other.getSignedDistance()) != 0) {
            return false;
        }
        if (this.getShapeA() != other.getShapeA()) {
            return false;
        }
        if (this.getShapeB() != other.getShapeB()) {
            return false;
        }
        if (!this.getPointOnA().equals((Tuple3DReadOnly)other.getPointOnA())) {
            return false;
        }
        if (!this.getNormalOnA().equals((Tuple3DReadOnly)other.getNormalOnA())) {
            return false;
        }
        if (!this.getPointOnB().equals((Tuple3DReadOnly)other.getPointOnB())) {
            return false;
        }
        return this.getNormalOnB().equals((Tuple3DReadOnly)other.getNormalOnB());
    }
}

