/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.gjk;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.gjk.GJKSimplex3D;
import us.ihmc.euclid.shape.collision.gjk.GJKTools;
import us.ihmc.euclid.shape.collision.gjk.GJKVertex3D;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class GilbertJohnsonKeerthiCollisionDetector {
    private static final boolean VERBOSE = false;
    public static final double DEFAULT_TERMINAL_CONDITION_EPSILON = 1.0E-16;
    private static final double SUPPORT_DIRECTION_ZERO_COMPONENT = 1.234E-16;
    public static final double DEFAULT_EPSILON_SUPPORT_DIRECTION_SWITCH = 1.0E-6;
    private double epsilon = 1.0E-16;
    private double epsilonTriangleNormalSwitch = 1.0E-6;
    private int maxIterations = 500;
    private int numberOfIterations = 0;
    private GJKSimplex3D simplex = null;
    private boolean isInitialSupportDirectionProvided = false;
    private final Vector3D initialSupportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.Y);
    private final Vector3D supportDirection = new Vector3D();
    private final Vector3DReadOnly supportDirectionNegated = EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)this.supportDirection);
    private final Vector3D supportDirectionPrevious = new Vector3D();
    private TerminationType lastTerminationType = null;

    public EuclidShape3DCollisionResult evaluateCollision(Shape3DReadOnly shapeA, Shape3DReadOnly shapeB) {
        EuclidShape3DCollisionResult result = new EuclidShape3DCollisionResult();
        this.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)result);
        return result;
    }

    public boolean evaluateCollision(Shape3DReadOnly shapeA, Shape3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        boolean areColliding;
        if (!shapeA.isPrimitive() || !shapeB.isPrimitive()) {
            this.guessInitialSupportDirection(shapeA, shapeB);
            areColliding = this.evaluateCollision((SupportingVertexHolder)shapeA, (SupportingVertexHolder)shapeB, resultToPack);
        } else if (shapeA.isDefinedByPose()) {
            Shape3DPoseReadOnly poseA = shapeA.getPose();
            Shape3DBasics localShapeA = shapeA.copy();
            localShapeA.getPose().setToZero();
            Shape3DBasics localShapeB = shapeB.copy();
            localShapeB.applyInverseTransform((Transform)poseA);
            this.guessInitialSupportDirection(localShapeA, localShapeB);
            areColliding = this.evaluateCollision((SupportingVertexHolder)localShapeA, (SupportingVertexHolder)localShapeB, resultToPack);
            resultToPack.applyTransform((Transform)poseA);
        } else if (shapeB.isDefinedByPose()) {
            Shape3DPoseReadOnly poseB = shapeB.getPose();
            Shape3DBasics localShapeA = shapeA.copy();
            localShapeA.applyInverseTransform((Transform)poseB);
            Shape3DBasics localShapeB = shapeB.copy();
            localShapeB.getPose().setToZero();
            this.guessInitialSupportDirection(localShapeA, localShapeB);
            areColliding = this.evaluateCollision((SupportingVertexHolder)localShapeA, (SupportingVertexHolder)localShapeB, resultToPack);
            resultToPack.applyTransform((Transform)poseB);
        } else {
            this.guessInitialSupportDirection(shapeA, shapeB);
            areColliding = this.evaluateCollision((SupportingVertexHolder)shapeA, (SupportingVertexHolder)shapeB, resultToPack);
        }
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        return areColliding;
    }

    private void guessInitialSupportDirection(Shape3DReadOnly shapeA, Shape3DReadOnly shapeB) {
        if (this.isInitialSupportDirectionProvided) {
            return;
        }
        this.initialSupportDirection.sub((Tuple3DReadOnly)shapeB.getCentroid(), (Tuple3DReadOnly)shapeA.getCentroid());
    }

    public EuclidShape3DCollisionResult evaluateCollision(SupportingVertexHolder shapeA, SupportingVertexHolder shapeB) {
        EuclidShape3DCollisionResult result = new EuclidShape3DCollisionResult();
        this.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)result);
        return result;
    }

    public boolean evaluateCollision(SupportingVertexHolder shapeA, SupportingVertexHolder shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        GJKSimplex3D previousOutput = new GJKSimplex3D();
        this.supportDirection.set(this.initialSupportDirection);
        Point3DReadOnly vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)this.supportDirection);
        Point3DReadOnly vertexB = shapeB.getSupportingVertex(this.supportDirectionNegated);
        boolean areColliding = false;
        if (vertexA == null || vertexB == null) {
            this.simplex = null;
            areColliding = false;
        } else {
            double closestPointNormSquared = 1.0;
            for (int i = 0; i < this.maxIterations; ++i) {
                this.numberOfIterations = i;
                GJKVertex3D newVertex = new GJKVertex3D(vertexA, vertexB);
                if (previousOutput.contains(newVertex)) {
                    boolean retry = false;
                    if (this.supportDirection.getX() == 1.234E-16) {
                        this.supportDirection.setX(-1.234E-16);
                        retry = true;
                    } else if (this.supportDirection.getY() == 1.234E-16) {
                        this.supportDirection.setY(-1.234E-16);
                        retry = true;
                    } else if (this.supportDirection.getZ() == 1.234E-16) {
                        this.supportDirection.setZ(-1.234E-16);
                        retry = true;
                    }
                    if (retry) {
                        vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)this.supportDirection);
                        vertexB = shapeB.getSupportingVertex(this.supportDirectionNegated);
                        continue;
                    }
                    this.simplex = previousOutput;
                    this.supportDirection.set(this.supportDirectionPrevious);
                    areColliding = false;
                    this.lastTerminationType = TerminationType.EXISTING_VERTEX;
                    break;
                }
                if (Math.abs(closestPointNormSquared + newVertex.dot((Tuple3DReadOnly)this.supportDirection)) <= this.epsilon * closestPointNormSquared) {
                    this.simplex = previousOutput;
                    this.supportDirection.set(this.supportDirectionPrevious);
                    areColliding = false;
                    this.lastTerminationType = TerminationType.VERTEX_NO_PROGRESSION;
                    break;
                }
                GJKSimplex3D output = GJKTools.simplexClosestToOrigin(previousOutput.getVertices(), newVertex);
                if (output == null) {
                    this.simplex = previousOutput;
                    this.supportDirection.set(this.supportDirectionPrevious);
                    areColliding = false;
                    this.lastTerminationType = TerminationType.SIMPLEX_NULL;
                    break;
                }
                if (output.getDistanceSquaredToOrigin() >= previousOutput.getDistanceSquaredToOrigin()) {
                    this.simplex = previousOutput;
                    this.supportDirection.set(this.supportDirectionPrevious);
                    areColliding = false;
                    this.lastTerminationType = TerminationType.SIMPLEX_NO_PROGRESSION;
                    break;
                }
                closestPointNormSquared = output.getDistanceSquaredToOrigin();
                if (output.getNumberOfVertices() == 4 || closestPointNormSquared <= this.epsilon * output.getMaxDistanceSquaredToOrigin()) {
                    this.simplex = output;
                    areColliding = true;
                    this.lastTerminationType = TerminationType.COLLISION_DETECTED;
                    break;
                }
                this.supportDirectionPrevious.set(this.supportDirection);
                if (closestPointNormSquared < this.epsilonTriangleNormalSwitch && output.getNumberOfVertices() == 3) {
                    this.supportDirection.set(output.getTriangleNormal());
                } else {
                    this.supportDirection.setAndNegate((Tuple3DReadOnly)output.getClosestPointToOrigin());
                }
                if (Math.abs(this.supportDirection.getX()) == 0.0) {
                    this.supportDirection.setX(1.234E-16);
                } else if (Math.abs(this.supportDirection.getY()) == 0.0) {
                    this.supportDirection.setY(1.234E-16);
                } else if (Math.abs(this.supportDirection.getZ()) == 0.0) {
                    this.supportDirection.setZ(1.234E-16);
                }
                vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)this.supportDirection);
                vertexB = shapeB.getSupportingVertex(this.supportDirectionNegated);
                previousOutput = output;
            }
        }
        if (areColliding || this.simplex == null) {
            resultToPack.setToNaN();
        } else {
            resultToPack.setSignedDistance(this.simplex.getDistanceToOrigin());
            resultToPack.setShapeA(null);
            resultToPack.setShapeB(null);
            this.simplex.computePointOnA(resultToPack.getPointOnA());
            this.simplex.computePointOnB(resultToPack.getPointOnB());
            resultToPack.getNormalOnA().setToNaN();
            resultToPack.getNormalOnB().setToNaN();
        }
        resultToPack.setShapesAreColliding(areColliding);
        this.isInitialSupportDirectionProvided = false;
        this.initialSupportDirection.set((Tuple3DReadOnly)Axis3D.Y);
        return areColliding;
    }

    public void setInitialSupportDirection(Vector3DReadOnly initialSupportDirection) {
        this.isInitialSupportDirectionProvided = true;
        this.initialSupportDirection.set((Tuple3DReadOnly)initialSupportDirection);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setTerminalConditionEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setEpsilonTriangleNormalSwitch(double epsilon) {
        this.epsilonTriangleNormalSwitch = epsilon;
    }

    public double getTerminalConditionEpsilon() {
        return this.epsilon;
    }

    public double getEpsilonTriangleNormalSwitch() {
        return this.epsilonTriangleNormalSwitch;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public GJKSimplex3D getSimplex() {
        return this.simplex;
    }

    public Vector3DReadOnly getSupportDirection() {
        return this.supportDirection;
    }

    public TerminationType getLastTerminationType() {
        return this.lastTerminationType;
    }

    public static enum TerminationType {
        EXISTING_VERTEX("The last vertex of the Minkowski difference is exactly equal to one vertex of the previous simplex."),
        VERTEX_NO_PROGRESSION("Progression on new Minkowski difference is determined to be under expected progression."),
        SIMPLEX_NULL("Unable to update simplex, new vertex of the Minkowski difference likely to result in linearly dependent simplex."),
        SIMPLEX_NO_PROGRESSION("No progression."),
        COLLISION_DETECTED("Collision detected, distance to the origin is zero.");

        private final String description;

        private TerminationType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

