/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.gjk;

import us.ihmc.euclid.shape.collision.gjk.GJKVertex3D;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class GJKSimplex3D {
    private final GJKVertex3D[] vertices;
    private final double[] barycentricCoordinates;
    private final Point3D closestPointToOrigin;
    private final double distanceFromOriginSquared;
    private double distanceFromOrigin = Double.NaN;
    private double maxDistanceSquaredFromOrigin = Double.NEGATIVE_INFINITY;

    public GJKSimplex3D() {
        this.vertices = new GJKVertex3D[0];
        this.barycentricCoordinates = new double[0];
        this.closestPointToOrigin = null;
        this.distanceFromOriginSquared = Double.NaN;
    }

    public GJKSimplex3D(GJKVertex3D vertex) {
        this.vertices = new GJKVertex3D[1];
        this.barycentricCoordinates = new double[1];
        this.vertices[0] = vertex;
        this.barycentricCoordinates[0] = 1.0;
        this.closestPointToOrigin = new Point3D((Tuple3DReadOnly)vertex);
        this.distanceFromOriginSquared = vertex.distanceFromOriginSquared();
    }

    public GJKSimplex3D(GJKVertex3D[] vertices, double[] barycentricCoordinates) {
        this.vertices = vertices;
        this.barycentricCoordinates = barycentricCoordinates;
        this.closestPointToOrigin = new Point3D();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.closestPointToOrigin.scaleAdd(barycentricCoordinates[i], (Tuple3DReadOnly)vertices[i], (Tuple3DReadOnly)this.closestPointToOrigin);
        }
        this.distanceFromOriginSquared = this.closestPointToOrigin.distanceFromOriginSquared();
    }

    public boolean contains(GJKVertex3D query) {
        for (GJKVertex3D vertex : this.vertices) {
            if (!query.equals((Tuple3DReadOnly)vertex)) continue;
            return true;
        }
        return false;
    }

    public Point3D getClosestPointToOrigin() {
        return this.closestPointToOrigin;
    }

    public double getDistanceToOrigin() {
        if (Double.isNaN(this.distanceFromOrigin)) {
            this.distanceFromOrigin = EuclidCoreTools.squareRoot((double)this.getDistanceSquaredToOrigin());
        }
        return this.distanceFromOrigin;
    }

    public double getDistanceSquaredToOrigin() {
        return this.distanceFromOriginSquared;
    }

    public double getMaxDistanceSquaredToOrigin() {
        if (this.maxDistanceSquaredFromOrigin == Double.NEGATIVE_INFINITY) {
            for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                this.maxDistanceSquaredFromOrigin = Math.max(this.maxDistanceSquaredFromOrigin, this.vertices[i].distanceFromOriginSquared());
            }
        }
        return this.maxDistanceSquaredFromOrigin;
    }

    public Vector3D getTriangleNormal() {
        if (this.vertices.length != 3) {
            return null;
        }
        Vector3D n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(this.vertices[0], this.vertices[1], this.vertices[0], this.vertices[2]);
        if (TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)this.closestPointToOrigin) > 0.0) {
            n.negate();
        }
        return n;
    }

    public Point3D computePointOnA() {
        Point3D pointOnA = new Point3D();
        if (this.computePointOnA((Point3DBasics)pointOnA)) {
            return pointOnA;
        }
        return null;
    }

    public boolean computePointOnA(Point3DBasics pointOnAToPack) {
        if (this.getNumberOfVertices() == 0) {
            return false;
        }
        if (this.getNumberOfVertices() == 1) {
            pointOnAToPack.set((Tuple3DReadOnly)this.vertices[0].getVertexOnShapeA());
            return true;
        }
        pointOnAToPack.setAndScale(this.barycentricCoordinates[0], (Tuple3DReadOnly)this.vertices[0].getVertexOnShapeA());
        for (int i = 1; i < this.getNumberOfVertices(); ++i) {
            pointOnAToPack.scaleAdd(this.barycentricCoordinates[i], (Tuple3DReadOnly)this.vertices[i].getVertexOnShapeA(), (Tuple3DReadOnly)pointOnAToPack);
        }
        return true;
    }

    public Point3D computePointOnB() {
        Point3D pointOnB = new Point3D();
        if (this.computePointOnB((Point3DBasics)pointOnB)) {
            return pointOnB;
        }
        return null;
    }

    public boolean computePointOnB(Point3DBasics pointOnBToPack) {
        if (this.getNumberOfVertices() == 0) {
            return false;
        }
        if (this.getNumberOfVertices() == 1) {
            pointOnBToPack.set((Tuple3DReadOnly)this.vertices[0].getVertexOnShapeB());
            return true;
        }
        pointOnBToPack.setAndScale(this.barycentricCoordinates[0], (Tuple3DReadOnly)this.vertices[0].getVertexOnShapeB());
        for (int i = 1; i < this.getNumberOfVertices(); ++i) {
            pointOnBToPack.scaleAdd(this.barycentricCoordinates[i], (Tuple3DReadOnly)this.vertices[i].getVertexOnShapeB(), (Tuple3DReadOnly)pointOnBToPack);
        }
        return true;
    }

    public int getNumberOfVertices() {
        return this.vertices.length;
    }

    public GJKVertex3D[] getVertices() {
        return this.vertices;
    }
}

