/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.epa;

import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.collision.epa.EPAHalfEdge3D;
import us.ihmc.euclid.shape.collision.epa.EPATools;
import us.ihmc.euclid.shape.collision.epa.EPAVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EPAFace3D
implements Comparable<EPAFace3D>,
Face3DReadOnly {
    private final EPAVertex3D v0;
    private final EPAVertex3D v1;
    private final EPAVertex3D v2;
    private final EPAHalfEdge3D e0;
    private final EPAHalfEdge3D e1;
    private final EPAHalfEdge3D e2;
    private final Point3DReadOnly closestPointToOrigin;
    private final double lambda0;
    private final double lambda1;
    private final double lambda2;
    private final boolean isTriangleAffinelyDependent;
    private final boolean isClosestPointInternal;
    private final double distanceFromOriginSquared;
    private final Vector3D normal;
    private boolean obsolete = false;
    private double distanceFromOrigin = Double.NaN;

    public static EPAFace3D fromVertexAndTwinEdge(EPAVertex3D vertex, EPAHalfEdge3D twin, double epsilon) {
        EPAVertex3D v0 = twin.getDestination();
        EPAVertex3D v1 = twin.getOrigin();
        EPAVertex3D v2 = vertex;
        EPAFace3D face = new EPAFace3D(v0, v1, v2, epsilon);
        face.e0.setTwin(twin);
        return face;
    }

    public EPAFace3D(EPAVertex3D v0, EPAVertex3D v1, EPAVertex3D v2, double epsilon) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.e0 = new EPAHalfEdge3D(v0, v1, this);
        this.e1 = new EPAHalfEdge3D(v1, v2, this);
        this.e2 = new EPAHalfEdge3D(v2, v0, this);
        this.e0.setNext(this.e1);
        this.e1.setNext(this.e2);
        this.e2.setNext(this.e0);
        this.e0.setPrevious(this.e2);
        this.e1.setPrevious(this.e0);
        this.e2.setPrevious(this.e1);
        this.normal = EuclidPolytopeTools.crossProductOfLineSegment3Ds(v1, v0, v1, v2);
        double[] lambdas = new double[3];
        EPATools.BarycentricCoordinatesOutput output = EPATools.barycentricCoordinatesFrom2Simplex(v0, v1, v2, epsilon, lambdas);
        boolean bl = this.isTriangleAffinelyDependent = output == EPATools.BarycentricCoordinatesOutput.AFFINELY_DEPENDENT;
        if (!this.isTriangleAffinelyDependent()) {
            this.lambda0 = lambdas[0];
            this.lambda1 = lambdas[1];
            this.lambda2 = lambdas[2];
            this.isClosestPointInternal = output == EPATools.BarycentricCoordinatesOutput.INSIDE;
            Point3D point = new Point3D();
            point.setAndScale(this.lambda0, (Tuple3DReadOnly)v0);
            point.scaleAdd(this.lambda1, (Tuple3DReadOnly)v1, (Tuple3DReadOnly)point);
            point.scaleAdd(this.lambda2, (Tuple3DReadOnly)v2, (Tuple3DReadOnly)point);
            this.closestPointToOrigin = point;
            this.distanceFromOriginSquared = this.closestPointToOrigin.distanceFromOriginSquared();
        } else {
            this.lambda0 = Double.NaN;
            this.lambda1 = Double.NaN;
            this.lambda2 = Double.NaN;
            this.isClosestPointInternal = false;
            this.closestPointToOrigin = null;
            this.distanceFromOriginSquared = Double.NaN;
        }
    }

    public boolean contains(EPAVertex3D query) {
        return this.v0.equals(query) || this.v1.equals(query) || this.v2.equals(query);
    }

    @Override
    public boolean canObserverSeeFace(Point3DReadOnly observer) {
        return EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)observer, (Point3DReadOnly)this.v0, (Vector3DReadOnly)this.normal);
    }

    public Point3DReadOnly getClosestPointToOrigin() {
        return this.closestPointToOrigin;
    }

    public boolean isClosestPointInternal() {
        return this.isClosestPointInternal;
    }

    public double getDistanceToOrigin() {
        if (Double.isNaN(this.distanceFromOrigin)) {
            this.distanceFromOrigin = EuclidCoreTools.squareRoot((double)this.getDistanceSquaredToOrigin());
        }
        return this.distanceFromOrigin;
    }

    public double getDistanceSquaredToOrigin() {
        return this.distanceFromOriginSquared;
    }

    public boolean isTriangleAffinelyDependent() {
        return this.isTriangleAffinelyDependent;
    }

    public void markObsolete() {
        this.obsolete = true;
        this.e0.markObsolete();
        this.e1.markObsolete();
        this.e2.markObsolete();
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void computePointOnA(Point3DBasics pointOnAToPack) {
        pointOnAToPack.setAndScale(this.lambda0, (Tuple3DReadOnly)this.v0.getVertexOnShapeA());
        pointOnAToPack.scaleAdd(this.lambda1, (Tuple3DReadOnly)this.v1.getVertexOnShapeA(), (Tuple3DReadOnly)pointOnAToPack);
        pointOnAToPack.scaleAdd(this.lambda2, (Tuple3DReadOnly)this.v2.getVertexOnShapeA(), (Tuple3DReadOnly)pointOnAToPack);
    }

    public void computePointOnB(Point3DBasics pointOnBToPack) {
        pointOnBToPack.setAndScale(this.lambda0, (Tuple3DReadOnly)this.v0.getVertexOnShapeB());
        pointOnBToPack.scaleAdd(this.lambda1, (Tuple3DReadOnly)this.v1.getVertexOnShapeB(), (Tuple3DReadOnly)pointOnBToPack);
        pointOnBToPack.scaleAdd(this.lambda2, (Tuple3DReadOnly)this.v2.getVertexOnShapeB(), (Tuple3DReadOnly)pointOnBToPack);
    }

    @Override
    public int compareTo(EPAFace3D other) {
        if (this.getDistanceSquaredToOrigin() == other.getDistanceSquaredToOrigin()) {
            return 0;
        }
        if (this.getDistanceSquaredToOrigin() > other.getDistanceSquaredToOrigin()) {
            return 1;
        }
        return -1;
    }

    public EPAHalfEdge3D getEdge0() {
        return this.e0;
    }

    public EPAHalfEdge3D getEdge1() {
        return this.e1;
    }

    public EPAHalfEdge3D getEdge2() {
        return this.e2;
    }

    @Override
    public double getArea() {
        return EuclidGeometryTools.triangleArea((Point3DReadOnly)this.v0, (Point3DReadOnly)this.v1, (Point3DReadOnly)this.v2);
    }

    @Override
    public BoundingBox3DReadOnly getBoundingBox() {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        boundingBox3D.setToNaN();
        boundingBox3D.updateToIncludePoint((Point3DReadOnly)this.v0);
        boundingBox3D.updateToIncludePoint((Point3DReadOnly)this.v1);
        boundingBox3D.updateToIncludePoint((Point3DReadOnly)this.v2);
        return boundingBox3D;
    }

    @Override
    public Point3DReadOnly getCentroid() {
        return EuclidGeometryTools.averagePoint3Ds(Arrays.asList(this.v0, this.v1, this.v2));
    }

    @Override
    public List<? extends HalfEdge3DReadOnly> getEdges() {
        return Arrays.asList(this.e0, this.e1, this.e2);
    }

    @Override
    public Vector3DReadOnly getNormal() {
        return this.normal;
    }

    public boolean equals(Object object) {
        if (object instanceof Face3DReadOnly) {
            return this.equals((Face3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.v0.hashCode());
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.v1.hashCode());
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.v2.hashCode());
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return "EPA " + EuclidShapeIOTools.getFace3DString(this);
    }
}

