/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.shape.convexPolytope.tools.IcoSphereFactory;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.PointShape3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.Torus3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeRandomTools {
    private EuclidShapeRandomTools() {
    }

    public static Shape3DPose nextShape3DPose(Random random) {
        return new Shape3DPose((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
    }

    public static Box3D nextBox3D(Random random) {
        return EuclidShapeRandomTools.nextBox3D(random, 0.0, 1.0);
    }

    public static Box3D nextBox3D(Random random, double minSize, double maxSize) {
        return new Box3D((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)minSize, (double)maxSize), EuclidCoreRandomTools.nextDouble((Random)random, (double)minSize, (double)maxSize), EuclidCoreRandomTools.nextDouble((Random)random, (double)minSize, (double)maxSize));
    }

    public static Capsule3D nextCapsule3D(Random random) {
        return EuclidShapeRandomTools.nextCapsule3D(random, 0.0, 1.0, 0.0, 1.0);
    }

    public static Capsule3D nextCapsule3D(Random random, double minLength, double maxLength, double minRadius, double maxRadius) {
        return new Capsule3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)minLength, (double)maxLength), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius));
    }

    public static Cylinder3D nextCylinder3D(Random random) {
        return EuclidShapeRandomTools.nextCylinder3D(random, 0.0, 1.0, 0.0, 1.0);
    }

    public static Cylinder3D nextCylinder3D(Random random, double minLength, double maxLength, double minRadius, double maxRadius) {
        return new Cylinder3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)minLength, (double)maxLength), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius));
    }

    public static Ellipsoid3D nextEllipsoid3D(Random random) {
        return EuclidShapeRandomTools.nextEllipsoid3D(random, 0.0, 1.0);
    }

    public static Ellipsoid3D nextEllipsoid3D(Random random, double minRadius, double maxRadius) {
        return new Ellipsoid3D((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius));
    }

    public static PointShape3D nextPointShape3D(Random random) {
        return new PointShape3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
    }

    public static PointShape3D nextPointShape3D(Random random, double minMax) {
        return new PointShape3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax));
    }

    public static Ramp3D nextRamp3D(Random random) {
        return EuclidShapeRandomTools.nextRamp3D(random, 0.0, 1.0);
    }

    public static Ramp3D nextRamp3D(Random random, double minSize, double maxSize) {
        return new Ramp3D((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)minSize, (double)maxSize), EuclidCoreRandomTools.nextDouble((Random)random, (double)minSize, (double)maxSize), EuclidCoreRandomTools.nextDouble((Random)random, (double)minSize, (double)maxSize));
    }

    public static Sphere3D nextSphere3D(Random random) {
        return EuclidShapeRandomTools.nextSphere3D(random, 0.0, 1.0);
    }

    public static Sphere3D nextSphere3D(Random random, double minRadius, double maxRadius) {
        return new Sphere3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius));
    }

    public static Torus3D nextTorus3D(Random random) {
        return EuclidShapeRandomTools.nextTorus3D(random, 0.5, 2.0, 0.0, 0.5);
    }

    public static Torus3D nextTorus3D(Random random, double minRadius, double maxRadius, double minTubeRadius, double maxTubeRadius) {
        return new Torus3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius), EuclidCoreRandomTools.nextDouble((Random)random, (double)minTubeRadius, (double)maxTubeRadius));
    }

    public static Face3D nextCircleBasedFace3D(Random random) {
        return EuclidShapeRandomTools.nextCircleBasedFace3D(random, 5.0);
    }

    public static Face3D nextCircleBasedFace3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextCircleBasedFace3D(random, centerMinMax, 1.0, 15);
    }

    public static Face3D nextCircleBasedFace3D(Random random, double centerMinMax, double maxEdgeLength, int numberOfVertices) {
        return EuclidShapeRandomTools.nextCircleBasedFace3D(random, centerMinMax, maxEdgeLength, numberOfVertices, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
    }

    public static Face3D nextCircleBasedFace3D(Random random, double centerMinMax, double maxEdgeLength, int numberOfVertices, Vector3DReadOnly faceNormal) {
        List<Point3D> vertices = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D(random, centerMinMax, maxEdgeLength, numberOfVertices, faceNormal);
        Face3D face3D = new Face3D(faceNormal);
        vertices.forEach(vertex -> face3D.addVertex(new Vertex3D((Point3DReadOnly)vertex)));
        return face3D;
    }

    public static List<Point3D> nextCircleBasedConvexPolygon3D(Random random, double centerMinMax, double maxEdgeLength, int numberOfVertices, Vector3DReadOnly planeNormal) {
        return EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D(random, (Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax), maxEdgeLength, numberOfVertices, planeNormal);
    }

    public static List<Point3D> nextCircleBasedConvexPolygon3D(Random random, Point3DReadOnly center, double maxEdgeLength, int numberOfVertices, Vector3DReadOnly planeNormal) {
        List circleBasedConvexPolygon2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (Point2DReadOnly)new Point2D(), (double)maxEdgeLength, (int)numberOfVertices);
        List<Point3D> circleBasedConvexPolygon3D = circleBasedConvexPolygon2D.stream().map(Point3D::new).collect(Collectors.toList());
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set((Tuple3DReadOnly)center);
        transform.getRotation().set((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)planeNormal));
        circleBasedConvexPolygon3D.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
        return circleBasedConvexPolygon3D;
    }

    public static Point3D nextPoint3DOnFace3D(Random random, Face3DReadOnly face3D) {
        if (face3D.isEmpty()) {
            return null;
        }
        HalfEdge3DReadOnly edge = face3D.getEdge(random.nextInt(face3D.getNumberOfEdges()));
        return EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face3D.getCentroid(), (Point3DReadOnly)edge.getOrigin(), (Point3DReadOnly)edge.getDestination());
    }

    public static ConvexPolytope3D nextConvexPolytope3D(Random random) {
        switch (random.nextInt(7)) {
            case 0: {
                return EuclidShapeRandomTools.nextConeConvexPolytope3D(random);
            }
            case 1: {
                return EuclidShapeRandomTools.nextCubeConvexPolytope3D(random);
            }
            case 2: {
                return EuclidShapeRandomTools.nextCylinderConvexPolytope3D(random);
            }
            case 3: {
                return EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D(random);
            }
            case 4: {
                return EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D(random);
            }
            case 5: {
                return EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D(random);
            }
            case 6: {
                return EuclidShapeRandomTools.nextPyramidConvexPolytope3D(random);
            }
        }
        throw new RuntimeException("Unexpected state.");
    }

    public static ConvexPolytope3D nextConvexPolytope3DWithEdgeCases(Random random) {
        switch (random.nextInt(8)) {
            case 0: {
                return EuclidShapeRandomTools.nextConeConvexPolytope3D(random);
            }
            case 1: {
                return EuclidShapeRandomTools.nextCubeConvexPolytope3D(random);
            }
            case 2: {
                return EuclidShapeRandomTools.nextCylinderConvexPolytope3D(random);
            }
            case 3: {
                return EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D(random);
            }
            case 4: {
                return EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D(random);
            }
            case 5: {
                return EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D(random, 5.0, 5.0, random.nextInt(101));
            }
            case 6: {
                return EuclidShapeRandomTools.nextPyramidConvexPolytope3D(random);
            }
            case 7: {
                return EuclidShapeRandomTools.nextSingleEdgeConvexPolytope3D(random);
            }
        }
        throw new RuntimeException("Unexpected state.");
    }

    public static ConvexPolytope3D nextConeConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextConeConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextConeConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextConeConvexPolytope3D(random, centerMinMax, 0.1, 5.0, 0.1, 5.0, 3, 50);
    }

    public static ConvexPolytope3D nextConeConvexPolytope3D(Random random, double centerMinMax, double heightMin, double heightMax, double radiusMin, double radiusMax, int divisionsMin, int divisionsMax) {
        List<Point3D> coneVertices = EuclidPolytopeFactories.newConeVertices(EuclidCoreRandomTools.nextDouble((Random)random, (double)heightMin, (double)heightMax), EuclidCoreRandomTools.nextDouble((Random)random, (double)radiusMin, (double)radiusMax), random.nextInt(divisionsMax - divisionsMin + 1) + divisionsMin);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        transform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax));
        coneVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(coneVertices));
    }

    public static ConvexPolytope3D nextCubeConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextCubeConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextCubeConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextCubeConvexPolytope3D(random, centerMinMax, 0.1, 5.0);
    }

    public static ConvexPolytope3D nextCubeConvexPolytope3D(Random random, double centerMinMax, double edgeLengthMin, double edgeLengthMax) {
        List<Point3D> cubeVertices = EuclidPolytopeFactories.newCubeVertices(EuclidCoreRandomTools.nextDouble((Random)random, (double)edgeLengthMin, (double)edgeLengthMax));
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        transform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax));
        cubeVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(cubeVertices));
    }

    public static ConvexPolytope3D nextCylinderConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextCylinderConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextCylinderConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextCylinderConvexPolytope3D(random, centerMinMax, 0.1, 5.0, 0.1, 5.0, 3, 50);
    }

    public static ConvexPolytope3D nextCylinderConvexPolytope3D(Random random, double centerMinMax, double lengthMin, double lengthMax, double radiusMin, double radiusMax, int divisionsMin, int divisionsMax) {
        List<Point3D> cylinderVertices = EuclidPolytopeFactories.newCylinderVertices(EuclidCoreRandomTools.nextDouble((Random)random, (double)lengthMin, (double)lengthMax), EuclidCoreRandomTools.nextDouble((Random)random, (double)radiusMin, (double)radiusMax), random.nextInt(divisionsMax - divisionsMin + 1) + divisionsMin);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        transform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax));
        cylinderVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(cylinderVertices));
    }

    public static ConvexPolytope3D nextIcosahedronBasedConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextIcosahedronBasedConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D(random, centerMinMax, 0.1, 5.0);
    }

    public static ConvexPolytope3D nextIcosahedronBasedConvexPolytope3D(Random random, double centerMinMax, double radiusMin, double radiusMax) {
        return EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D(random, centerMinMax, 0, radiusMin, radiusMax);
    }

    public static ConvexPolytope3D nextIcoSphereBasedConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextIcoSphereBasedConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D(random, centerMinMax, 0.1, 5.0);
    }

    public static ConvexPolytope3D nextIcoSphereBasedConvexPolytope3D(Random random, double centerMinMax, double radiusMin, double radiusMax) {
        return EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D(random, centerMinMax, random.nextInt(3), radiusMin, radiusMax);
    }

    public static ConvexPolytope3D nextIcoSphereBasedConvexPolytope3D(Random random, double centerMinMax, int recursionLevel, double radiusMin, double radiusMax) {
        IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere(recursionLevel);
        AffineTransform transform = new AffineTransform();
        transform.setLinearTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random));
        transform.setTranslation((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax));
        transform.appendScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)radiusMin, (double)radiusMax));
        icoSphere.applyTransform((Transform)transform);
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(icoSphere.getVertices()));
    }

    public static ConvexPolytope3D nextPointCloudBasedConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextPointCloudBasedConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D(random, centerMinMax, 5.0);
    }

    public static ConvexPolytope3D nextPointCloudBasedConvexPolytope3D(Random random, double centerMinMax, double minMax) {
        return EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D(random, centerMinMax, minMax, 100);
    }

    public static ConvexPolytope3D nextPointCloudBasedConvexPolytope3D(Random random, double centerMinMax, double minMax, int numberOfPossiblePoints) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)EuclidGeometryRandomTools.nextPointCloud3D((Random)random, (double)centerMinMax, (double)minMax, (int)numberOfPossiblePoints)));
    }

    public static ConvexPolytope3D nextPyramidConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextPyramidConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextPyramidConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextPyramidConvexPolytope3D(random, centerMinMax, 0.1, 5.0, 0.1, 5.0, 0.1, 5.0);
    }

    public static ConvexPolytope3D nextPyramidConvexPolytope3D(Random random, double centerMinMax, double heightMin, double heightMax, double baseLengthMin, double baseLengthMax, double baseWidthMin, double baseWidthMax) {
        List<Point3D> pyramidVertices = EuclidPolytopeFactories.newPyramidVertices(EuclidCoreRandomTools.nextDouble((Random)random, (double)heightMin, (double)heightMax), EuclidCoreRandomTools.nextDouble((Random)random, (double)baseLengthMin, (double)baseLengthMax), EuclidCoreRandomTools.nextDouble((Random)random, (double)baseWidthMin, (double)baseWidthMax));
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        transform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax));
        pyramidVertices.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(pyramidVertices));
    }

    public static ConvexPolytope3D nextSingleEdgeConvexPolytope3D(Random random) {
        return EuclidShapeRandomTools.nextSingleEdgeConvexPolytope3D(random, 5.0);
    }

    public static ConvexPolytope3D nextSingleEdgeConvexPolytope3D(Random random, double centerMinMax) {
        return EuclidShapeRandomTools.nextSingleEdgeConvexPolytope3D(random, centerMinMax, 5.0);
    }

    public static ConvexPolytope3D nextSingleEdgeConvexPolytope3D(Random random, double centerMinMax, double minMax) {
        LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)minMax);
        Point3DBasics midpoint = lineSegment3D.midpoint();
        midpoint.negate();
        lineSegment3D.translate((Tuple3DReadOnly)midpoint);
        lineSegment3D.translate((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax));
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{lineSegment3D.getFirstEndpoint(), lineSegment3D.getSecondEndpoint()}));
    }

    public static ConvexPolytope3D nextTetrahedronContainingPoint3D(Random random, Point3DReadOnly point) {
        return EuclidShapeRandomTools.nextTetrahedronContainingPoint3D(random, point, 5.0);
    }

    public static ConvexPolytope3D nextTetrahedronContainingPoint3D(Random random, Point3DReadOnly point, double minMax) {
        List vertices = EuclidGeometryRandomTools.nextPointCloud3D((Random)random, (double)0.0, (double)minMax, (int)4);
        ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((List)vertices));
        assert (tetrahedron.getNumberOfVertices() == 4);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)((Point3DReadOnly)vertices.get(0)), (Point3DReadOnly)((Point3DReadOnly)vertices.get(1)), (Point3DReadOnly)((Point3DReadOnly)vertices.get(2)), (Point3DReadOnly)((Point3DReadOnly)vertices.get(3))));
        tetrahedron.applyTransform((Transform)transform);
        assert (tetrahedron.isPointInside(point));
        return tetrahedron;
    }

    public static Shape3DBasics nextShape3D(Random random) {
        switch (random.nextInt(9)) {
            case 0: {
                return EuclidShapeRandomTools.nextBox3D(random);
            }
            case 1: {
                return EuclidShapeRandomTools.nextCapsule3D(random);
            }
            case 2: {
                return EuclidShapeRandomTools.nextConvexPolytope3D(random);
            }
            case 3: {
                return EuclidShapeRandomTools.nextCylinder3D(random);
            }
            case 4: {
                return EuclidShapeRandomTools.nextEllipsoid3D(random);
            }
            case 5: {
                return EuclidShapeRandomTools.nextPointShape3D(random);
            }
            case 6: {
                return EuclidShapeRandomTools.nextRamp3D(random);
            }
            case 7: {
                return EuclidShapeRandomTools.nextSphere3D(random);
            }
            case 8: {
                return EuclidShapeRandomTools.nextTorus3D(random);
            }
        }
        throw new RuntimeException("Unexpected state.");
    }

    public static Shape3DBasics nextConvexShape3D(Random random) {
        switch (random.nextInt(8)) {
            case 0: {
                return EuclidShapeRandomTools.nextBox3D(random);
            }
            case 1: {
                return EuclidShapeRandomTools.nextCapsule3D(random);
            }
            case 2: {
                return EuclidShapeRandomTools.nextConvexPolytope3D(random);
            }
            case 3: {
                return EuclidShapeRandomTools.nextCylinder3D(random);
            }
            case 4: {
                return EuclidShapeRandomTools.nextEllipsoid3D(random);
            }
            case 5: {
                return EuclidShapeRandomTools.nextPointShape3D(random);
            }
            case 6: {
                return EuclidShapeRandomTools.nextRamp3D(random);
            }
            case 7: {
                return EuclidShapeRandomTools.nextSphere3D(random);
            }
        }
        throw new RuntimeException("Unexpected state.");
    }

    public static EuclidShape3DCollisionResult nextEuclidShape3DCollisionResult(Random random) {
        EuclidShape3DCollisionResult next = new EuclidShape3DCollisionResult();
        next.setShapeA(EuclidShapeRandomTools.nextShape3D(random));
        next.setShapeB(EuclidShapeRandomTools.nextShape3D(random));
        next.setShapesAreColliding(random.nextBoolean());
        next.setSignedDistance(next.areShapesColliding() ? -random.nextDouble() : random.nextDouble());
        next.getPointOnA().set(EuclidCoreRandomTools.nextPoint3D((Random)random));
        next.getPointOnB().set(EuclidCoreRandomTools.nextPoint3D((Random)random));
        next.getNormalOnA().set(EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
        next.getNormalOnB().set(EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
        return next;
    }

    public static Shape3DBasics nextConvexShape3D(Random random, Tuple3DReadOnly shapeCentroid) {
        GeometryObject<Box3D> next = null;
        switch (random.nextInt(8)) {
            case 0: {
                next = EuclidShapeRandomTools.nextBox3D(random);
                break;
            }
            case 1: {
                next = EuclidShapeRandomTools.nextCapsule3D(random);
                break;
            }
            case 2: {
                next = EuclidShapeRandomTools.nextConvexPolytope3D(random);
                break;
            }
            case 3: {
                next = EuclidShapeRandomTools.nextCylinder3D(random);
                break;
            }
            case 4: {
                next = EuclidShapeRandomTools.nextEllipsoid3D(random);
                break;
            }
            case 5: {
                return new PointShape3D(shapeCentroid);
            }
            case 6: {
                next = EuclidShapeRandomTools.nextRamp3D(random);
                break;
            }
            case 7: {
                next = EuclidShapeRandomTools.nextSphere3D(random);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected state.");
            }
        }
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().sub(shapeCentroid, (Tuple3DReadOnly)next.getCentroid());
        next.applyTransform((Transform)transform);
        return next;
    }
}

