/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeConstructionTools;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public abstract class AbstractConvexPolytope3D<Vertex extends AbstractVertex3D<Vertex, Edge, Face>, Edge extends AbstractHalfEdge3D<Vertex, Edge, Face>, Face extends AbstractFace3D<Vertex, Edge, Face>>
implements ConvexPolytope3DReadOnly,
Shape3DBasics,
Transformable,
Clearable {
    private final List<Vertex> vertices = new ArrayList<Vertex>();
    private final List<Edge> halfEdges = new ArrayList<Edge>();
    private final List<Face> faces = new ArrayList<Face>();
    private double volume;
    private final double constructionEpsilon;
    private Vertex3DFactory<Vertex> vertexFactory;
    private HalfEdge3DFactory<Vertex, Edge> edgeFactory;
    private Face3DFactory<Face> faceFactory;
    private Vertex3DReadOnly lastSupportingVertex = null;

    public AbstractConvexPolytope3D() {
        this(1.0E-10);
    }

    public AbstractConvexPolytope3D(double constructionEpsilon) {
        this.constructionEpsilon = constructionEpsilon;
    }

    protected void setFactories(Vertex3DFactory<Vertex> vertexFactory, HalfEdge3DFactory<Vertex, Edge> edgeFactory, Face3DFactory<Face> faceFactory) {
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.faceFactory = faceFactory;
    }

    protected void initialize() {
        this.getBoundingBox().setToNaN();
    }

    protected void initialize(List<Face> faces) {
        this.faces.addAll(faces);
        this.updateEdges();
        this.updateVertices();
        this.updateBoundingBox();
        this.updateCentroidAndVolume();
        if (faces.size() > 1) {
            for (AbstractHalfEdge3D halfEdge : this.halfEdges) {
                if (halfEdge.getTwin() != null) continue;
                HalfEdge3DReadOnly twin = ((AbstractVertex3D)halfEdge.getDestination()).getEdgeTo(halfEdge.getOrigin());
                halfEdge.setTwin(twin);
                ((AbstractHalfEdge3D)twin).setTwin(halfEdge);
            }
        }
    }

    public void clear() {
        this.lastSupportingVertex = null;
        this.vertices.clear();
        this.halfEdges.clear();
        this.faces.clear();
        this.getBoundingBox().setToNaN();
        this.getCentroid().setToNaN();
        this.volume = Double.NaN;
    }

    public void setToNaN() {
        this.clear();
    }

    public void setToZero() {
        this.lastSupportingVertex = null;
        this.vertices.clear();
        this.halfEdges.clear();
        this.faces.clear();
        this.getBoundingBox().setToZero();
        this.getCentroid().setToZero();
        this.volume = 0.0;
    }

    public void set(ConvexPolytope3DReadOnly other) {
        this.clear();
        HashMap<Vertex3DReadOnly, AbstractVertex3D> fromOtherToThisVertices = new HashMap<Vertex3DReadOnly, AbstractVertex3D>(other.getNumberOfVertices());
        HashMap<HalfEdge3DReadOnly, AbstractHalfEdge3D> fromOtherToThisEdges = new HashMap<HalfEdge3DReadOnly, AbstractHalfEdge3D>(other.getNumberOfEdges());
        List<? extends Vertex3DReadOnly> otherVertices = other.getVertices();
        for (Vertex3DReadOnly vertex3DReadOnly : otherVertices) {
            AbstractVertex3D vertex = (AbstractVertex3D)this.vertexFactory.newInstance(vertex3DReadOnly);
            this.vertices.add(vertex);
            fromOtherToThisVertices.put(vertex3DReadOnly, vertex);
        }
        for (HalfEdge3DReadOnly halfEdge3DReadOnly : other.getHalfEdges()) {
            Vertex3DReadOnly otherOrigin = halfEdge3DReadOnly.getOrigin();
            Vertex3DReadOnly otherDestination = halfEdge3DReadOnly.getDestination();
            AbstractVertex3D origin = (AbstractVertex3D)fromOtherToThisVertices.get(otherOrigin);
            AbstractVertex3D destination = (AbstractVertex3D)fromOtherToThisVertices.get(otherDestination);
            AbstractHalfEdge3D edge = (AbstractHalfEdge3D)this.edgeFactory.newInstance(origin, destination);
            this.halfEdges.add(edge);
            fromOtherToThisEdges.put(halfEdge3DReadOnly, edge);
        }
        for (int edgeIndex = 0; edgeIndex < other.getHalfEdges().size(); ++edgeIndex) {
            HalfEdge3DReadOnly halfEdge3DReadOnly = other.getHalfEdge(edgeIndex);
            AbstractHalfEdge3D edge = (AbstractHalfEdge3D)this.halfEdges.get(edgeIndex);
            AbstractHalfEdge3D next = (AbstractHalfEdge3D)fromOtherToThisEdges.get(halfEdge3DReadOnly.getNext());
            AbstractHalfEdge3D previous = (AbstractHalfEdge3D)fromOtherToThisEdges.get(halfEdge3DReadOnly.getPrevious());
            AbstractHalfEdge3D twin = (AbstractHalfEdge3D)fromOtherToThisEdges.get(halfEdge3DReadOnly.getTwin());
            edge.setNext(next);
            edge.setPrevious(previous);
            edge.setTwin(twin);
        }
        for (Face3DReadOnly face3DReadOnly : other.getFaces()) {
            Vector3DReadOnly otherNormal = face3DReadOnly.getNormal();
            HalfEdge3DReadOnly otherFirstEdge = face3DReadOnly.getEdge(0);
            AbstractHalfEdge3D firstEdge = (AbstractHalfEdge3D)fromOtherToThisEdges.get(otherFirstEdge);
            ArrayList<AbstractHalfEdge3D> faceEdges = new ArrayList<AbstractHalfEdge3D>();
            HalfEdge3DReadOnly currentEdge = firstEdge;
            do {
                faceEdges.add((AbstractHalfEdge3D)currentEdge);
            } while ((currentEdge = currentEdge.getNext()) != firstEdge);
            AbstractFace3D face = (AbstractFace3D)this.faceFactory.newInstance(otherNormal, this.constructionEpsilon);
            face.initialize(faceEdges, otherNormal);
            this.faces.add(face);
        }
        this.getBoundingBox().set(other.getBoundingBox());
        this.getCentroid().set((Tuple3DReadOnly)other.getCentroid());
        this.volume = other.getVolume();
    }

    public boolean addVertex(Point3DReadOnly vertexToAdd) {
        return this.addVertices(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{vertexToAdd}));
    }

    public boolean addVertices(Vertex3DSupplier vertex3DSupplier) {
        boolean isPolytopeModified = false;
        for (int index = 0; index < vertex3DSupplier.getNumberOfVertices(); ++index) {
            AbstractVertex3D vertexToAdd = (AbstractVertex3D)this.vertexFactory.newInstance(vertex3DSupplier.getVertex(index));
            if (this.faces.size() == 0) {
                isPolytopeModified |= this.handleNoFaceCase(vertexToAdd);
                continue;
            }
            if (this.faces.size() == 1) {
                isPolytopeModified |= this.handleSingleFaceCase(vertexToAdd);
                continue;
            }
            isPolytopeModified |= this.handleMultipleFaceCase(vertexToAdd);
        }
        if (this.faces.size() > 2) {
            for (int i = this.faces.size() - 1; i >= 0; --i) {
                AbstractFace3D face = (AbstractFace3D)this.faces.get(i);
                if (face.getNumberOfEdges() > 2) continue;
                this.removeFace(face);
            }
        }
        if (this.faces.size() == 2) {
            this.removeFace((AbstractFace3D)this.faces.get(1));
            AbstractFace3D singleFace = (AbstractFace3D)this.faces.get(0);
            for (int i = 0; i < singleFace.getNumberOfEdges(); ++i) {
                HalfEdge3DReadOnly edge = singleFace.getEdge(i);
                ((AbstractVertex3D)((AbstractHalfEdge3D)edge).getOrigin()).clearAssociatedEdgeList();
                ((AbstractVertex3D)((AbstractHalfEdge3D)edge).getOrigin()).addAssociatedEdge(edge);
            }
        } else if (this.faces.size() == 3) {
            AbstractFace3D faceToKeep = (AbstractFace3D)this.faces.get(0);
            AbstractFace3D secondFace = (AbstractFace3D)this.faces.get(1);
            AbstractFace3D thirdFace = (AbstractFace3D)this.faces.get(2);
            if (secondFace.getNumberOfEdges() > faceToKeep.getNumberOfEdges()) {
                this.removeFace(faceToKeep);
                faceToKeep = secondFace;
            } else {
                this.removeFace(secondFace);
            }
            if (thirdFace.getNumberOfEdges() > faceToKeep.getNumberOfEdges()) {
                this.removeFace(faceToKeep);
                faceToKeep = thirdFace;
            } else {
                this.removeFace(thirdFace);
            }
            for (int i = 0; i < faceToKeep.getNumberOfEdges(); ++i) {
                HalfEdge3DReadOnly edge = faceToKeep.getEdge(i);
                ((AbstractVertex3D)((AbstractHalfEdge3D)edge).getOrigin()).clearAssociatedEdgeList();
                ((AbstractVertex3D)((AbstractHalfEdge3D)edge).getOrigin()).addAssociatedEdge(edge);
            }
        }
        if (isPolytopeModified) {
            this.updateEdges();
            this.updateVertices();
            this.updateBoundingBox();
            this.updateCentroidAndVolume();
        }
        return isPolytopeModified;
    }

    private boolean handleNoFaceCase(Vertex vertexToAdd) {
        AbstractFace3D newFace = (AbstractFace3D)this.faceFactory.newInstance((Vector3DReadOnly)Axis3D.Z, this.constructionEpsilon);
        newFace.addVertex(vertexToAdd);
        return this.faces.add(newFace);
    }

    private boolean handleSingleFaceCase(Vertex vertexToAdd) {
        AbstractFace3D firstFace = (AbstractFace3D)this.faces.get(0);
        if (firstFace.getNumberOfEdges() <= 2) {
            return firstFace.addVertex(vertexToAdd);
        }
        if (!EuclidPolytopeTools.arePoint3DAndFace3DInPlane(vertexToAdd, firstFace, this.constructionEpsilon)) {
            List<Face> newFaces;
            if (firstFace.canObserverSeeFace((Point3DReadOnly)vertexToAdd)) {
                firstFace.flip();
            }
            if ((newFaces = EuclidPolytopeConstructionTools.computeVertexNeighborFaces(this.faceFactory, vertexToAdd, firstFace.getEdges(), Collections.emptyList(), this.constructionEpsilon)) != null) {
                this.faces.addAll(newFaces);
                return true;
            }
        } else if (!firstFace.isPointDirectlyAboveOrBelow((Point3DReadOnly)vertexToAdd)) {
            return firstFace.addVertex(vertexToAdd);
        }
        return false;
    }

    private boolean handleMultipleFaceCase(Vertex vertexToAdd) {
        List inPlaneFaces;
        List<Face> newFaces;
        HashSet visibleFaces = new HashSet();
        List silhouette = EuclidPolytopeTools.computeSilhouette(this.faces, vertexToAdd, this.constructionEpsilon, visibleFaces);
        if (silhouette != null && (newFaces = EuclidPolytopeConstructionTools.computeVertexNeighborFaces(this.faceFactory, vertexToAdd, silhouette, inPlaneFaces = EuclidPolytopeTools.computeInPlaneFacesAroundSilhouette(vertexToAdd, silhouette, this.constructionEpsilon), this.constructionEpsilon)) != null) {
            this.removeFaces(visibleFaces);
            this.faces.addAll(newFaces);
            return true;
        }
        return false;
    }

    private void updateVertices() {
        this.lastSupportingVertex = null;
        this.vertices.clear();
        this.faces.stream().flatMap(face -> face.getVertices().stream()).distinct().forEach(this.vertices::add);
    }

    private void updateEdges() {
        this.halfEdges.clear();
        for (AbstractFace3D face : this.faces) {
            this.halfEdges.addAll(face.getEdges());
        }
    }

    private void updateBoundingBox() {
        this.getBoundingBox().setToNaN();
        for (int faceIndex = 0; faceIndex < this.faces.size(); ++faceIndex) {
            this.getBoundingBox().combine((BoundingBox3DReadOnly)((AbstractFace3D)this.faces.get(faceIndex)).getBoundingBox());
        }
    }

    private void updateCentroidAndVolume() {
        this.volume = EuclidPolytopeConstructionTools.computeConvexPolytope3DVolume(this, this.getCentroid());
    }

    private void removeFaces(Collection<Face> facesToRemove) {
        for (AbstractFace3D face : facesToRemove) {
            this.removeFace(face);
        }
    }

    private void removeFace(Face faceToRemove) {
        if (this.faces.remove(faceToRemove)) {
            ((AbstractFace3D)faceToRemove).destroy();
        }
    }

    @Override
    public boolean containsNaN() {
        return ConvexPolytope3DReadOnly.super.containsNaN();
    }

    public Face getFace(int index) {
        return (Face)((AbstractFace3D)this.faces.get(index));
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public Edge getHalfEdge(int index) {
        return (Edge)((AbstractHalfEdge3D)this.halfEdges.get(index));
    }

    public List<Edge> getHalfEdges() {
        return this.halfEdges;
    }

    public Vertex getVertex(int index) {
        return (Vertex)((AbstractVertex3D)this.vertices.get(index));
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public abstract BoundingBox3DBasics getBoundingBox();

    @Override
    public double getConstructionEpsilon() {
        return this.constructionEpsilon;
    }

    public Face getClosestFace(Point3DReadOnly point) {
        return (Face)((AbstractFace3D)ConvexPolytope3DReadOnly.super.getClosestFace(point));
    }

    public abstract Point3DBasics getCentroid();

    @Override
    public double getVolume() {
        return this.volume;
    }

    @Override
    public Vertex3DReadOnly getSupportingVertex(Vector3DReadOnly supportDirection) {
        this.lastSupportingVertex = this.getSupportingVertex(this.lastSupportingVertex, supportDirection);
        return this.lastSupportingVertex;
    }

    @Override
    public Shape3DPoseBasics getPose() {
        return null;
    }

    @Override
    public abstract AbstractConvexPolytope3D<Vertex, Edge, Face> copy();

    public void applyTransform(Transform transform) {
        int i;
        for (i = 0; i < this.vertices.size(); ++i) {
            ((AbstractVertex3D)this.vertices.get(i)).applyTransform(transform);
        }
        for (i = 0; i < this.faces.size(); ++i) {
            AbstractFace3D face = (AbstractFace3D)this.faces.get(i);
            face.updateNormal();
            face.updateCentroidAndArea();
            face.updateBoundingBox();
        }
        this.updateBoundingBox();
        this.updateCentroidAndVolume();
    }

    public void applyInverseTransform(Transform transform) {
        int i;
        for (i = 0; i < this.vertices.size(); ++i) {
            ((AbstractVertex3D)this.vertices.get(i)).applyInverseTransform(transform);
        }
        for (i = 0; i < this.faces.size(); ++i) {
            AbstractFace3D face = (AbstractFace3D)this.faces.get(i);
            face.updateNormal();
            face.updateCentroidAndArea();
            face.updateBoundingBox();
        }
        this.updateBoundingBox();
        this.updateCentroidAndVolume();
    }

    public boolean equals(Object object) {
        if (object instanceof ConvexPolytope3DReadOnly) {
            return this.equals((ConvexPolytope3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return this.vertices.hashCode();
    }

    public String toString() {
        return EuclidShapeIOTools.getConvexPolytope3DString(this);
    }
}

