/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public interface Triangle3DReadOnly
extends EuclidGeometry {
    public Point3DReadOnly getA();

    public Point3DReadOnly getB();

    public Point3DReadOnly getC();

    default public boolean containsNaN() {
        return this.getA().containsNaN() || this.getB().containsNaN() || this.getC().containsNaN();
    }

    default public double getAB() {
        return this.getA().distance(this.getB());
    }

    default public double getBC() {
        return this.getB().distance(this.getC());
    }

    default public double getCA() {
        return this.getC().distance(this.getA());
    }

    default public double getABSquared() {
        return this.getA().distanceSquared(this.getB());
    }

    default public double getBCSquared() {
        return this.getB().distanceSquared(this.getC());
    }

    default public double getCASquared() {
        return this.getC().distanceSquared(this.getA());
    }

    default public double getArea() {
        return EuclidGeometryTools.triangleArea(this.getA(), this.getB(), this.getC());
    }

    default public boolean isEquilateral(double epsilon) {
        if (!EuclidCoreTools.epsilonEquals((double)this.getABSquared(), (double)this.getCASquared(), (double)epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)this.getCASquared(), (double)this.getBCSquared(), (double)epsilon);
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Triangle3DReadOnly)) {
            return false;
        }
        Triangle3DReadOnly other = (Triangle3DReadOnly)geometry;
        if (!this.getA().epsilonEquals((EuclidGeometry)other.getA(), epsilon)) {
            return false;
        }
        if (!this.getB().epsilonEquals((EuclidGeometry)other.getB(), epsilon)) {
            return false;
        }
        return this.getC().epsilonEquals((EuclidGeometry)other.getC(), epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Triangle3DReadOnly)) {
            return false;
        }
        Triangle3DReadOnly other = (Triangle3DReadOnly)geometry;
        return this.getA().equals((EuclidGeometry)other.getA()) && this.getB().equals((EuclidGeometry)other.getB()) && this.getC().equals((EuclidGeometry)other.getC());
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Triangle3DReadOnly)) {
            return false;
        }
        Triangle3DReadOnly other = (Triangle3DReadOnly)geometry;
        return this.geometricallyEquals(other.getA(), other.getB(), other.getC(), epsilon);
    }

    default public boolean geometricallyEquals(Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c, double epsilon) {
        if (this.getA().geometricallyEquals((EuclidGeometry)a, epsilon)) {
            if (this.getB().geometricallyEquals((EuclidGeometry)b, epsilon)) {
                return this.getC().geometricallyEquals((EuclidGeometry)c, epsilon);
            }
            return this.getB().geometricallyEquals((EuclidGeometry)c, epsilon) && this.getC().geometricallyEquals((EuclidGeometry)b, epsilon);
        }
        if (this.getA().geometricallyEquals((EuclidGeometry)b, epsilon)) {
            if (this.getB().geometricallyEquals((EuclidGeometry)a, epsilon)) {
                return this.getC().geometricallyEquals((EuclidGeometry)c, epsilon);
            }
            return this.getB().geometricallyEquals((EuclidGeometry)c, epsilon) && this.getC().geometricallyEquals((EuclidGeometry)a, epsilon);
        }
        if (this.getA().geometricallyEquals((EuclidGeometry)c, epsilon)) {
            if (this.getB().geometricallyEquals((EuclidGeometry)a, epsilon)) {
                return this.getC().geometricallyEquals((EuclidGeometry)b, epsilon);
            }
            return this.getB().geometricallyEquals((EuclidGeometry)b, epsilon) && this.getC().geometricallyEquals((EuclidGeometry)a, epsilon);
        }
        return false;
    }

    default public String toString(String format) {
        return EuclidGeometryIOTools.getTriangle3DString(format, this);
    }
}

