/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public interface ConvexPolygon2DBasics
extends ConvexPolygon2DReadOnly,
Clearable,
Transformable {
    @Override
    public BoundingBox2DBasics getBoundingBox();

    public void notifyVerticesChanged();

    public void clear();

    public void clearAndUpdate();

    default public void setToZero() {
        this.clear();
        this.addVertex(0.0, 0.0);
        this.update();
    }

    default public void setToNaN() {
        this.clear();
        this.addVertex(Double.NaN, Double.NaN);
        this.update();
    }

    @Override
    default public boolean containsNaN() {
        return ConvexPolygon2DReadOnly.super.containsNaN();
    }

    public void update();

    default public void updateBoundingBox() {
        BoundingBox2DBasics boundingBox = this.getBoundingBox();
        boundingBox.setToNaN();
        boundingBox.updateToIncludePoints(this);
    }

    public void updateCentroidAndArea();

    public Point2DBasics getVertexUnsafe(int var1);

    public void addVertex(double var1, double var3);

    default public void addVertex(Point2DReadOnly vertex) {
        this.addVertex(vertex.getX(), vertex.getY());
    }

    default public void addVertex(Point3DReadOnly vertex) {
        this.addVertex(vertex.getX(), vertex.getY());
    }

    default public void addVertices(Vertex2DSupplier vertex2DSupplier) {
        for (int index = 0; index < vertex2DSupplier.getNumberOfVertices(); ++index) {
            this.addVertex(vertex2DSupplier.getVertex(index));
        }
    }

    default public void addVertices(Vertex3DSupplier vertex3DSupplier) {
        for (int index = 0; index < vertex3DSupplier.getNumberOfVertices(); ++index) {
            this.addVertex(vertex3DSupplier.getVertex(index));
        }
    }

    public void removeVertex(int var1);

    default public void set(Vertex2DSupplier vertex2DSupplier) {
        this.clear();
        this.addVertices(vertex2DSupplier);
        this.update();
    }

    default public void set(Vertex3DSupplier vertex3DSupplier) {
        this.clear();
        this.addVertices(vertex3DSupplier);
        this.update();
    }

    default public void set(Vertex2DSupplier firstVertex2DSupplier, Vertex2DSupplier secondVertex2DSupplier) {
        this.clear();
        this.addVertices(firstVertex2DSupplier);
        this.addVertices(secondVertex2DSupplier);
        this.update();
    }

    default public void scale(double scaleFactor) {
        this.scale(this.getCentroid(), scaleFactor);
    }

    default public void scale(Point2DReadOnly pointToScaleAbout, double scaleFactor) {
        this.checkIfUpToDate();
        this.notifyVerticesChanged();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            Point2DBasics vertex = this.getVertexUnsafe(i);
            vertex.sub((Tuple2DReadOnly)pointToScaleAbout);
            vertex.scale(scaleFactor);
            vertex.add((Tuple2DReadOnly)pointToScaleAbout);
        }
        this.update();
    }

    default public void translate(Tuple2DReadOnly translation) {
        this.translate(translation.getX(), translation.getY());
    }

    default public void translate(double x, double y) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).add(x, y);
        }
        this.updateBoundingBox();
        this.updateCentroidAndArea();
    }

    default public void applyTransform(Transform transform) {
        this.applyTransform(transform, true);
    }

    default public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        this.notifyVerticesChanged();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyTransform(transform, checkIfTransformInXYPlane);
        }
        this.update();
    }

    default public void applyInverseTransform(Transform transform) {
        this.applyInverseTransform(transform, true);
    }

    default public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        this.notifyVerticesChanged();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyInverseTransform(transform, checkIfTransformInXYPlane);
        }
        this.update();
    }
}

