/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class ConvexPolygon2D
implements ConvexPolygon2DBasics {
    private final boolean clockwiseOrdered = true;
    private int numberOfVertices = 0;
    private final List<Point2D> vertexBuffer = new ArrayList<Point2D>();
    private final List<Point2D> vertexBufferView = Collections.unmodifiableList(this.vertexBuffer);
    private final BoundingBox2D boundingBox = new BoundingBox2D();
    private final Point2D centroid = new Point2D();
    private double area;
    private boolean isUpToDate = false;

    public ConvexPolygon2D() {
        this.numberOfVertices = 0;
        this.update();
    }

    public ConvexPolygon2D(Vertex2DSupplier vertex2DSupplier) {
        this.set(vertex2DSupplier);
    }

    public ConvexPolygon2D(Vertex3DSupplier vertex3DSupplier) {
        this.set(vertex3DSupplier);
    }

    public ConvexPolygon2D(Vertex2DSupplier firstVertex2DSupplier, Vertex2DSupplier secondVertex2DSupplier) {
        this.set(firstVertex2DSupplier, secondVertex2DSupplier);
    }

    @Override
    public boolean isClockwiseOrdered() {
        return true;
    }

    @Override
    public void clear() {
        this.numberOfVertices = 0;
        this.area = Double.NaN;
        this.centroid.setToNaN();
        this.boundingBox.setToNaN();
        this.isUpToDate = false;
    }

    @Override
    public void clearAndUpdate() {
        this.clear();
        this.isUpToDate = true;
    }

    @Override
    public void addVertex(double x, double y) {
        this.isUpToDate = false;
        this.setOrCreate(x, y, this.numberOfVertices);
        ++this.numberOfVertices;
    }

    @Override
    public void removeVertex(int indexOfVertexToRemove) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(indexOfVertexToRemove);
        if (indexOfVertexToRemove == this.numberOfVertices - 1) {
            --this.numberOfVertices;
            return;
        }
        this.isUpToDate = false;
        Collections.swap(this.vertexBuffer, indexOfVertexToRemove, this.numberOfVertices - 1);
        --this.numberOfVertices;
    }

    private void setOrCreate(double x, double y, int i) {
        while (i >= this.vertexBuffer.size()) {
            this.vertexBuffer.add(new Point2D());
        }
        this.vertexBuffer.get(i).set(x, y);
    }

    @Override
    public void update() {
        if (this.isUpToDate) {
            return;
        }
        this.numberOfVertices = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(this.vertexBuffer, this.numberOfVertices);
        this.isUpToDate = true;
        this.updateCentroidAndArea();
        this.updateBoundingBox();
    }

    @Override
    public void updateCentroidAndArea() {
        this.area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(this.vertexBuffer, this.numberOfVertices, true, (Point2DBasics)this.centroid);
    }

    @Override
    public Point2DBasics getVertexUnsafe(int index) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(index);
        return (Point2DBasics)this.vertexBuffer.get(index);
    }

    @Override
    public double getArea() {
        this.checkIfUpToDate();
        return this.area;
    }

    @Override
    public Point2DReadOnly getCentroid() {
        this.checkIfUpToDate();
        return this.centroid;
    }

    @Override
    public BoundingBox2D getBoundingBox() {
        this.checkIfUpToDate();
        return this.boundingBox;
    }

    @Override
    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public List<? extends Point2DReadOnly> getVertexBufferView() {
        return this.vertexBufferView;
    }

    @Override
    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    @Override
    public void notifyVerticesChanged() {
        this.isUpToDate = false;
    }

    public boolean equals(Object object) {
        if (object instanceof ConvexPolygon2DReadOnly) {
            return ConvexPolygon2DBasics.super.equals((ConvexPolygon2DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((long)EuclidHashCodeTools.addToHashCode((long)Boolean.hashCode(true), this.vertexBufferView));
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

