/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Vertex3DSupplier {
    public static final Vertex3DSupplier EMPTY_SUPPLIER = new Vertex3DSupplier(){

        @Override
        public Point3DReadOnly getVertex(int index) {
            return null;
        }

        @Override
        public int getNumberOfVertices() {
            return 0;
        }
    };

    public Point3DReadOnly getVertex(int var1);

    public int getNumberOfVertices();

    default public boolean isEmpty() {
        return this.getNumberOfVertices() == 0;
    }

    default public boolean equals(Vertex3DSupplier other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).equals((Tuple3DReadOnly)other.getVertex(i))) continue;
            return false;
        }
        return true;
    }

    default public boolean epsilonEquals(Vertex3DSupplier other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).epsilonEquals((Tuple3DReadOnly)other.getVertex(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static Vertex3DSupplier emptyVertex3DSupplier() {
        return EMPTY_SUPPLIER;
    }

    public static Vertex3DSupplier asVertex3DSupplier(Point3DReadOnly ... vertices) {
        return Vertex3DSupplier.asVertex3DSupplier(Arrays.asList(vertices));
    }

    public static Vertex3DSupplier asVertex3DSupplier(Point3DReadOnly[] vertices, int numberOfVertices) {
        return Vertex3DSupplier.asVertex3DSupplier(Arrays.asList(vertices), numberOfVertices);
    }

    public static Vertex3DSupplier asVertex3DSupplier(Point3DReadOnly[] vertices, int startIndex, int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex3DSupplier.emptyVertex3DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        return Vertex3DSupplier.asVertex3DSupplier(Arrays.asList(vertices), startIndex, numberOfVertices);
    }

    public static Vertex3DSupplier asVertex3DSupplier(List<? extends Point3DReadOnly> vertices) {
        return Vertex3DSupplier.asVertex3DSupplier(vertices, vertices.size());
    }

    public static Vertex3DSupplier asVertex3DSupplier(List<? extends Point3DReadOnly> vertices, int numberOfVertices) {
        return Vertex3DSupplier.asVertex3DSupplier(vertices, 0, numberOfVertices);
    }

    public static Vertex3DSupplier asVertex3DSupplier(final List<? extends Point3DReadOnly> vertices, final int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex3DSupplier.emptyVertex3DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.size()) {
            throw new IllegalArgumentException("The list is too small. List size = " + vertices.size() + ", expected minimum size = " + (startIndex + numberOfVertices));
        }
        return new Vertex3DSupplier(){

            @Override
            public Point3DReadOnly getVertex(int index) {
                return (Point3DReadOnly)vertices.get(index + startIndex);
            }

            @Override
            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public String toString() {
                return "Vertex 3D Supplier: " + vertices.subList(startIndex, startIndex + numberOfVertices).toString();
            }
        };
    }
}

