/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface LineSegment2DReadOnly {
    public Point2DReadOnly getFirstEndpoint();

    public Point2DReadOnly getSecondEndpoint();

    default public void get(Point2DBasics firstEndpointToPack, Point2DBasics secondEndpointToPack) {
        firstEndpointToPack.set((Tuple2DReadOnly)this.getFirstEndpoint());
        secondEndpointToPack.set((Tuple2DReadOnly)this.getSecondEndpoint());
    }

    default public double getFirstEndpointX() {
        return this.getFirstEndpoint().getX();
    }

    default public double getFirstEndpointY() {
        return this.getFirstEndpoint().getY();
    }

    default public double getSecondEndpointX() {
        return this.getSecondEndpoint().getX();
    }

    default public double getSecondEndpointY() {
        return this.getSecondEndpoint().getY();
    }

    @Deprecated
    default public boolean firstEndpointContainsNaN() {
        return this.getFirstEndpoint().containsNaN();
    }

    @Deprecated
    default public boolean secondEndpointContainsNaN() {
        return this.getSecondEndpoint().containsNaN();
    }

    default public boolean containsNaN() {
        return this.getFirstEndpoint().containsNaN() || this.getSecondEndpoint().containsNaN();
    }

    default public void midpoint(Point2DBasics midpointToPack) {
        midpointToPack.interpolate((Tuple2DReadOnly)this.getFirstEndpoint(), (Tuple2DReadOnly)this.getSecondEndpoint(), 0.5);
    }

    default public Point2DBasics midpoint() {
        Point2D midpoint = new Point2D();
        this.midpoint((Point2DBasics)midpoint);
        return midpoint;
    }

    default public double length() {
        return this.getFirstEndpoint().distance(this.getSecondEndpoint());
    }

    default public double lengthSquared() {
        return this.getFirstEndpoint().distanceSquared(this.getSecondEndpoint());
    }

    default public boolean isBetweenEndpoints(double x, double y, double epsilon) {
        double alpha = this.percentageAlongLineSegment(x, y);
        if (alpha < epsilon) {
            return false;
        }
        return !(alpha > 1.0 - epsilon);
    }

    default public boolean isBetweenEndpoints(Point2DReadOnly point) {
        return this.isBetweenEndpoints(point, 0.0);
    }

    default public boolean isBetweenEndpoints(Point2DReadOnly point, double epsilon) {
        return this.isBetweenEndpoints(point.getX(), point.getY(), epsilon);
    }

    default public boolean isPointOnLeftSideOfLineSegment(Point2DReadOnly point) {
        return EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D(point, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public Vector2DBasics direction(boolean normalize) {
        Vector2D direction = new Vector2D();
        this.direction(normalize, (Vector2DBasics)direction);
        return direction;
    }

    default public void direction(boolean normalize, Vector2DBasics directionToPack) {
        directionToPack.sub((Tuple2DReadOnly)this.getSecondEndpoint(), (Tuple2DReadOnly)this.getFirstEndpoint());
        if (normalize) {
            directionToPack.normalize();
        }
    }

    default public double distance(Point2DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D(point, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public double distanceSquared(Point2DReadOnly point) {
        return EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D(point.getX(), point.getY(), this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public LineSegment2D flipDirectionCopy() {
        return new LineSegment2D(this.getSecondEndpoint(), this.getFirstEndpoint());
    }

    default public Point2DBasics[] intersectionWith(ConvexPolygon2DReadOnly convexPolygon) {
        return convexPolygon.intersectionWith(this);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return convexPolygon.intersectionWith(this, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public Point2DBasics intersectionWith(Line2DReadOnly line) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(line.getPoint(), (Vector2DReadOnly)line.getDirection(), this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public boolean intersectionWith(Line2DReadOnly line, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(line.getPoint(), (Vector2DReadOnly)line.getDirection(), this.getFirstEndpoint(), this.getSecondEndpoint(), intersectionToPack);
    }

    default public Point2DBasics intersectionWith(LineSegment2DReadOnly other) {
        return EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds(this.getFirstEndpoint(), this.getSecondEndpoint(), other.getFirstEndpoint(), other.getSecondEndpoint());
    }

    default public boolean intersectionWith(LineSegment2DReadOnly other, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds(this.getFirstEndpoint(), this.getSecondEndpoint(), other.getFirstEndpoint(), other.getSecondEndpoint(), intersectionToPack);
    }

    default public boolean isPointOnLineSegment(Point2DReadOnly point) {
        return this.isPointOnLineSegment(point, 1.0E-8);
    }

    default public boolean isPointOnLineSegment(Point2DReadOnly point, double epsilon) {
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D(point, this.getFirstEndpoint(), this.getSecondEndpoint()) < epsilon;
    }

    default public boolean isPointOnRightSideOfLineSegment(Point2DReadOnly point) {
        return EuclidGeometryTools.isPoint2DOnRightSideOfLine2D(point, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public double percentageAlongLineSegment(double x, double y) {
        return EuclidGeometryTools.percentageAlongLineSegment2D(x, y, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public double percentageAlongLineSegment(Point2DReadOnly point) {
        return this.percentageAlongLineSegment(point.getX(), point.getY());
    }

    default public double dotProduct(LineSegment2DReadOnly other) {
        return EuclidGeometryTools.dotProduct(this.getFirstEndpoint(), this.getSecondEndpoint(), other.getFirstEndpoint(), other.getSecondEndpoint());
    }

    default public boolean orthogonalProjection(Point2DBasics pointToProject) {
        return this.orthogonalProjection((Point2DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, Point2DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D(pointToProject, this.getFirstEndpoint(), this.getSecondEndpoint(), projectionToPack);
    }

    default public Point2DBasics orthogonalProjectionCopy(Point2DReadOnly pointToProject) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D(pointToProject, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public void perpendicular(boolean normalize, Vector2DBasics perpendicularVectorToPack) {
        this.direction(normalize, perpendicularVectorToPack);
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)perpendicularVectorToPack, perpendicularVectorToPack);
    }

    default public Point2DBasics pointBetweenEndpointsGivenPercentage(double percentage) {
        Point2D point = new Point2D();
        this.pointBetweenEndpointsGivenPercentage(percentage, (Point2DBasics)point);
        return point;
    }

    default public void pointBetweenEndpointsGivenPercentage(double percentage, Point2DBasics pointToPack) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new RuntimeException("Percentage must be between 0.0 and 1.0. Was: " + percentage);
        }
        pointToPack.interpolate((Tuple2DReadOnly)this.getFirstEndpoint(), (Tuple2DReadOnly)this.getSecondEndpoint(), percentage);
    }

    default public Point2DBasics pointOnLineGivenPercentage(double percentage) {
        Point2D point = new Point2D();
        this.pointOnLineGivenPercentage(percentage, (Point2DBasics)point);
        return point;
    }

    default public void pointOnLineGivenPercentage(double percentage, Point2DBasics pointToPack) {
        pointToPack.interpolate((Tuple2DReadOnly)this.getFirstEndpoint(), (Tuple2DReadOnly)this.getSecondEndpoint(), percentage);
    }

    default public boolean epsilonEquals(LineSegment2DReadOnly other, double epsilon) {
        return this.getFirstEndpoint().epsilonEquals((Tuple2DReadOnly)other.getFirstEndpoint(), epsilon) && this.getSecondEndpoint().epsilonEquals((Tuple2DReadOnly)other.getSecondEndpoint(), epsilon);
    }

    default public boolean equals(LineSegment2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getFirstEndpoint().equals((Tuple2DReadOnly)other.getFirstEndpoint()) && this.getSecondEndpoint().equals((Tuple2DReadOnly)other.getSecondEndpoint());
    }

    default public boolean geometricallyEquals(LineSegment2DReadOnly other, double epsilon) {
        if (this.getFirstEndpoint().geometricallyEquals(other.getFirstEndpoint(), epsilon) && this.getSecondEndpoint().geometricallyEquals(other.getSecondEndpoint(), epsilon)) {
            return true;
        }
        return this.getFirstEndpoint().geometricallyEquals(other.getSecondEndpoint(), epsilon) && this.getSecondEndpoint().geometricallyEquals(other.getFirstEndpoint(), epsilon);
    }
}

