/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface LineSegment2DBasics
extends LineSegment2DReadOnly,
Clearable,
Transformable {
    public Point2DBasics getFirstEndpoint();

    public Point2DBasics getSecondEndpoint();

    @Override
    default public boolean containsNaN() {
        return this.getFirstEndpoint().containsNaN() || this.getSecondEndpoint().containsNaN();
    }

    default public void setToNaN() {
        this.getFirstEndpoint().setToNaN();
        this.getSecondEndpoint().setToNaN();
    }

    default public void setToZero() {
        this.getFirstEndpoint().setToZero();
        this.getSecondEndpoint().setToZero();
    }

    default public void set(LineSegment2DReadOnly other) {
        this.set(other.getFirstEndpoint(), other.getSecondEndpoint());
    }

    default public void set(LineSegment3DReadOnly other) {
        this.set(other.getFirstEndpoint(), other.getSecondEndpoint());
    }

    default public void set(double firstEndpointX, double firstEndpointY, double secondEndpointX, double secondEndpointY) {
        this.getFirstEndpoint().set(firstEndpointX, firstEndpointY);
        this.getSecondEndpoint().set(secondEndpointX, secondEndpointY);
    }

    @Deprecated
    default public void setFirstEndpoint(double firstEndpointX, double firstEndpointY) {
        this.getFirstEndpoint().set(firstEndpointX, firstEndpointY);
    }

    @Deprecated
    default public void setFirstEndpoint(Point2DReadOnly firstEndpoint) {
        this.getFirstEndpoint().set((Tuple2DReadOnly)firstEndpoint);
    }

    @Deprecated
    default public void setFirstEndpoint(Point3DReadOnly firstEndpoint) {
        this.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
    }

    @Deprecated
    default public void setSecondEndpoint(double secondEndpointX, double secondEndpointY) {
        this.getSecondEndpoint().set(secondEndpointX, secondEndpointY);
    }

    @Deprecated
    default public void setSecondEndpoint(Point2DReadOnly secondEndpoint) {
        this.getSecondEndpoint().set((Tuple2DReadOnly)secondEndpoint);
    }

    @Deprecated
    default public void setSecondEndpoint(Point3DReadOnly secondEndpoint) {
        this.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
    }

    default public void set(Point2DReadOnly firstEndpoint, Point2DReadOnly secondEndpoint) {
        this.getFirstEndpoint().set((Tuple2DReadOnly)firstEndpoint);
        this.getSecondEndpoint().set((Tuple2DReadOnly)secondEndpoint);
    }

    default public void set(Point3DReadOnly firstEndpoint, Point3DReadOnly secondEndpoint) {
        this.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
        this.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
    }

    default public void set(Point2DReadOnly firstEndpoint, Vector2DReadOnly fromFirstToSecondEndpoint) {
        this.getFirstEndpoint().set((Tuple2DReadOnly)firstEndpoint);
        this.getSecondEndpoint().add((Tuple2DReadOnly)firstEndpoint, (Tuple2DReadOnly)fromFirstToSecondEndpoint);
    }

    default public void set(Point3DReadOnly firstEndpoint, Vector3DReadOnly fromFirstToSecondEndpoint) {
        this.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
        this.getSecondEndpoint().set((Tuple3DReadOnly)firstEndpoint);
        this.getSecondEndpoint().add(fromFirstToSecondEndpoint.getX(), fromFirstToSecondEndpoint.getY());
    }

    default public void translate(double x, double y) {
        this.getFirstEndpoint().add(x, y);
        this.getSecondEndpoint().add(x, y);
    }

    default public void translate(Tuple2DReadOnly translation) {
        this.translate(translation.getX(), translation.getY());
    }

    default public void flipDirection() {
        double x = this.getFirstEndpointX();
        double y = this.getFirstEndpointY();
        this.getFirstEndpoint().set((Tuple2DReadOnly)this.getSecondEndpoint());
        this.getSecondEndpoint().set(x, y);
    }

    default public void shift(boolean shiftToLeft, double distanceToShift) {
        double vectorX = this.getSecondEndpointX() - this.getFirstEndpointX();
        double vectorY = this.getSecondEndpointY() - this.getFirstEndpointY();
        double length = this.length();
        double orthogonalVectorX = -vectorY / length;
        double orthogonalVectorY = vectorX / length;
        if (!shiftToLeft) {
            orthogonalVectorX = -orthogonalVectorX;
            orthogonalVectorY = -orthogonalVectorY;
        }
        orthogonalVectorX = distanceToShift * orthogonalVectorX;
        orthogonalVectorY = distanceToShift * orthogonalVectorY;
        this.translate(orthogonalVectorX, orthogonalVectorY);
    }

    default public void shiftToLeft(double distanceToShift) {
        this.shift(true, distanceToShift);
    }

    default public void shiftToRight(double distanceToShift) {
        this.shift(false, distanceToShift);
    }

    default public void applyTransform(Transform transform) {
        this.applyTransform(transform, true);
    }

    default public void applyInverseTransform(Transform transform) {
        this.applyInverseTransform(transform, true);
    }

    default public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.getFirstEndpoint().applyTransform(transform, checkIfTransformInXYPlane);
        this.getSecondEndpoint().applyTransform(transform, checkIfTransformInXYPlane);
    }

    default public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.getFirstEndpoint().applyInverseTransform(transform, checkIfTransformInXYPlane);
        this.getSecondEndpoint().applyInverseTransform(transform, checkIfTransformInXYPlane);
    }
}

