/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Line3DReadOnly {
    public Point3DReadOnly getPoint();

    public UnitVector3DReadOnly getDirection();

    default public double getDirectionX() {
        return this.getDirection().getX();
    }

    default public double getDirectionY() {
        return this.getDirection().getY();
    }

    default public double getDirectionZ() {
        return this.getDirection().getZ();
    }

    default public void get(Point3DBasics pointToPack, Vector3DBasics directionToPack) {
        pointToPack.set((Tuple3DReadOnly)this.getPoint());
        directionToPack.set((Tuple3DReadOnly)this.getDirection());
    }

    default public double getPointX() {
        return this.getPoint().getX();
    }

    default public double getPointY() {
        return this.getPoint().getY();
    }

    default public double getPointZ() {
        return this.getPoint().getZ();
    }

    default public double distance(Line3DReadOnly otherLine) {
        return EuclidGeometryTools.distanceBetweenTwoLine3Ds(this.getPoint(), (Vector3DReadOnly)this.getDirection(), otherLine.getPoint(), (Vector3DReadOnly)otherLine.getDirection());
    }

    default public double distance(Point3DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint3DToLine3D(point, this.getPoint(), (Vector3DReadOnly)this.getDirection());
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLine3D(pointToProject, this.getPoint(), (Vector3DReadOnly)this.getDirection(), projectionToPack);
    }

    default public Point3D orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        return EuclidGeometryTools.orthogonalProjectionOnLine3D(pointToProject, this.getPoint(), (Vector3DReadOnly)this.getDirection());
    }

    default public boolean isPointOnLine(Point3DReadOnly point, double epsilon) {
        return EuclidGeometryTools.distanceFromPoint3DToLine3D(point, this.getPoint(), (Vector3DReadOnly)this.getDirection()) < epsilon;
    }

    default public double parameterGivenPointOnLine(Point3DReadOnly pointOnLine, double epsilon) {
        if (!this.isPointOnLine(pointOnLine, epsilon)) {
            throw new RuntimeException("The given point is not on this line, distance from line: " + this.distance(pointOnLine));
        }
        double x0 = this.getPointX();
        double y0 = this.getPointY();
        double z0 = this.getPointZ();
        double x1 = x0 + this.getDirectionX();
        double y1 = y0 + this.getDirectionY();
        double z1 = z0 + this.getDirectionZ();
        return EuclidGeometryTools.percentageAlongLineSegment3D(pointOnLine.getX(), pointOnLine.getY(), pointOnLine.getZ(), x0, y0, z0, x1, y1, z1);
    }

    default public Point3D pointOnLineGivenParameter(double t) {
        Point3D pointToReturn = new Point3D();
        this.pointOnLineGivenParameter(t, (Point3DBasics)pointToReturn);
        return pointToReturn;
    }

    default public void pointOnLineGivenParameter(double t, Point3DBasics pointToPack) {
        pointToPack.scaleAdd(t, (Tuple3DReadOnly)this.getDirection(), (Tuple3DReadOnly)this.getPoint());
    }

    default public void getTwoPointsOnLine(Point3DBasics firstPointOnLineToPack, Point3DBasics secondPointOnLineToPack) {
        firstPointOnLineToPack.set((Tuple3DReadOnly)this.getPoint());
        secondPointOnLineToPack.add((Tuple3DReadOnly)this.getPoint(), (Tuple3DReadOnly)this.getDirection());
    }

    default public boolean isCollinear(Line3DReadOnly other, double epsilon) {
        return this.isCollinear(other, epsilon, epsilon);
    }

    default public boolean isCollinear(Line3DReadOnly other, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.areLine3DsCollinear(this.getPoint(), (Vector3DReadOnly)this.getDirection(), other.getPoint(), (Vector3DReadOnly)other.getDirection(), angleEpsilon, distanceEpsilon);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, Point3DBasics closestPointOnThisLineToPack, Point3DBasics closestPointOnOtherLineToPack) {
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds(this.getPoint(), (Vector3DReadOnly)this.getDirection(), otherLine.getPoint(), (Vector3DReadOnly)otherLine.getDirection(), closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
    }

    default public boolean epsilonEquals(Line3DReadOnly other, double epsilon) {
        if (!this.getPoint().epsilonEquals((Tuple3DReadOnly)other.getPoint(), epsilon)) {
            return false;
        }
        return this.getDirection().epsilonEquals((Tuple3DReadOnly)other.getDirection(), epsilon);
    }

    default public boolean geometricallyEquals(Line3DReadOnly other, double epsilon) {
        return this.isCollinear(other, epsilon);
    }

    default public boolean equals(Line3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPoint().equals((Tuple3DReadOnly)other.getPoint()) && this.getDirection().equals((Tuple3DReadOnly)other.getDirection());
    }
}

