/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.exceptions;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class BoundingBoxException
extends RuntimeException {
    private static final long serialVersionUID = 6490958054490430093L;

    public BoundingBoxException() {
    }

    public BoundingBoxException(String message) {
        super(message);
    }

    public BoundingBoxException(BoundingBox2DReadOnly badBoundingBox2D) {
        super("Improper bounding box 2D: " + (badBoundingBox2D == null ? "bounding box is null" : badBoundingBox2D.toString()));
    }

    public BoundingBoxException(Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax) {
        super("Improper bounding box 2D: min = " + boundingBoxMin + ", max = " + boundingBoxMax);
    }

    public BoundingBoxException(BoundingBox3DReadOnly badBoundingBox3D) {
        super("Improper bounding box 3D: " + (badBoundingBox3D == null ? "bounding box is null" : badBoundingBox3D.toString()));
    }

    public BoundingBoxException(Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax) {
        super("Improper bounding box 3D: min = " + boundingBoxMin + ", max = " + boundingBoxMax);
    }

    public BoundingBoxException(double boundingBoxMinX, double boundingBoxMinY, double boundingBoxMinZ, double boundingBoxMaxX, double boundingBoxMaxY, double boundingBoxMaxZ) {
        super("Improper bounding box 3D: min = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (double[])new double[]{boundingBoxMinX, boundingBoxMinY, boundingBoxMinZ}) + ", max = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (double[])new double[]{boundingBoxMaxX, boundingBoxMaxY, boundingBoxMaxZ}));
    }
}

