/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class PoseReferenceFrame
extends ReferenceFrame {
    private final FramePose3D originPose;

    public PoseReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        super(frameName, parentFrame, parentFrame.isAStationaryFrame(), false);
        this.originPose = new FramePose3D(parentFrame);
    }

    public PoseReferenceFrame(String frameName, FramePose3DReadOnly poseInParentFrame) {
        this(frameName, poseInParentFrame.getReferenceFrame());
        this.setPoseAndUpdate(poseInParentFrame);
    }

    public PoseReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        this(frameName, parentFrame);
        this.setTransformAndUpdate(transformToParent);
    }

    public void setPoseAndUpdate(PoseReferenceFrame poseReferenceFrame) {
        this.getParent().checkReferenceFrameMatch(poseReferenceFrame.getParent());
        this.setPoseAndUpdate(poseReferenceFrame.originPose);
    }

    public void setPoseAndUpdate(FramePose3DReadOnly pose) {
        this.getParent().checkReferenceFrameMatch(pose);
        this.setPoseAndUpdate((Pose3DReadOnly)pose);
    }

    public void setPoseAndUpdate(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        position.checkReferenceFrameMatch(this.getParent());
        orientation.checkReferenceFrameMatch(this.getParent());
        this.setPoseAndUpdate((Point3DReadOnly)position, (Orientation3DReadOnly)orientation);
    }

    public void setPositionAndUpdate(FramePoint3DReadOnly position) {
        position.checkReferenceFrameMatch(this.getParent());
        this.setPositionAndUpdate((Point3DReadOnly)position);
    }

    public void setOrientationAndUpdate(FrameOrientation3DReadOnly orientation) {
        orientation.checkReferenceFrameMatch(this.getParent());
        this.setOrientationAndUpdate((Orientation3DReadOnly)orientation);
    }

    public void setPoseAndUpdate(Pose3DReadOnly pose) {
        this.setPoseAndUpdate(pose.getPosition(), (Orientation3DReadOnly)pose.getOrientation());
    }

    public void setPoseAndUpdate(Point3DReadOnly position, Orientation3DReadOnly orientation) {
        this.originPose.set((Tuple3DReadOnly)position, orientation);
        this.update();
    }

    public void setTransformAndUpdate(RigidBodyTransformReadOnly transformToParent) {
        this.originPose.set(transformToParent);
        this.update();
    }

    public void setPositionAndUpdate(Point3DReadOnly position) {
        this.setPositionAndUpdate(position.getX(), position.getY(), position.getZ());
    }

    public void setOrientationAndUpdate(Orientation3DReadOnly orientation) {
        this.originPose.getOrientation().set(orientation);
        this.update();
    }

    public void setPositionAndUpdate(double x, double y, double z) {
        this.originPose.getPosition().set(x, y, z);
        this.update();
    }

    public void setOrientationAndUpdate(double qx, double qy, double qz, double qs) {
        this.originPose.getOrientation().set(qx, qy, qz, qs);
        this.update();
    }

    public void prependTranslationAndUpdate(double x, double y, double z) {
        this.originPose.prependTranslation(x, y, z);
        this.update();
    }

    public double getTranslationX() {
        return this.getPose().getX();
    }

    public double getTranslationY() {
        return this.getPose().getY();
    }

    public double getTranslationZ() {
        return this.getPose().getZ();
    }

    public Pose3DReadOnly getPose() {
        return this.originPose;
    }

    public Point3DReadOnly getTranslation() {
        return this.getPose().getPosition();
    }

    public QuaternionReadOnly getOrientation() {
        return this.getPose().getOrientation();
    }

    @Override
    protected void updateTransformToParent(RigidBodyTransform transformToParentToPack) {
        this.originPose.checkReferenceFrameMatch(this.getParent());
        transformToParentToPack.set((RigidBodyTransformReadOnly)this.originPose);
    }

    @Override
    public String toString() {
        return super.toString() + ", originPose = " + String.valueOf(this.originPose);
    }
}

