/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePose3D
implements FramePose3DBasics,
Settable<FramePose3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics position = EuclidFrameFactories.newFixedFramePoint3DBasics(this);
    private final FixedFrameQuaternionBasics orientation = EuclidFrameFactories.newFixedFrameQuaternionBasics(this);

    public FramePose3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FramePose3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FramePose3D(Pose3DReadOnly pose3DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), pose3DReadOnly);
    }

    public FramePose3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose3DReadOnly) {
        this.setIncludingFrame(referenceFrame, pose3DReadOnly);
    }

    public FramePose3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly rigidBodyTransform) {
        this.setIncludingFrame(referenceFrame, rigidBodyTransform);
    }

    public FramePose3D(ReferenceFrame referenceFrame, Tuple3DReadOnly position, Orientation3DReadOnly orientation) {
        this.setIncludingFrame(referenceFrame, position, orientation);
    }

    public FramePose3D(FrameTuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.setIncludingFrame(position, orientation);
    }

    public FramePose3D(FramePose3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FramePose3D other) {
        FramePose3DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    @Override
    public FixedFrameQuaternionBasics getOrientation() {
        return this.orientation;
    }

    public boolean equals(Object object) {
        if (object instanceof FramePose3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.position, (Object)this.orientation);
    }
}

