/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FixedFrameOrientation3DBasics
extends FrameOrientation3DReadOnly,
Orientation3DBasics {
    default public void set(ReferenceFrame referenceFrame, Orientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(orientation);
    }

    default public void set(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(orientation);
    }

    default public void setFromReferenceFrame(ReferenceFrame referenceFrame) {
        this.setToZero();
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation) {
        this.set(orientation);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameOrientation3DReadOnly orientation) {
        this.setMatchingFrame(orientation.getReferenceFrame(), orientation);
    }

    default public void setRotationVector(ReferenceFrame referenceFrame, Vector3DReadOnly rotationVector) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setRotationVector(rotationVector);
    }

    default public void setRotationVector(FrameVector3DReadOnly rotationVector) {
        this.setRotationVector(rotationVector.getReferenceFrame(), rotationVector);
    }

    default public void setEuler(ReferenceFrame referenceFrame, Vector3DReadOnly eulerAngles) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setEuler(eulerAngles);
    }

    default public void setEuler(FrameVector3DReadOnly eulerAngles) {
        this.setEuler(eulerAngles.getReferenceFrame(), eulerAngles);
    }

    default public void set(ReferenceFrame referenceFrame, FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(orientation);
    }

    default public void set(FrameOrientation2DReadOnly orientation) {
        this.set(orientation.getReferenceFrame(), orientation);
    }

    default public void set(FrameOrientation3DReadOnly orientation) {
        this.set(orientation.getReferenceFrame(), orientation);
    }

    default public void setAndNormalize(FrameOrientation3DReadOnly orientation) {
        this.set(orientation);
        this.normalize();
    }

    default public void setAndInvert(FrameOrientation3DReadOnly orientation) {
        this.set(orientation);
        this.invert();
    }

    default public void append(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        this.append(orientation);
    }

    default public void appendInvertOther(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        this.appendInvertOther(orientation);
    }

    default public void appendInvertThis(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.appendInvertThis((Orientation3DReadOnly)orientation);
    }

    default public void appendInvertBoth(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.appendInvertBoth((Orientation3DReadOnly)orientation);
    }

    default public void prepend(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        this.prepend(orientation);
    }

    default public void prependInvertOther(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        this.prependInvertOther(orientation);
    }

    default public void prependInvertThis(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.prependInvertThis((Orientation3DReadOnly)orientation);
    }

    default public void prependInvertBoth(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch(orientation);
        super.prependInvertBoth((Orientation3DReadOnly)orientation);
    }
}

