/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FixedReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ReferenceFrameTools {
    private static final ReferenceFrame worldFrame = ReferenceFrameTools.constructARootFrame("World");

    private ReferenceFrameTools() {
    }

    public static ReferenceFrame constructARootFrame(String frameName) {
        ReferenceFrame ret = new ReferenceFrame(frameName){

            @Override
            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            }
        };
        return ret;
    }

    public static ReferenceFrame getWorldFrame() {
        return worldFrame;
    }

    public static ReferenceFrame constructFrameWithUnchangingTransformFromParent(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformFromParent) {
        RigidBodyTransform transformToParent = new RigidBodyTransform(transformFromParent);
        transformToParent.invert();
        return new FixedReferenceFrame(frameName, parentFrame, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static ReferenceFrame constructFrameWithUnchangingTranslationFromParent(String frameName, ReferenceFrame parentFrame, Tuple3DReadOnly translationOffsetFromParent) {
        return new FixedReferenceFrame(frameName, parentFrame, translationOffsetFromParent);
    }

    public static ReferenceFrame constructFrameWithUnchangingTransformToParent(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        return new FixedReferenceFrame(frameName, parentFrame, transformToParent);
    }

    public static ReferenceFrame constructFrameWithChangingTransformFromParent(String frameName, ReferenceFrame parentFrame, final RigidBodyTransformReadOnly transformFromParent) {
        ReferenceFrame frame = new ReferenceFrame(frameName, parentFrame){

            @Override
            protected void updateTransformToParent(RigidBodyTransform transformToParentToUpdate) {
                transformToParentToUpdate.setAndInvert(transformFromParent);
            }
        };
        frame.update();
        return frame;
    }

    public static ReferenceFrame constructFrameWithChangingTransformToParent(String frameName, ReferenceFrame parentFrame, final RigidBodyTransformReadOnly transformToParent) {
        ReferenceFrame frame = new ReferenceFrame(frameName, parentFrame){

            @Override
            protected void updateTransformToParent(RigidBodyTransform transformToParentToUpdate) {
                transformToParentToUpdate.set(transformToParent);
            }
        };
        frame.update();
        return frame;
    }

    public static ReferenceFrame[] createPathFromRoot(ReferenceFrame referenceFrame) {
        ReferenceFrame parentFrame = referenceFrame.getParent();
        if (parentFrame == null) {
            return new ReferenceFrame[]{referenceFrame};
        }
        int newLength = parentFrame.getFramesStartingWithRootEndingWithThis().length + 1;
        ReferenceFrame[] ret = Arrays.copyOf(parentFrame.getFramesStartingWithRootEndingWithThis(), newLength);
        ret[newLength - 1] = referenceFrame;
        return ret;
    }

    public static boolean areEqualOrStationary(ReferenceFrame frameA, ReferenceFrame frameB) {
        if (frameA == frameB) {
            return true;
        }
        return frameA.isAStationaryFrame() && frameB.isAStationaryFrame();
    }

    public static void checkEqualOrStationary(ReferenceFrame frameA, ReferenceFrame frameB) {
        if (!ReferenceFrameTools.areEqualOrStationary(frameA, frameB)) {
            throw new RuntimeException("Frames expected to be equal or stationary: " + frameA + ", " + frameB);
        }
    }

    public static void clearFrameTree(ReferenceFrame frame) {
        frame.getRootFrame().clearChildren();
    }

    public static void clearWorldFrameTree() {
        worldFrame.clearChildren();
    }

    public static Collection<ReferenceFrame> getAllFramesInTree(ReferenceFrame frame) {
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.add(frame.getRootFrame());
        ReferenceFrameTools.collectAllDescendants(frame.getRootFrame(), frames);
        return frames;
    }

    public static List<ReferenceFrame> collectFramesInSubtree(ReferenceFrame start) {
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.add(start);
        ReferenceFrameTools.collectAllDescendants(start, frames);
        return frames;
    }

    private static void collectAllDescendants(ReferenceFrame frame, Collection<ReferenceFrame> collectionToPack) {
        for (int i = 0; i < frame.getNumberOfChildren(); ++i) {
            ReferenceFrame child = frame.getChild(i);
            if (child == null) continue;
            collectionToPack.add(child);
            ReferenceFrameTools.collectAllDescendants(child, collectionToPack);
        }
    }
}

