/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.ObjDoubleConsumer;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryFactories;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class EuclidFrameFactories {
    private EuclidFrameFactories() {
    }

    public static FramePoint2DReadOnly newLinkedFramePoint2DReadOnly(DoubleSupplier scaleSupplier, FrameTuple2DReadOnly originalTuple) {
        return EuclidFrameFactories.newLinkedFramePoint2DReadOnly(originalTuple, EuclidCoreFactories.newLinkedPoint2DReadOnly((DoubleSupplier)scaleSupplier, (Tuple2DReadOnly)originalTuple));
    }

    public static FrameVector2DReadOnly newLinkedFrameVector2DReadOnly(DoubleSupplier scaleSupplier, FrameTuple2DReadOnly originalTuple) {
        return EuclidFrameFactories.newLinkedFrameVector2DReadOnly(originalTuple, EuclidCoreFactories.newLinkedVector2DReadOnly((DoubleSupplier)scaleSupplier, (Tuple2DReadOnly)originalTuple));
    }

    public static FramePoint3DReadOnly newLinkedFramePoint3DReadOnly(DoubleSupplier scaleSupplier, FrameTuple3DReadOnly originalTuple) {
        return EuclidFrameFactories.newLinkedFramePoint3DReadOnly(originalTuple, EuclidCoreFactories.newLinkedPoint3DReadOnly((DoubleSupplier)scaleSupplier, (Tuple3DReadOnly)originalTuple));
    }

    public static FrameVector3DReadOnly newLinkedFrameVector3DReadOnly(DoubleSupplier scaleSupplier, FrameTuple3DReadOnly originalTuple) {
        return EuclidFrameFactories.newLinkedFrameVector3DReadOnly(originalTuple, EuclidCoreFactories.newLinkedVector3DReadOnly((DoubleSupplier)scaleSupplier, (Tuple3DReadOnly)originalTuple));
    }

    public static FramePoint2DReadOnly newLinkedFramePoint2DReadOnly(ReferenceFrameHolder referenceFrameHolder, DoubleSupplier xSupplier, DoubleSupplier ySupplier) {
        return EuclidFrameFactories.newLinkedFramePoint2DReadOnly(referenceFrameHolder, EuclidCoreFactories.newLinkedPoint2DReadOnly((DoubleSupplier)xSupplier, (DoubleSupplier)ySupplier));
    }

    public static FrameVector2DReadOnly newLinkedFrameVector2DReadOnly(ReferenceFrameHolder referenceFrameHolder, DoubleSupplier xSupplier, DoubleSupplier ySupplier) {
        return EuclidFrameFactories.newLinkedFrameVector2DReadOnly(referenceFrameHolder, EuclidCoreFactories.newLinkedVector2DReadOnly((DoubleSupplier)xSupplier, (DoubleSupplier)ySupplier));
    }

    public static FramePoint3DReadOnly newLinkedFramePoint3DReadOnly(ReferenceFrameHolder referenceFrameHolder, DoubleSupplier xSupplier, DoubleSupplier ySupplier, DoubleSupplier zSupplier) {
        return EuclidFrameFactories.newLinkedFramePoint3DReadOnly(referenceFrameHolder, EuclidCoreFactories.newLinkedPoint3DReadOnly((DoubleSupplier)xSupplier, (DoubleSupplier)ySupplier, (DoubleSupplier)zSupplier));
    }

    public static FrameVector3DReadOnly newLinkedFrameVector3DReadOnly(ReferenceFrameHolder referenceFrameHolder, DoubleSupplier xSupplier, DoubleSupplier ySupplier, DoubleSupplier zSupplier) {
        return EuclidFrameFactories.newLinkedFrameVector3DReadOnly(referenceFrameHolder, EuclidCoreFactories.newLinkedVector3DReadOnly((DoubleSupplier)xSupplier, (DoubleSupplier)ySupplier, (DoubleSupplier)zSupplier));
    }

    public static FramePoint2DReadOnly newLinkedFramePoint2DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Point2DReadOnly point) {
        return new FramePoint2DReadOnly(){

            public double getX() {
                return point.getX();
            }

            public double getY() {
                return point.getY();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FramePoint2DReadOnly) {
                    return this.equals((FramePoint2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FrameVector2DReadOnly newLinkedFrameVector2DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Vector2DReadOnly vector) {
        return new FrameVector2DReadOnly(){

            public double getX() {
                return vector.getX();
            }

            public double getY() {
                return vector.getY();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVector2DReadOnly) {
                    return this.equals((FrameVector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FramePoint3DReadOnly newLinkedFramePoint3DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Point3DReadOnly point) {
        return new FramePoint3DReadOnly(){

            public double getX() {
                return point.getX();
            }

            public double getY() {
                return point.getY();
            }

            public double getZ() {
                return point.getZ();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FramePoint3DReadOnly) {
                    return this.equals((FramePoint3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FrameVector3DReadOnly newLinkedFrameVector3DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Vector3DReadOnly vector) {
        return new FrameVector3DReadOnly(){

            public double getX() {
                return vector.getX();
            }

            public double getY() {
                return vector.getY();
            }

            public double getZ() {
                return vector.getZ();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVector3DReadOnly) {
                    return this.equals((FrameVector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FrameUnitVector2DReadOnly newLinkedFrameUnitVector2DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final UnitVector2DReadOnly unitVector) {
        return new FrameUnitVector2DReadOnly(){

            public boolean isDirty() {
                return unitVector.isDirty();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return unitVector.getX();
            }

            public double getY() {
                return unitVector.getY();
            }

            public double getRawX() {
                return unitVector.getRawX();
            }

            public double getRawY() {
                return unitVector.getRawY();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVector2DReadOnly) {
                    return this.equals((FrameVector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FrameUnitVector3DReadOnly newLinkedFrameUnitVector3DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final UnitVector3DReadOnly unitVector) {
        return new FrameUnitVector3DReadOnly(){

            public boolean isDirty() {
                return unitVector.isDirty();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return unitVector.getX();
            }

            public double getY() {
                return unitVector.getY();
            }

            public double getZ() {
                return unitVector.getZ();
            }

            public double getRawX() {
                return unitVector.getRawX();
            }

            public double getRawY() {
                return unitVector.getRawY();
            }

            public double getRawZ() {
                return unitVector.getRawZ();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVector3DReadOnly) {
                    return this.equals((FrameVector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FrameRotationMatrixReadOnly newLinkedFrameRotationMatrixReadOnly(final ReferenceFrameHolder referenceFrameHolder, final RotationMatrixReadOnly rotationMatrix) {
        return new FrameRotationMatrixReadOnly(){

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean isDirty() {
                return rotationMatrix.isDirty();
            }

            public double getM00() {
                return rotationMatrix.getM00();
            }

            public double getM01() {
                return rotationMatrix.getM01();
            }

            public double getM02() {
                return rotationMatrix.getM02();
            }

            public double getM10() {
                return rotationMatrix.getM10();
            }

            public double getM11() {
                return rotationMatrix.getM11();
            }

            public double getM12() {
                return rotationMatrix.getM12();
            }

            public double getM20() {
                return rotationMatrix.getM20();
            }

            public double getM21() {
                return rotationMatrix.getM21();
            }

            public double getM22() {
                return rotationMatrix.getM22();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getM00(), (double)this.getM01(), (double)this.getM02(), (double)this.getM10(), (double)this.getM11(), (double)this.getM12(), (double)this.getM20(), (double)this.getM21(), (double)this.getM22()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameMatrix3DReadOnly) {
                    return this.equals((FrameMatrix3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FrameQuaternionReadOnly newLinkedFrameQuaternionReadOnly(final ReferenceFrameHolder referenceFrameHolder, final QuaternionReadOnly quaternion) {
        return new FrameQuaternionReadOnly(){

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return quaternion.getX();
            }

            public double getY() {
                return quaternion.getY();
            }

            public double getZ() {
                return quaternion.getZ();
            }

            public double getS() {
                return quaternion.getS();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)this.getS()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameQuaternionReadOnly) {
                    return this.equals((FrameQuaternionReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FramePoint2DReadOnly newNegativeLinkedFramePoint2D(FramePoint2DReadOnly originalPoint) {
        return EuclidFrameFactories.newLinkedFramePoint2DReadOnly(originalPoint, EuclidCoreFactories.newNegativeLinkedPoint2D((Point2DReadOnly)originalPoint));
    }

    public static FrameVector2DReadOnly newNegativeLinkedFrameVector2D(FrameVector2DReadOnly originalVector) {
        return EuclidFrameFactories.newLinkedFrameVector2DReadOnly(originalVector, EuclidCoreFactories.newNegativeLinkedVector2D((Vector2DReadOnly)originalVector));
    }

    public static FramePoint3DReadOnly newNegativeLinkedFramePoint3D(FramePoint3DReadOnly originalPoint) {
        return EuclidFrameFactories.newLinkedFramePoint3DReadOnly(originalPoint, EuclidCoreFactories.newNegativeLinkedPoint3D((Point3DReadOnly)originalPoint));
    }

    public static FrameVector3DReadOnly newNegativeLinkedFrameVector3D(FrameVector3DReadOnly originalVector) {
        return EuclidFrameFactories.newLinkedFrameVector3DReadOnly(originalVector, EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)originalVector));
    }

    public static FixedFramePoint2DBasics newFixedFramePoint2DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFramePoint2DBasics(referenceFrameHolder, (Point2DBasics)new Point2D());
    }

    public static FixedFramePoint2DBasics newLinkedFixedFramePoint2DBasics(final ReferenceFrameHolder referenceFrameHolder, final Point2DBasics originalPoint) {
        return new FixedFramePoint2DBasics(){

            public void setX(double x) {
                originalPoint.setX(x);
            }

            public void setY(double y) {
                originalPoint.setY(y);
            }

            public double getX() {
                return originalPoint.getX();
            }

            public double getY() {
                return originalPoint.getY();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FramePoint2DReadOnly) {
                    return this.equals((FramePoint2DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameVector2DBasics newFixedFrameVector2DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameVector2DBasics(referenceFrameHolder, (Vector2DBasics)new Vector2D());
    }

    public static FixedFrameVector2DBasics newLinkedFixedFrameVector2DBasics(final ReferenceFrameHolder referenceFrameHolder, final Vector2DBasics originalVector) {
        return new FixedFrameVector2DBasics(){

            public void setX(double x) {
                originalVector.setX(x);
            }

            public void setY(double y) {
                originalVector.setY(y);
            }

            public double getX() {
                return originalVector.getX();
            }

            public double getY() {
                return originalVector.getY();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameVector2DReadOnly) {
                    return this.equals((FrameVector2DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFramePoint3DBasics newFixedFramePoint3DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFramePoint3DBasics(referenceFrameHolder, (Point3DBasics)new Point3D());
    }

    public static FixedFramePoint3DBasics newLinkedFixedFramePoint3DBasics(final ReferenceFrameHolder referenceFrameHolder, final Point3DBasics originalPoint) {
        return new FixedFramePoint3DBasics(){

            public void setX(double x) {
                originalPoint.setX(x);
            }

            public void setY(double y) {
                originalPoint.setY(y);
            }

            public void setZ(double z) {
                originalPoint.setZ(z);
            }

            public double getX() {
                return originalPoint.getX();
            }

            public double getY() {
                return originalPoint.getY();
            }

            public double getZ() {
                return originalPoint.getZ();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FramePoint3DReadOnly) {
                    return this.equals((FramePoint3DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameVector3DBasics newFixedFrameVector3DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameVector3DBasics(referenceFrameHolder, (Vector3DBasics)new Vector3D());
    }

    public static FixedFrameVector3DBasics newLinkedFixedFrameVector3DBasics(final ReferenceFrameHolder referenceFrameHolder, final Vector3DBasics originalVector) {
        return new FixedFrameVector3DBasics(){

            public void setX(double x) {
                originalVector.setX(x);
            }

            public void setY(double y) {
                originalVector.setY(y);
            }

            public void setZ(double z) {
                originalVector.setZ(z);
            }

            public double getX() {
                return originalVector.getX();
            }

            public double getY() {
                return originalVector.getY();
            }

            public double getZ() {
                return originalVector.getZ();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameVector3DReadOnly) {
                    return this.equals((FrameVector3DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameUnitVector2DBasics newFixedFrameUnitVector2DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newFixedFrameUnitVector2DBasics(referenceFrameHolder, (Vector2DReadOnly)Axis2D.X);
    }

    public static FixedFrameUnitVector2DBasics newFixedFrameUnitVector2DBasics(ReferenceFrameHolder referenceFrameHolder, Vector2DReadOnly initialValue) {
        return EuclidFrameFactories.newFixedFrameUnitVector2DBasics(referenceFrameHolder, initialValue.getX(), initialValue.getY());
    }

    public static FixedFrameUnitVector2DBasics newFixedFrameUnitVector2DBasics(ReferenceFrameHolder referenceFrameHolder, double initialX, double initialY) {
        return EuclidFrameFactories.newLinkedFixedFrameUnitVector2DBasics(referenceFrameHolder, (UnitVector2DBasics)new UnitVector2D(initialX, initialY));
    }

    public static FixedFrameUnitVector2DBasics newLinkedFixedFrameUnitVector2DBasics(final ReferenceFrameHolder referenceFrameHolder, final UnitVector2DBasics originalUnitVector) {
        return new FixedFrameUnitVector2DBasics(){

            public void absolute() {
                originalUnitVector.absolute();
            }

            public void negate() {
                originalUnitVector.negate();
            }

            public void normalize() {
                originalUnitVector.normalize();
            }

            public void markAsDirty() {
                originalUnitVector.markAsDirty();
            }

            public boolean isDirty() {
                return originalUnitVector.isDirty();
            }

            public void set(UnitVector2DReadOnly other) {
                originalUnitVector.set(other);
            }

            public void setX(double x) {
                originalUnitVector.setX(x);
            }

            public void setY(double y) {
                originalUnitVector.setY(y);
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return originalUnitVector.getX();
            }

            public double getY() {
                return originalUnitVector.getY();
            }

            public double getRawX() {
                return originalUnitVector.getRawX();
            }

            public double getRawY() {
                return originalUnitVector.getRawY();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVector2DReadOnly) {
                    return this.equals((FrameVector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameUnitVector3DBasics newFixedFrameUnitVector3DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newFixedFrameUnitVector3DBasics(referenceFrameHolder, (Vector3DReadOnly)Axis3D.X);
    }

    public static FixedFrameUnitVector3DBasics newFixedFrameUnitVector3DBasics(ReferenceFrameHolder referenceFrameHolder, Vector3DReadOnly initialValue) {
        return EuclidFrameFactories.newFixedFrameUnitVector3DBasics(referenceFrameHolder, initialValue.getX(), initialValue.getY(), initialValue.getZ());
    }

    public static FixedFrameUnitVector3DBasics newFixedFrameUnitVector3DBasics(ReferenceFrameHolder referenceFrameHolder, double initialX, double initialY, double initialZ) {
        return EuclidFrameFactories.newLinkedFixedFrameUnitVector3DBasics(referenceFrameHolder, (UnitVector3DBasics)new UnitVector3D(initialX, initialY, initialZ));
    }

    public static FixedFrameUnitVector3DBasics newLinkedFixedFrameUnitVector3DBasics(final ReferenceFrameHolder referenceFrameHolder, final UnitVector3DBasics originalUnitVector) {
        return new FixedFrameUnitVector3DBasics(){

            public void absolute() {
                originalUnitVector.absolute();
            }

            public void negate() {
                originalUnitVector.negate();
            }

            public void normalize() {
                originalUnitVector.normalize();
            }

            public void markAsDirty() {
                originalUnitVector.markAsDirty();
            }

            public boolean isDirty() {
                return originalUnitVector.isDirty();
            }

            public void set(UnitVector3DReadOnly other) {
                originalUnitVector.set(other);
            }

            public void setX(double x) {
                originalUnitVector.setX(x);
            }

            public void setY(double y) {
                originalUnitVector.setY(y);
            }

            public void setZ(double z) {
                originalUnitVector.setZ(z);
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return originalUnitVector.getX();
            }

            public double getY() {
                return originalUnitVector.getY();
            }

            public double getZ() {
                return originalUnitVector.getZ();
            }

            public double getRawX() {
                return originalUnitVector.getRawX();
            }

            public double getRawY() {
                return originalUnitVector.getRawY();
            }

            public double getRawZ() {
                return originalUnitVector.getRawZ();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVector3DReadOnly) {
                    return this.equals((FrameVector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameOrientation2DBasics newFixedFrameOrientation2DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameOrientation2DBasics(referenceFrameHolder, (Orientation2DBasics)new Orientation2D());
    }

    public static FixedFrameOrientation2DBasics newLinkedFixedFrameOrientation2DBasics(final ReferenceFrameHolder referenceFrameHolder, final Orientation2DBasics originalOrientation) {
        return new FixedFrameOrientation2DBasics(){

            public void setYaw(double yaw) {
                originalOrientation.setYaw(yaw);
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getYaw() {
                return originalOrientation.getYaw();
            }

            public void applyTransform(Transform transform) {
                originalOrientation.applyTransform(transform);
            }

            public void applyInverseTransform(Transform transform) {
                originalOrientation.applyInverseTransform(transform);
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameOrientation2DReadOnly) {
                    return this.equals((FrameOrientation2DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getYaw()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameQuaternionBasics newFixedFrameQuaternionBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics(referenceFrameHolder, (QuaternionBasics)new Quaternion());
    }

    public static FixedFrameQuaternionBasics newLinkedFixedFrameQuaternionBasics(final ReferenceFrameHolder referenceFrameHolder, final QuaternionBasics originalQuaternion) {
        return new FixedFrameQuaternionBasics(){

            public void setUnsafe(double qx, double qy, double qz, double qs) {
                originalQuaternion.setUnsafe(qx, qy, qz, qs);
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return originalQuaternion.getX();
            }

            public double getY() {
                return originalQuaternion.getY();
            }

            public double getZ() {
                return originalQuaternion.getZ();
            }

            public double getS() {
                return originalQuaternion.getS();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameQuaternionReadOnly) {
                    return this.equals((FrameQuaternionReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)this.getS()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameRotationMatrixBasics newFixedFrameRotationMatrixBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameRotationMatrixBasics(referenceFrameHolder, (RotationMatrixBasics)new RotationMatrix());
    }

    public static FixedFrameRotationMatrixBasics newLinkedFixedFrameRotationMatrixBasics(final ReferenceFrameHolder referenceFrameHolder, final RotationMatrixBasics originalRotationMatrix) {
        return new FixedFrameRotationMatrixBasics(){

            public void setUnsafe(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                originalRotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            }

            public void set(RotationMatrixReadOnly other) {
                originalRotationMatrix.set(other);
            }

            public void setIdentity() {
                originalRotationMatrix.setIdentity();
            }

            public void setToNaN() {
                originalRotationMatrix.setToNaN();
            }

            public void normalize() {
                originalRotationMatrix.normalize();
            }

            public boolean isIdentity() {
                return originalRotationMatrix.isIdentity();
            }

            public void transpose() {
                originalRotationMatrix.transpose();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean isDirty() {
                return originalRotationMatrix.isDirty();
            }

            public double getM00() {
                return originalRotationMatrix.getM00();
            }

            public double getM01() {
                return originalRotationMatrix.getM01();
            }

            public double getM02() {
                return originalRotationMatrix.getM02();
            }

            public double getM10() {
                return originalRotationMatrix.getM10();
            }

            public double getM11() {
                return originalRotationMatrix.getM11();
            }

            public double getM12() {
                return originalRotationMatrix.getM12();
            }

            public double getM20() {
                return originalRotationMatrix.getM20();
            }

            public double getM21() {
                return originalRotationMatrix.getM21();
            }

            public double getM22() {
                return originalRotationMatrix.getM22();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameRotationMatrixReadOnly) {
                    return this.equals((FrameRotationMatrixReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getM00(), (double)this.getM01(), (double)this.getM02(), (double)this.getM10(), (double)this.getM11(), (double)this.getM12(), (double)this.getM20(), (double)this.getM21(), (double)this.getM22()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static FixedFrameBoundingBox2DBasics newFixedFrameBoundingBox2DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameBoundingBox2DBasics(referenceFrameHolder, (BoundingBox2DBasics)new BoundingBox2D());
    }

    public static FixedFrameBoundingBox2DBasics newLinkedFixedFrameBoundingBox2DBasics(final ReferenceFrameHolder referenceFrameHolder, final BoundingBox2DBasics originalBoundingBox) {
        FixedFrameBoundingBox2DBasics fixedFrameBoundingBox2DBasics = new FixedFrameBoundingBox2DBasics(){
            private final FixedFramePoint2DBasics minPoint;
            private final FixedFramePoint2DBasics maxPoint;
            {
                this.minPoint = EuclidFrameFactories.newLinkedFixedFramePoint2DBasics(referenceFrameHolder, originalBoundingBox.getMinPoint());
                this.maxPoint = EuclidFrameFactories.newLinkedFixedFramePoint2DBasics(referenceFrameHolder, originalBoundingBox.getMaxPoint());
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFramePoint2DBasics getMinPoint() {
                return this.minPoint;
            }

            @Override
            public FixedFramePoint2DBasics getMaxPoint() {
                return this.maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof FrameBoundingBox2DReadOnly) {
                    return this.equals((FrameBoundingBox2DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
        return fixedFrameBoundingBox2DBasics;
    }

    public static FixedFrameBoundingBox3DBasics newFixedFrameBoundingBox3DBasics(ReferenceFrameHolder referenceFrameHolder) {
        return EuclidFrameFactories.newLinkedFixedFrameBoundingBox3DBasics(referenceFrameHolder, (BoundingBox3DBasics)new BoundingBox3D());
    }

    public static FixedFrameBoundingBox3DBasics newLinkedFixedFrameBoundingBox3DBasics(final ReferenceFrameHolder referenceFrameHolder, final BoundingBox3DBasics originalBoundingBox) {
        FixedFrameBoundingBox3DBasics fixedFrameBoundingBox3DBasics = new FixedFrameBoundingBox3DBasics(){
            private final FixedFramePoint3DBasics minPoint;
            private final FixedFramePoint3DBasics maxPoint;
            {
                this.minPoint = EuclidFrameFactories.newLinkedFixedFramePoint3DBasics(referenceFrameHolder, originalBoundingBox.getMinPoint());
                this.maxPoint = EuclidFrameFactories.newLinkedFixedFramePoint3DBasics(referenceFrameHolder, originalBoundingBox.getMaxPoint());
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFramePoint3DBasics getMinPoint() {
                return this.minPoint;
            }

            @Override
            public FixedFramePoint3DBasics getMaxPoint() {
                return this.maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof FrameBoundingBox3DReadOnly) {
                    return this.equals((FrameBoundingBox3DReadOnly)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
        return fixedFrameBoundingBox3DBasics;
    }

    public static FramePoint2DReadOnly newObservableFramePoint2DReadOnly(Consumer<Axis2D> valueAccessedListener, FramePoint2DReadOnly source) {
        return EuclidFrameFactories.newLinkedFramePoint2DReadOnly(source, EuclidCoreFactories.newObservablePoint2DReadOnly(valueAccessedListener, (Point2DReadOnly)source));
    }

    public static FramePoint3DReadOnly newObservableFramePoint3DReadOnly(Consumer<Axis3D> valueAccessedListener, FramePoint3DReadOnly source) {
        return EuclidFrameFactories.newLinkedFramePoint3DReadOnly(source, EuclidCoreFactories.newObservablePoint3DReadOnly(valueAccessedListener, (Point3DReadOnly)source));
    }

    public static FrameVector2DReadOnly newObservableFrameVector2DReadOnly(Consumer<Axis2D> valueAccessedListener, FrameVector2DReadOnly source) {
        return EuclidFrameFactories.newLinkedFrameVector2DReadOnly(source, EuclidCoreFactories.newObservableVector2DReadOnly(valueAccessedListener, (Vector2DReadOnly)source));
    }

    public static FrameVector3DReadOnly newObservableFrameVector3DReadOnly(Consumer<Axis3D> valueAccessedListener, FrameVector3DReadOnly source) {
        return EuclidFrameFactories.newLinkedFrameVector3DReadOnly(source, EuclidCoreFactories.newObservableVector3DReadOnly(valueAccessedListener, (Vector3DReadOnly)source));
    }

    public static FrameUnitVector2DReadOnly newObservableFrameUnitVector2DReadOnly(Consumer<Axis2D> valueAccessedListener, FrameUnitVector2DReadOnly source) {
        return EuclidFrameFactories.newLinkedFrameUnitVector2DReadOnly(source, EuclidCoreFactories.newObservableUnitVector2DReadOnly(valueAccessedListener, (UnitVector2DReadOnly)source));
    }

    public static FrameUnitVector3DReadOnly newObservableFrameUnitVector3DReadOnly(Consumer<Axis3D> valueAccessedListener, FrameUnitVector3DReadOnly source) {
        return EuclidFrameFactories.newLinkedFrameUnitVector3DReadOnly(source, EuclidCoreFactories.newObservableUnitVector3DReadOnly(valueAccessedListener, (UnitVector3DReadOnly)source));
    }

    public static FrameRotationMatrixReadOnly newObservableFrameRotationMatrixReadOnly(BiConsumer<Axis3D, Axis3D> valueAccessedListener, FrameRotationMatrixReadOnly source) {
        return EuclidFrameFactories.newLinkedFrameRotationMatrixReadOnly(source, EuclidCoreFactories.newObservableRotationMatrixReadOnly(valueAccessedListener, (RotationMatrixReadOnly)source));
    }

    public static FrameQuaternionReadOnly newObservableFrameQuaternionReadOnly(IntConsumer valueAccessedListener, FrameQuaternionReadOnly source) {
        return EuclidFrameFactories.newLinkedFrameQuaternionReadOnly(source, EuclidCoreFactories.newObservableQuaternionReadOnly((IntConsumer)valueAccessedListener, (QuaternionReadOnly)source));
    }

    public static FixedFramePoint2DBasics newObservableFixedFramePoint2DBasics(ReferenceFrameHolder referenceFrameHolder, ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFramePoint2DBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFramePoint2DBasics(referenceFrameHolder));
    }

    public static FixedFramePoint2DBasics newObservableFixedFramePoint2DBasics(ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener, FixedFramePoint2DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFramePoint2DBasics(source, EuclidCoreFactories.newObservablePoint2DBasics(valueChangedListener, valueAccessedListener, (Point2DBasics)source));
    }

    public static FixedFramePoint3DBasics newObservableFixedFramePoint3DBasics(ReferenceFrameHolder referenceFrameHolder, ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFramePoint3DBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFramePoint3DBasics(referenceFrameHolder));
    }

    public static FixedFramePoint3DBasics newObservableFixedFramePoint3DBasics(ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener, FixedFramePoint3DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFramePoint3DBasics(source, EuclidCoreFactories.newObservablePoint3DBasics(valueChangedListener, valueAccessedListener, (Point3DBasics)source));
    }

    public static FixedFrameVector2DBasics newObservableFixedFrameVector2DBasics(ReferenceFrameHolder referenceFrameHolder, ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFrameVector2DBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFrameVector2DBasics(referenceFrameHolder));
    }

    public static FixedFrameVector2DBasics newObservableFixedFrameVector2DBasics(ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener, FixedFrameVector2DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameVector2DBasics(source, EuclidCoreFactories.newObservableVector2DBasics(valueChangedListener, valueAccessedListener, (Vector2DBasics)source));
    }

    public static FixedFrameVector3DBasics newObservableFixedFrameVector3DBasics(ReferenceFrameHolder referenceFrameHolder, ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFrameVector3DBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFrameVector3DBasics(referenceFrameHolder));
    }

    public static FixedFrameVector3DBasics newObservableFixedFrameVector3DBasics(ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener, FixedFrameVector3DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameVector3DBasics(source, EuclidCoreFactories.newObservableVector3DBasics(valueChangedListener, valueAccessedListener, (Vector3DBasics)source));
    }

    public static FixedFrameUnitVector2DBasics newObservableFixedFrameUnitVector2DBasics(ReferenceFrameHolder referenceFrameHolder, ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFrameUnitVector2DBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFrameUnitVector2DBasics(referenceFrameHolder));
    }

    public static FixedFrameUnitVector2DBasics newObservableFixedFrameUnitVector2DBasics(ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener, FixedFrameUnitVector2DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameUnitVector2DBasics(source, EuclidCoreFactories.newObservableUnitVector2DBasics(valueChangedListener, valueAccessedListener, (UnitVector2DBasics)source));
    }

    public static FixedFrameUnitVector3DBasics newObservableFixedFrameUnitVector3DBasics(ReferenceFrameHolder referenceFrameHolder, ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFrameUnitVector3DBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFrameUnitVector3DBasics(referenceFrameHolder));
    }

    public static FixedFrameUnitVector3DBasics newObservableFixedFrameUnitVector3DBasics(ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener, FixedFrameUnitVector3DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameUnitVector3DBasics(source, EuclidCoreFactories.newObservableUnitVector3DBasics(valueChangedListener, valueAccessedListener, (UnitVector3DBasics)source));
    }

    public static FixedFrameRotationMatrixBasics newObservableFixedFrameRotationMatrixBasics(ReferenceFrameHolder referenceFrameHolder, Runnable valueChangedListener, BiConsumer<Axis3D, Axis3D> valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFrameRotationMatrixBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFrameRotationMatrixBasics(referenceFrameHolder));
    }

    public static FixedFrameRotationMatrixBasics newObservableFixedFrameRotationMatrixBasics(Runnable valueChangedListener, BiConsumer<Axis3D, Axis3D> valueAccessedListener, FixedFrameRotationMatrixBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameRotationMatrixBasics(source, EuclidCoreFactories.newObservableRotationMatrixBasics((Runnable)valueChangedListener, valueAccessedListener, (RotationMatrixBasics)source));
    }

    public static FixedFrameQuaternionBasics newObservableFixedFrameQuaternionBasics(ReferenceFrameHolder referenceFrameHolder, Runnable valueChangedListener, IntConsumer valueAccessedListener) {
        return EuclidFrameFactories.newObservableFixedFrameQuaternionBasics(valueChangedListener, valueAccessedListener, EuclidFrameFactories.newFixedFrameQuaternionBasics(referenceFrameHolder));
    }

    public static FixedFrameQuaternionBasics newObservableFixedFrameQuaternionBasics(Runnable valueChangedListener, IntConsumer valueAccessedListener, FixedFrameQuaternionBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics(source, EuclidCoreFactories.newObservableQuaternionBasics((Runnable)valueChangedListener, (IntConsumer)valueAccessedListener, (QuaternionBasics)source));
    }

    public static FixedFrameBoundingBox2DBasics newObservableFixedFrameBoundingBox2DBasics(ReferenceFrameHolder referenceFrameHolder, EuclidGeometryFactories.BoundingBoxChangedListener<Axis2D> valueChangedListener, BiConsumer<Axis2D, Bound> valueAccessedListener) {
        return EuclidFrameFactories.newLinkedFixedFrameBoundingBox2DBasics(referenceFrameHolder, EuclidGeometryFactories.newObservableBoundingBox2DBasics(valueChangedListener, valueAccessedListener));
    }

    public static FixedFrameBoundingBox2DBasics newObservableFixedFrameBoundingBox2DBasics(EuclidGeometryFactories.BoundingBoxChangedListener<Axis2D> valueChangedListener, BiConsumer<Axis2D, Bound> valueAccessedListener, FixedFrameBoundingBox2DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameBoundingBox2DBasics(source, EuclidGeometryFactories.newObservableBoundingBox2DBasics(valueChangedListener, valueAccessedListener, (BoundingBox2DBasics)source));
    }

    public static FixedFrameBoundingBox3DBasics newObservableFixedFrameBoundingBox3DBasics(ReferenceFrameHolder referenceFrameHolder, EuclidGeometryFactories.BoundingBoxChangedListener<Axis3D> valueChangedListener, BiConsumer<Axis3D, Bound> valueAccessedListener) {
        return EuclidFrameFactories.newLinkedFixedFrameBoundingBox3DBasics(referenceFrameHolder, EuclidGeometryFactories.newObservableBoundingBox3DBasics(valueChangedListener, valueAccessedListener));
    }

    public static FixedFrameBoundingBox3DBasics newObservableFixedFrameBoundingBox3DBasics(EuclidGeometryFactories.BoundingBoxChangedListener<Axis3D> valueChangedListener, BiConsumer<Axis3D, Bound> valueAccessedListener, FixedFrameBoundingBox3DBasics source) {
        return EuclidFrameFactories.newLinkedFixedFrameBoundingBox3DBasics(source, EuclidGeometryFactories.newObservableBoundingBox3DBasics(valueChangedListener, valueAccessedListener, (BoundingBox3DBasics)source));
    }
}

