/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePoint3D
implements FramePoint3DBasics,
Settable<FramePoint3D> {
    private ReferenceFrame referenceFrame;
    private final Point3D point = new Point3D();

    public FramePoint3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FramePoint3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FramePoint3D(ReferenceFrame referenceFrame, double x, double y, double z) {
        this.setIncludingFrame(referenceFrame, x, y, z);
    }

    public FramePoint3D(ReferenceFrame referenceFrame, double[] pointArray) {
        this.setIncludingFrame(referenceFrame, pointArray);
    }

    public FramePoint3D(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public FramePoint3D(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly, 0.0);
    }

    public FramePoint3D(FrameTuple2DReadOnly frameTuple2DReadOnly) {
        this.setIncludingFrame(frameTuple2DReadOnly, 0.0);
    }

    public FramePoint3D(FrameTuple3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FramePoint3D other) {
        FramePoint3DBasics.super.set((FrameTuple3DReadOnly)other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.point.setX(x);
    }

    public void setY(double y) {
        this.point.setY(y);
    }

    public void setZ(double z) {
        this.point.setZ(z);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    public double getZ() {
        return this.point.getZ();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.referenceFrame);
    }
}

