/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.Location;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameTools {
    private EuclidFrameTools() {
    }

    public static boolean areLine2DsCollinear(FramePoint2DReadOnly firstPointOnLine1, FramePoint2DReadOnly secondPointOnLine1, FramePoint2DReadOnly firstPointOnLine2, FramePoint2DReadOnly secondPointOnLine2, double angleEpsilon, double distanceEpsilon) {
        firstPointOnLine1.checkReferenceFrameMatch(secondPointOnLine1, firstPointOnLine2, secondPointOnLine2);
        return EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    public static boolean areLine2DsCollinear(FramePoint2DReadOnly pointOnLine1, FrameVector2DReadOnly lineDirection1, FramePoint2DReadOnly firstPointOnLine2, FramePoint2DReadOnly secondPointOnLine2, double angleEpsilon, double distanceEpsilon) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, firstPointOnLine2, secondPointOnLine2);
        return EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    public static boolean areLine2DsCollinear(FramePoint2DReadOnly pointOnLine1, FrameVector2DReadOnly lineDirection1, FramePoint2DReadOnly pointOnLine2, FrameVector2DReadOnly lineDirection2, double angleEpsilon, double distanceEpsilon) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        return EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    public static boolean areLine3DsCollinear(FramePoint3DReadOnly firstPointOnLine1, FramePoint3DReadOnly secondPointOnLine1, FramePoint3DReadOnly firstPointOnLine2, FramePoint3DReadOnly secondPointOnLine2, double angleEpsilon, double distanceEpsilon) {
        firstPointOnLine1.checkReferenceFrameMatch(secondPointOnLine1, firstPointOnLine2, secondPointOnLine2);
        return EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)firstPointOnLine1, (Point3DReadOnly)secondPointOnLine1, (Point3DReadOnly)firstPointOnLine2, (Point3DReadOnly)secondPointOnLine2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    public static boolean areLine3DsCollinear(FramePoint3DReadOnly pointOnLine1, FrameVector3DReadOnly lineDirection1, FramePoint3DReadOnly pointOnLine2, FrameVector3DReadOnly lineDirection2, double angleEpsilon, double distanceEpsilon) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        return EuclidGeometryTools.areLine3DsCollinear((Point3DReadOnly)pointOnLine1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)pointOnLine2, (Vector3DReadOnly)lineDirection2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    public static boolean arePlane3DsCoincident(FramePoint3DReadOnly pointOnPlane1, FrameVector3DReadOnly planeNormal1, FramePoint3DReadOnly pointOnPlane2, FrameVector3DReadOnly planeNormal2, double angleEpsilon, double distanceEpsilon) {
        pointOnPlane1.checkReferenceFrameMatch(planeNormal1, pointOnPlane2, planeNormal2);
        return EuclidGeometryTools.arePlane3DsCoincident((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)angleEpsilon, (double)distanceEpsilon);
    }

    public static boolean areVector2DsParallel(FrameVector2DReadOnly firstVector, FrameVector2DReadOnly secondVector, double angleEpsilon) {
        firstVector.checkReferenceFrameMatch(secondVector);
        return EuclidGeometryTools.areVector2DsParallel((Vector2DReadOnly)firstVector, (Vector2DReadOnly)secondVector, (double)angleEpsilon);
    }

    public static boolean areVector3DsParallel(FrameVector3DReadOnly firstVector, FrameVector3DReadOnly secondVector, double angleEpsilon) {
        firstVector.checkReferenceFrameMatch(secondVector);
        return EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (double)angleEpsilon);
    }

    public static FramePoint2D averagePoint2Ds(Collection<? extends FramePoint2DReadOnly> points) {
        if (points.isEmpty()) {
            return null;
        }
        FramePoint2D totalPoint = new FramePoint2D(points.iterator().next().getReferenceFrame());
        for (FramePoint2DReadOnly framePoint2DReadOnly : points) {
            totalPoint.add(framePoint2DReadOnly);
        }
        totalPoint.scale(1.0 / (double)points.size());
        return totalPoint;
    }

    public static FramePoint3D averagePoint3Ds(Collection<? extends FramePoint3DReadOnly> points) {
        if (points.isEmpty()) {
            return null;
        }
        FramePoint3D totalPoint = new FramePoint3D(points.iterator().next().getReferenceFrame());
        for (FramePoint3DReadOnly framePoint3DReadOnly : points) {
            totalPoint.add(framePoint3DReadOnly);
        }
        totalPoint.scale(1.0 / (double)points.size());
        return totalPoint;
    }

    public static FramePoint3D averagePoint3Ds(FramePoint3DReadOnly a, FramePoint3DReadOnly b) {
        FramePoint3D average = new FramePoint3D(a);
        average.add(b);
        average.scale(0.5);
        return average;
    }

    public static void orientation3DFromFirstToSecondVector3D(FrameVector3DReadOnly firstVector, FrameVector3DReadOnly secondVector, Orientation3DBasics rotationToPack) {
        firstVector.checkReferenceFrameMatch(secondVector);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)rotationToPack);
    }

    public static void orientation3DFromFirstToSecondVector3D(FrameVector3DReadOnly firstVector, FrameVector3DReadOnly secondVector, FixedFrameOrientation3DBasics rotationToPack) {
        firstVector.checkReferenceFrameMatch(secondVector, rotationToPack);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)rotationToPack);
    }

    public static void orientation3DFromFirstToSecondVector3D(FrameVector3DReadOnly firstVector, FrameVector3DReadOnly secondVector, FrameOrientation3DBasics rotationToPack) {
        firstVector.checkReferenceFrameMatch(secondVector);
        rotationToPack.setReferenceFrame(firstVector.getReferenceFrame());
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)rotationToPack);
    }

    public static AxisAngle axisAngleFromFirstToSecondVector3D(FrameVector3DReadOnly firstVector, FrameVector3DReadOnly secondVector) {
        firstVector.checkReferenceFrameMatch(secondVector);
        return EuclidGeometryTools.axisAngleFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector);
    }

    public static void orientation3DFromZUpToVector3D(FrameVector3DReadOnly vector, FixedFrameOrientation3DBasics rotationToPack) {
        rotationToPack.checkReferenceFrameMatch(vector.getReferenceFrame());
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)vector, (Orientation3DBasics)rotationToPack);
    }

    public static void orientation3DFromZUpToVector3D(FrameVector3DReadOnly vector, FrameOrientation3DBasics rotationToPack) {
        rotationToPack.setReferenceFrame(vector.getReferenceFrame());
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)vector, (Orientation3DBasics)rotationToPack);
    }

    public static double closestPoint3DsBetweenTwoLine3Ds(FramePoint3DReadOnly pointOnLine1, FrameVector3DReadOnly lineDirection1, FramePoint3DReadOnly pointOnLine2, FrameVector3DReadOnly lineDirection2, FixedFramePoint3DBasics closestPointOnLine1ToPack, FixedFramePoint3DBasics closestPointOnLine2ToPack) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        if (closestPointOnLine1ToPack != null) {
            closestPointOnLine1ToPack.checkReferenceFrameMatch(pointOnLine1);
        }
        if (closestPointOnLine2ToPack != null) {
            closestPointOnLine2ToPack.checkReferenceFrameMatch(pointOnLine1);
        }
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)pointOnLine1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)pointOnLine2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)closestPointOnLine1ToPack, (Point3DBasics)closestPointOnLine2ToPack);
    }

    public static double closestPoint3DsBetweenTwoLine3Ds(FramePoint3DReadOnly pointOnLine1, FrameVector3DReadOnly lineDirection1, FramePoint3DReadOnly pointOnLine2, FrameVector3DReadOnly lineDirection2, FramePoint3DBasics closestPointOnLine1ToPack, FramePoint3DBasics closestPointOnLine2ToPack) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        if (closestPointOnLine1ToPack != null) {
            closestPointOnLine1ToPack.setReferenceFrame(pointOnLine1.getReferenceFrame());
        }
        if (closestPointOnLine2ToPack != null) {
            closestPointOnLine2ToPack.setReferenceFrame(pointOnLine1.getReferenceFrame());
        }
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)pointOnLine1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)pointOnLine2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)closestPointOnLine1ToPack, (Point3DBasics)closestPointOnLine2ToPack);
    }

    public static double closestPoint2DsBetweenTwoLineSegment2Ds(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2, FixedFramePoint2DBasics closestPointOnLineSegment1ToPack, FixedFramePoint2DBasics closestPointOnLineSegment2ToPack) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        if (closestPointOnLineSegment1ToPack != null) {
            closestPointOnLineSegment1ToPack.checkReferenceFrameMatch(lineSegmentStart1);
        }
        if (closestPointOnLineSegment2ToPack != null) {
            closestPointOnLineSegment2ToPack.checkReferenceFrameMatch(lineSegmentStart1);
        }
        return EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)closestPointOnLineSegment1ToPack, (Point2DBasics)closestPointOnLineSegment2ToPack);
    }

    public static double closestPoint2DsBetweenTwoLineSegment2Ds(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2, FramePoint2DBasics closestPointOnLineSegment1ToPack, FramePoint2DBasics closestPointOnLineSegment2ToPack) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        if (closestPointOnLineSegment1ToPack != null) {
            closestPointOnLineSegment1ToPack.setReferenceFrame(lineSegmentStart1.getReferenceFrame());
        }
        if (closestPointOnLineSegment2ToPack != null) {
            closestPointOnLineSegment2ToPack.setReferenceFrame(lineSegmentStart1.getReferenceFrame());
        }
        return EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)closestPointOnLineSegment1ToPack, (Point2DBasics)closestPointOnLineSegment2ToPack);
    }

    public static double closestPoint3DsBetweenTwoLineSegment3Ds(FramePoint3DReadOnly lineSegmentStart1, FramePoint3DReadOnly lineSegmentEnd1, FramePoint3DReadOnly lineSegmentStart2, FramePoint3DReadOnly lineSegmentEnd2, FixedFramePoint3DBasics closestPointOnLineSegment1ToPack, FixedFramePoint3DBasics closestPointOnLineSegment2ToPack) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        if (closestPointOnLineSegment1ToPack != null) {
            closestPointOnLineSegment1ToPack.checkReferenceFrameMatch(lineSegmentStart1);
        }
        if (closestPointOnLineSegment2ToPack != null) {
            closestPointOnLineSegment2ToPack.checkReferenceFrameMatch(lineSegmentStart1);
        }
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)closestPointOnLineSegment1ToPack, (Point3DBasics)closestPointOnLineSegment2ToPack);
    }

    public static double closestPoint3DsBetweenTwoLineSegment3Ds(FramePoint3DReadOnly lineSegmentStart1, FramePoint3DReadOnly lineSegmentEnd1, FramePoint3DReadOnly lineSegmentStart2, FramePoint3DReadOnly lineSegmentEnd2, FramePoint3DBasics closestPointOnLineSegment1ToPack, FramePoint3DBasics closestPointOnLineSegment2ToPack) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        if (closestPointOnLineSegment1ToPack != null) {
            closestPointOnLineSegment1ToPack.setReferenceFrame(lineSegmentStart1.getReferenceFrame());
        }
        if (closestPointOnLineSegment2ToPack != null) {
            closestPointOnLineSegment2ToPack.setReferenceFrame(lineSegmentStart1.getReferenceFrame());
        }
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, (Point3DBasics)closestPointOnLineSegment1ToPack, (Point3DBasics)closestPointOnLineSegment2ToPack);
    }

    public static double triangleArea(FramePoint2DReadOnly a, FramePoint2DReadOnly b, FramePoint2DReadOnly c) {
        a.checkReferenceFrameMatch(b, c);
        return EuclidGeometryTools.triangleArea((Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
    }

    public static double triangleArea(FramePoint3DReadOnly a, FramePoint3DReadOnly b, FramePoint3DReadOnly c) {
        a.checkReferenceFrameMatch(b, c);
        return EuclidGeometryTools.triangleArea((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c);
    }

    public static boolean triangleCircumcenter(FramePoint2DReadOnly A, FramePoint2DReadOnly B, FramePoint2DReadOnly C, FixedFramePoint2DBasics circumcenterToPack) {
        circumcenterToPack.checkReferenceFrameMatch(A, B, C);
        return EuclidGeometryTools.triangleCircumcenter((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DBasics)circumcenterToPack);
    }

    public static boolean triangleCircumcenter(FramePoint2DReadOnly A, FramePoint2DReadOnly B, FramePoint2DReadOnly C, FramePoint2DBasics circumcenterToPack) {
        A.checkReferenceFrameMatch(B, C);
        circumcenterToPack.setReferenceFrame(A.getReferenceFrame());
        return EuclidGeometryTools.triangleCircumcenter((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DBasics)circumcenterToPack);
    }

    public static boolean triangleCircumcenter(FramePoint3DReadOnly A, FramePoint3DReadOnly B, FramePoint3DReadOnly C, FixedFramePoint3DBasics circumcenterToPack) {
        circumcenterToPack.checkReferenceFrameMatch(A, B, C);
        return EuclidGeometryTools.triangleCircumcenter((Point3DReadOnly)A, (Point3DReadOnly)B, (Point3DReadOnly)C, (Point3DBasics)circumcenterToPack);
    }

    public static boolean triangleCircumcenter(FramePoint3DReadOnly A, FramePoint3DReadOnly B, FramePoint3DReadOnly C, FramePoint3DBasics circumcenterToPack) {
        A.checkReferenceFrameMatch(B, C);
        circumcenterToPack.setReferenceFrame(A.getReferenceFrame());
        return EuclidGeometryTools.triangleCircumcenter((Point3DReadOnly)A, (Point3DReadOnly)B, (Point3DReadOnly)C, (Point3DBasics)circumcenterToPack);
    }

    public static double distanceBetweenTwoLine3Ds(FramePoint3DReadOnly pointOnLine1, FrameVector3DReadOnly lineDirection1, FramePoint3DReadOnly pointOnLine2, FrameVector3DReadOnly lineDirection2) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)pointOnLine1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)pointOnLine2, (Vector3DReadOnly)lineDirection2, null, null);
    }

    public static double distanceBetweenTwoLineSegment2Ds(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        return EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, null, null);
    }

    public static double distanceBetweenTwoLineSegment3Ds(FramePoint3DReadOnly lineSegmentStart1, FramePoint3DReadOnly lineSegmentEnd1, FramePoint3DReadOnly lineSegmentStart2, FramePoint3DReadOnly lineSegmentEnd2) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegmentStart1, (Point3DReadOnly)lineSegmentEnd1, (Point3DReadOnly)lineSegmentStart2, (Point3DReadOnly)lineSegmentEnd2, null, null);
    }

    public static double distanceFromPoint2DToLine2D(double pointX, double pointY, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        firstPointOnLine.checkReferenceFrameMatch(secondPointOnLine);
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((double)pointX, (double)pointY, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
    }

    public static double distanceFromPoint2DToLine2D(double pointX, double pointY, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((double)pointX, (double)pointY, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static double distanceFromPoint2DToLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)point, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
    }

    public static double distanceFromPoint2DToLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)point, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static double distanceFromPoint2DToLineSegment2D(double pointX, double pointY, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((double)pointX, (double)pointY, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double distanceFromPoint2DToLineSegment2D(FramePoint2DReadOnly point, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)point, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double distanceFromPoint2DToRay2D(double pointX, double pointY, FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection) {
        rayOrigin.checkReferenceFrameMatch(rayDirection);
        return EuclidGeometryTools.distanceFromPoint2DToRay2D((double)pointX, (double)pointY, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
    }

    public static double distanceFromPoint2DToRay2D(FramePoint2DReadOnly point, FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection) {
        point.checkReferenceFrameMatch(rayOrigin, rayDirection);
        return EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)point, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
    }

    public static double distanceFromPoint3DToLine3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        return EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine);
    }

    public static double distanceFromPoint3DToLine3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
    }

    public static double distanceFromPoint3DToLineSegment3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static double distanceFromPoint3DToLineSegment3D(FramePoint3DReadOnly point, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static double distanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal);
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static double distanceFromPoint3DToPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        point.checkReferenceFrameMatch(pointOnPlane, planeNormal);
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal);
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static double signedDistanceFromPoint3DToPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        point.checkReferenceFrameMatch(pointOnPlane, planeNormal);
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        pointOnPlane.checkReferenceFrameMatch(planeFirstTangent, planeSecondTangent);
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent);
    }

    public static double signedDistanceFromPoint3DToPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        point.checkReferenceFrameMatch(pointOnPlane, planeFirstTangent, planeSecondTangent);
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent);
    }

    public static double distanceSquaredFromPoint2DToLineSegment2D(double pointX, double pointY, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)pointX, (double)pointY, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double distanceSquaredFromPoint2DToLineSegment2D(FramePoint2DReadOnly point, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)point, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double distanceSquaredFromPoint3DToLineSegment3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static double distanceSquaredFromPoint3DToLineSegment3D(FramePoint3DReadOnly point, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static boolean doesLineSegment3DIntersectPlane3D(FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal, lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static boolean doLine2DAndLineSegment2DIntersect(double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((double)pointOnLineX, (double)pointOnLineY, (double)lineDirectionX, (double)lineDirectionY, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static boolean doLine2DAndLineSegment2DIntersect(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        pointOnLine.checkReferenceFrameMatch(lineDirection, lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.doLine2DAndLineSegment2DIntersect((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static boolean doLineSegment2DsIntersect(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        return EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
    }

    public static boolean doRay2DAndLineSegment2DIntersect(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        rayOrigin.checkReferenceFrameMatch(rayDirection, lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double dotProduct(FramePoint2DReadOnly start1, FramePoint2DReadOnly end1, FramePoint2DReadOnly start2, FramePoint2DReadOnly end2) {
        start1.checkReferenceFrameMatch(end1, start2, end2);
        return EuclidGeometryTools.dotProduct((Point2DReadOnly)start1, (Point2DReadOnly)end1, (Point2DReadOnly)start2, (Point2DReadOnly)end2);
    }

    public static double dotProduct(FramePoint3DReadOnly start1, FramePoint3DReadOnly end1, FramePoint3DReadOnly start2, FramePoint3DReadOnly end2) {
        start1.checkReferenceFrameMatch(end1, start2, end2);
        return EuclidGeometryTools.dotProduct((Point3DReadOnly)start1, (Point3DReadOnly)end1, (Point3DReadOnly)start2, (Point3DReadOnly)end2);
    }

    public static int intersectionBetweenLine2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, firstPointOnLine, secondPointOnLine);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, firstPointOnLine, secondPointOnLine);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, pointOnLine, lineDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static FramePoint2D intersectionBetweenLine2DAndLineSegment2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        pointOnLine.checkReferenceFrameMatch(lineDirection, lineSegmentStart, lineSegmentEnd);
        Point2D intersection = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(pointOnLine.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    public static boolean intersectionBetweenLine2DAndLineSegment2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics intersectionToPack) {
        pointOnLine.checkReferenceFrameMatch(lineDirection, lineSegmentStart, lineSegmentEnd);
        if (intersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(intersectionToPack);
        }
        boolean success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)intersectionToPack);
        return success;
    }

    public static boolean intersectionBetweenLine2DAndLineSegment2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics intersectionToPack) {
        pointOnLine.checkReferenceFrameMatch(lineDirection, lineSegmentStart, lineSegmentEnd);
        boolean success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)intersectionToPack);
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return success;
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, firstPointOnLine, secondPointOnLine);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, firstPointOnLine, secondPointOnLine);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, pointOnLine, lineDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(double boundingBoxMinX, double boundingBoxMinY, double boundingBoxMinZ, double boundingBoxMaxX, double boundingBoxMaxY, double boundingBoxMaxZ, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        if (firstIntersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((double)boundingBoxMinX, (double)boundingBoxMinY, (double)boundingBoxMinZ, (double)boundingBoxMaxX, (double)boundingBoxMaxY, (double)boundingBoxMaxZ, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(double boundingBoxMinX, double boundingBoxMinY, double boundingBoxMinZ, double boundingBoxMaxX, double boundingBoxMaxY, double boundingBoxMaxZ, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((double)boundingBoxMinX, (double)boundingBoxMinY, (double)boundingBoxMinZ, (double)boundingBoxMaxX, (double)boundingBoxMaxY, (double)boundingBoxMaxZ, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, firstPointOnLine, secondPointOnLine);
        if (firstIntersectionToPack != null) {
            firstPointOnLine.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            firstPointOnLine.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, firstPointOnLine, secondPointOnLine);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, pointOnLine, lineDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        firstPointOnLine.checkReferenceFrameMatch(secondPointOnLine);
        if (firstIntersectionToPack != null) {
            firstPointOnLine.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            firstPointOnLine.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        firstPointOnLine.checkReferenceFrameMatch(secondPointOnLine);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(firstPointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        if (firstIntersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            pointOnLine.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static FramePoint3D intersectionBetweenLine3DAndPlane3D(FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal, pointOnLine, lineDirection);
        FramePoint3D intersection = new FramePoint3D(pointOnLine.getReferenceFrame());
        boolean success = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersection);
        if (success) {
            return intersection;
        }
        return null;
    }

    public static boolean intersectionBetweenLine3DAndPlane3D(FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics intersectionToPack) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal, pointOnLine, lineDirection);
        if (intersectionToPack != null) {
            pointOnPlane.checkReferenceFrameMatch(intersectionToPack);
        }
        return EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersectionToPack);
    }

    public static boolean intersectionBetweenLine3DAndPlane3D(FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics intersectionToPack) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal, pointOnLine, lineDirection);
        boolean success = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersectionToPack);
        if (success && intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(pointOnLine.getReferenceFrame());
        }
        return success;
    }

    public static int intersectionBetweenLineSegment2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, lineSegmentStart, lineSegmentEnd);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, lineSegmentStart, lineSegmentEnd);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            lineSegmentStart.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            lineSegmentStart.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, lineSegmentStart, lineSegmentEnd);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            lineSegmentStart.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            lineSegmentStart.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenLineSegment3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLineSegment3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static FramePoint3D intersectionBetweenLineSegment3DAndPlane3D(FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal, lineSegmentStart, lineSegmentEnd);
        Point3D intersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
        if (intersection != null) {
            return new FramePoint3D(pointOnPlane.getReferenceFrame(), (Tuple3DReadOnly)intersection);
        }
        return null;
    }

    public static int intersectionBetweenRay2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay2DAndBoundingBox2D(FramePoint2DReadOnly boundingBoxMin, FramePoint2DReadOnly boundingBoxMax, FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, rayOrigin, rayDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBoxMin, (Point2DReadOnly)boundingBoxMax, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static FramePoint2D intersectionBetweenRay2DAndLineSegment2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        rayOrigin.checkReferenceFrameMatch(rayDirection, lineSegmentStart, lineSegmentEnd);
        Point2D intersection = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(rayOrigin.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    public static boolean intersectionBetweenRay2DAndLineSegment2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics intersectionToPack) {
        rayOrigin.checkReferenceFrameMatch(rayDirection, lineSegmentStart, lineSegmentEnd);
        if (intersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(intersectionToPack);
        }
        boolean success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)intersectionToPack);
        return success;
    }

    public static boolean intersectionBetweenRay2DAndLineSegment2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics intersectionToPack) {
        rayOrigin.checkReferenceFrameMatch(rayDirection, lineSegmentStart, lineSegmentEnd);
        boolean success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)intersectionToPack);
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        return success;
    }

    public static int intersectionBetweenRay3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            boundingBoxMin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndBox3D(FramePoint3DReadOnly boxPosition, FrameOrientation3DReadOnly boxOrientation, FrameVector3DReadOnly boxSize, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        boxPosition.checkReferenceFrameMatch(boxSize, rayOrigin, rayDirection, boxOrientation);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndBox3D(FramePoint3DReadOnly boxPosition, FrameOrientation3DReadOnly boxOrientation, FrameVector3DReadOnly boxSize, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        boxPosition.checkReferenceFrameMatch(boxSize, rayOrigin, rayDirection, boxOrientation);
        if (firstIntersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBox3D((Point3DReadOnly)boxPosition, (Orientation3DReadOnly)boxOrientation, (Vector3DReadOnly)boxSize, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndBoundingBox3D(FramePoint3DReadOnly boundingBoxMin, FramePoint3DReadOnly boundingBoxMax, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        boundingBoxMin.checkReferenceFrameMatch(boundingBoxMax, rayOrigin, rayDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBoxMin, (Point3DReadOnly)boundingBoxMax, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndCylinder3D(double cylinderLength, double cylinderRadius, FramePoint3DReadOnly cylinderPosition, FrameVector3DReadOnly cylinderAxis, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        cylinderPosition.checkReferenceFrameMatch(cylinderAxis, rayOrigin, rayDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)cylinderLength, (double)cylinderRadius, (Point3DReadOnly)cylinderPosition, (Vector3DReadOnly)cylinderAxis, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        rayOrigin.checkReferenceFrameMatch(rayDirection);
        if (firstIntersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            rayOrigin.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        return numberOfIntersections;
    }

    public static int intersectionBetweenRay3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        rayOrigin.checkReferenceFrameMatch(rayDirection);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)radiusX, (double)radiusY, (double)radiusZ, (Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(rayOrigin.getReferenceFrame());
        }
        return numberOfIntersections;
    }

    public static FramePoint2D intersectionBetweenTwoLine2Ds(FramePoint2DReadOnly firstPointOnLine1, FramePoint2DReadOnly secondPointOnLine1, FramePoint2DReadOnly firstPointOnLine2, FramePoint2DReadOnly secondPointOnLine2) {
        firstPointOnLine1.checkReferenceFrameMatch(secondPointOnLine1, firstPointOnLine2, secondPointOnLine2);
        Point2D intersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(firstPointOnLine1.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    public static boolean intersectionBetweenTwoLine2Ds(FramePoint2DReadOnly firstPointOnLine1, FramePoint2DReadOnly secondPointOnLine1, FramePoint2DReadOnly firstPointOnLine2, FramePoint2DReadOnly secondPointOnLine2, FixedFramePoint2DBasics intersectionToPack) {
        firstPointOnLine1.checkReferenceFrameMatch(secondPointOnLine1, firstPointOnLine2, secondPointOnLine2);
        if (intersectionToPack != null) {
            firstPointOnLine1.checkReferenceFrameMatch(intersectionToPack);
        }
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (Point2DBasics)intersectionToPack);
    }

    public static boolean intersectionBetweenTwoLine2Ds(FramePoint2DReadOnly firstPointOnLine1, FramePoint2DReadOnly secondPointOnLine1, FramePoint2DReadOnly firstPointOnLine2, FramePoint2DReadOnly secondPointOnLine2, FramePoint2DBasics intersectionToPack) {
        firstPointOnLine1.checkReferenceFrameMatch(secondPointOnLine1, firstPointOnLine2, secondPointOnLine2);
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(firstPointOnLine1.getReferenceFrame());
        }
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)firstPointOnLine1, (Point2DReadOnly)secondPointOnLine1, (Point2DReadOnly)firstPointOnLine2, (Point2DReadOnly)secondPointOnLine2, (Point2DBasics)intersectionToPack);
    }

    public static FramePoint2D intersectionBetweenTwoLine2Ds(FramePoint2DReadOnly pointOnLine1, FrameVector2DReadOnly lineDirection1, FramePoint2DReadOnly pointOnLine2, FrameVector2DReadOnly lineDirection2) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        Point2D intersection = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2);
        if (intersection != null) {
            return new FramePoint2D(pointOnLine1.getReferenceFrame(), (Tuple2DReadOnly)intersection);
        }
        return null;
    }

    public static boolean intersectionBetweenTwoLine2Ds(FramePoint2DReadOnly pointOnLine1, FrameVector2DReadOnly lineDirection1, FramePoint2DReadOnly pointOnLine2, FrameVector2DReadOnly lineDirection2, FixedFramePoint2DBasics intersectionToPack) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        if (intersectionToPack != null) {
            pointOnLine1.checkReferenceFrameMatch(intersectionToPack);
        }
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DBasics)intersectionToPack);
        return success;
    }

    public static boolean intersectionBetweenTwoLine2Ds(FramePoint2DReadOnly pointOnLine1, FrameVector2DReadOnly lineDirection1, FramePoint2DReadOnly pointOnLine2, FrameVector2DReadOnly lineDirection2, FramePoint2DBasics intersectionToPack) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2, (Point2DBasics)intersectionToPack);
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(pointOnLine1.getReferenceFrame());
        }
        return success;
    }

    public static FramePoint2D intersectionBetweenTwoLineSegment2Ds(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        Point2D intersection = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
        if (intersection != null) {
            return new FramePoint2D(lineSegmentEnd1.getReferenceFrame(), (Tuple2DReadOnly)intersection);
        }
        return null;
    }

    public static boolean intersectionBetweenTwoLineSegment2Ds(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2, FixedFramePoint2DBasics intersectionToPack) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        if (intersectionToPack != null) {
            lineSegmentStart1.checkReferenceFrameMatch(intersectionToPack);
        }
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)intersectionToPack);
        return success;
    }

    public static boolean intersectionBetweenTwoLineSegment2Ds(FramePoint2DReadOnly lineSegmentStart1, FramePoint2DReadOnly lineSegmentEnd1, FramePoint2DReadOnly lineSegmentStart2, FramePoint2DReadOnly lineSegmentEnd2, FramePoint2DBasics intersectionToPack) {
        lineSegmentStart1.checkReferenceFrameMatch(lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (Point2DBasics)intersectionToPack);
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(lineSegmentStart1.getReferenceFrame());
        }
        return success;
    }

    public static boolean intersectionBetweenTwoPlane3Ds(FramePoint3DReadOnly pointOnPlane1, FrameVector3DReadOnly planeNormal1, FramePoint3DReadOnly pointOnPlane2, FrameVector3DReadOnly planeNormal2, double angleThreshold, FixedFramePoint3DBasics pointOnIntersectionToPack, FixedFrameVector3DBasics intersectionDirectionToPack) {
        pointOnPlane1.checkReferenceFrameMatch(planeNormal1, pointOnPlane2, planeNormal2);
        if (pointOnIntersectionToPack != null) {
            pointOnPlane1.checkReferenceFrameMatch(pointOnIntersectionToPack);
        }
        if (intersectionDirectionToPack != null) {
            pointOnPlane1.checkReferenceFrameMatch(intersectionDirectionToPack);
        }
        boolean success = EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)angleThreshold, (Point3DBasics)pointOnIntersectionToPack, (Vector3DBasics)intersectionDirectionToPack);
        return success;
    }

    public static boolean intersectionBetweenTwoPlane3Ds(FramePoint3DReadOnly pointOnPlane1, FrameVector3DReadOnly planeNormal1, FramePoint3DReadOnly pointOnPlane2, FrameVector3DReadOnly planeNormal2, double angleThreshold, FramePoint3DBasics pointOnIntersectionToPack, FrameVector3DBasics intersectionDirectionToPack) {
        pointOnPlane1.checkReferenceFrameMatch(planeNormal1, pointOnPlane2, planeNormal2);
        boolean success = EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)angleThreshold, (Point3DBasics)pointOnIntersectionToPack, (Vector3DBasics)intersectionDirectionToPack);
        if (pointOnIntersectionToPack != null) {
            pointOnIntersectionToPack.setReferenceFrame(planeNormal1.getReferenceFrame());
        }
        if (intersectionDirectionToPack != null) {
            intersectionDirectionToPack.setReferenceFrame(planeNormal1.getReferenceFrame());
        }
        return success;
    }

    public static boolean intersectionBetweenTwoPlane3Ds(FramePoint3DReadOnly pointOnPlane1, FrameVector3DReadOnly planeNormal1, FramePoint3DReadOnly pointOnPlane2, FrameVector3DReadOnly planeNormal2, FixedFramePoint3DBasics pointOnIntersectionToPack, FixedFrameVector3DBasics intersectionDirectionToPack) {
        pointOnPlane1.checkReferenceFrameMatch(planeNormal1, pointOnPlane2, planeNormal2);
        if (pointOnIntersectionToPack != null) {
            pointOnPlane1.checkReferenceFrameMatch(pointOnIntersectionToPack);
        }
        if (intersectionDirectionToPack != null) {
            pointOnPlane1.checkReferenceFrameMatch(intersectionDirectionToPack);
        }
        return EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (Point3DBasics)pointOnIntersectionToPack, (Vector3DBasics)intersectionDirectionToPack);
    }

    public static boolean intersectionBetweenTwoPlane3Ds(FramePoint3DReadOnly pointOnPlane1, FrameVector3DReadOnly planeNormal1, FramePoint3DReadOnly pointOnPlane2, FrameVector3DReadOnly planeNormal2, FramePoint3DBasics pointOnIntersectionToPack, FrameVector3DBasics intersectionDirectionToPack) {
        pointOnPlane1.checkReferenceFrameMatch(planeNormal1, pointOnPlane2, planeNormal2);
        boolean success = EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (Point3DBasics)pointOnIntersectionToPack, (Vector3DBasics)intersectionDirectionToPack);
        if (success) {
            if (pointOnIntersectionToPack != null) {
                pointOnIntersectionToPack.setReferenceFrame(planeNormal1.getReferenceFrame());
            }
            if (intersectionDirectionToPack != null) {
                intersectionDirectionToPack.setReferenceFrame(planeNormal1.getReferenceFrame());
            }
        }
        return success;
    }

    public static Location whichPartOfRay2DIsPoint2DOn(FramePoint2DReadOnly point, FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection) {
        point.checkReferenceFrameMatch(rayOrigin, rayDirection);
        return EuclidGeometryTools.whichPartOfRay2DIsPoint2DOn((Point2DReadOnly)point, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
    }

    public static boolean isPoint2DInFrontOfRay2D(FramePoint2DReadOnly point, FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection) {
        return EuclidFrameTools.whichPartOfRay2DIsPoint2DOn(point, rayOrigin, rayDirection) != Location.BEHIND;
    }

    public static boolean isPoint2DInsideTriangleABC(FramePoint2DReadOnly point, FramePoint2DReadOnly a, FramePoint2DReadOnly b, FramePoint2DReadOnly c) {
        point.checkReferenceFrameMatch(a, b, c);
        return EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)point, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
    }

    public static boolean isPoint2DOnLine2D(double pointX, double pointY, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.isPoint2DOnLine2D((double)pointX, (double)pointY, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static boolean isPoint2DOnLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.isPoint2DOnLine2D((Point2DReadOnly)point, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static boolean isPoint2DOnLineSegment2D(FramePoint2DReadOnly point, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)point, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(double pointX, double pointY, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        firstPointOnLine.checkReferenceFrameMatch(secondPointOnLine);
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn((double)pointX, (double)pointY, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(double pointX, double pointY, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn((double)pointX, (double)pointY, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(FramePoint2DReadOnly point, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn((Point2DReadOnly)point, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(FramePoint2DReadOnly point, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn((Point2DReadOnly)point, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static boolean isPoint2DOnLeftSideOfLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        return EuclidFrameTools.whichSideOfLine2DIsPoint2DOn(point, firstPointOnLine, secondPointOnLine) == Location.LEFT;
    }

    public static boolean isPoint2DOnRightSideOfLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        return EuclidFrameTools.whichSideOfLine2DIsPoint2DOn(point, firstPointOnLine, secondPointOnLine) == Location.RIGHT;
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(double pointX, double pointY, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine, boolean testLeftSide) {
        firstPointOnLine.checkReferenceFrameMatch(secondPointOnLine);
        return EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)pointX, (double)pointY, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (boolean)testLeftSide);
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(double pointX, double pointY, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, boolean testLeftSide) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)pointX, (double)pointY, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)testLeftSide);
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine, boolean testLeftSide) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        return EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)point, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (boolean)testLeftSide);
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, boolean testLeftSide) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.isPoint2DOnSideOfLine2D((Point2DReadOnly)point, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (boolean)testLeftSide);
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal);
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        point.checkReferenceFrameMatch(pointOnPlane, planeNormal);
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        pointOnPlane.checkReferenceFrameMatch(planeFirstTangent, planeSecondTangent);
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent);
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        point.checkReferenceFrameMatch(pointOnPlane, planeFirstTangent, planeSecondTangent);
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeFirstTangent, (Vector3DReadOnly)planeSecondTangent);
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, boolean testForAbove) {
        Location side = EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeNormal);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, boolean testForAbove) {
        Location side = EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeNormal);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    public static boolean isPoint3DAbovePlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeNormal) == Location.ABOVE;
    }

    public static boolean isPoint3DAbovePlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeNormal) == Location.ABOVE;
    }

    public static boolean isPoint3DBelowPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeNormal) == Location.BELOW;
    }

    public static boolean isPoint3DBelowPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeNormal) == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent, boolean testForAbove) {
        Location side = EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeFirstTangent, planeSecondTangent);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    public static boolean isPoint3DAboveOrBelowPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent, boolean testForAbove) {
        Location side = EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeFirstTangent, planeSecondTangent);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    public static boolean isPoint3DAbovePlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.ABOVE;
    }

    public static boolean isPoint3DAbovePlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.ABOVE;
    }

    public static boolean isPoint3DBelowPlane3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.BELOW;
    }

    public static boolean isPoint3DBelowPlane3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeFirstTangent, FrameVector3DReadOnly planeSecondTangent) {
        return EuclidFrameTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.BELOW;
    }

    public static FrameVector3D normal3DFromThreePoint3Ds(FramePoint3DReadOnly firstPointOnPlane, FramePoint3DReadOnly secondPointOnPlane, FramePoint3DReadOnly thirdPointOnPlane) {
        firstPointOnPlane.checkReferenceFrameMatch(secondPointOnPlane, thirdPointOnPlane);
        Vector3D normal = EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)thirdPointOnPlane);
        if (normal == null) {
            return null;
        }
        return new FrameVector3D(firstPointOnPlane.getReferenceFrame(), (Tuple3DReadOnly)normal);
    }

    public static boolean normal3DFromThreePoint3Ds(FramePoint3DReadOnly firstPointOnPlane, FramePoint3DReadOnly secondPointOnPlane, FramePoint3DReadOnly thirdPointOnPlane, FixedFrameVector3DBasics normalToPack) {
        firstPointOnPlane.checkReferenceFrameMatch(secondPointOnPlane, thirdPointOnPlane, normalToPack);
        return EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)thirdPointOnPlane, (Vector3DBasics)normalToPack);
    }

    public static boolean normal3DFromThreePoint3Ds(FramePoint3DReadOnly firstPointOnPlane, FramePoint3DReadOnly secondPointOnPlane, FramePoint3DReadOnly thirdPointOnPlane, FrameVector3DBasics normalToPack) {
        firstPointOnPlane.checkReferenceFrameMatch(secondPointOnPlane, thirdPointOnPlane);
        normalToPack.setReferenceFrame(firstPointOnPlane.getReferenceFrame());
        return EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)thirdPointOnPlane, (Vector3DBasics)normalToPack);
    }

    public static FramePoint2D orthogonalProjectionOnLine2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        pointToProject.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        Point2D projection = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        if (projection == null) {
            return null;
        }
        return new FramePoint2D(pointToProject.getReferenceFrame(), (Tuple2DReadOnly)projection);
    }

    public static boolean orthogonalProjectionOnLine2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine, FixedFramePoint2DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLine2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine, FramePoint2DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        projectionToPack.setReferenceFrame(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, (Point2DBasics)projectionToPack);
    }

    public static FramePoint2D orthogonalProjectionOnLine2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        pointToProject.checkReferenceFrameMatch(pointOnLine, lineDirection);
        Point2D projection = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
        if (projection == null) {
            return null;
        }
        return new FramePoint2D(pointToProject.getReferenceFrame(), (Tuple2DReadOnly)projection);
    }

    public static boolean orthogonalProjectionOnLine2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FixedFramePoint2DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(pointOnLine, lineDirection, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLine2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(pointOnLine, lineDirection);
        projectionToPack.setReferenceFrame(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)projectionToPack);
    }

    public static FramePoint3D orthogonalProjectionOnLine3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        pointToProject.checkReferenceFrameMatch(pointOnLine, lineDirection);
        Point3D projection = EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
        if (projection == null) {
            return null;
        }
        return new FramePoint3D(pointToProject.getReferenceFrame(), (Tuple3DReadOnly)projection);
    }

    public static boolean orthogonalProjectionOnLine3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(pointOnLine, lineDirection, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLine3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(pointOnLine, lineDirection);
        projectionToPack.setReferenceFrame(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)projectionToPack);
    }

    public static FramePoint2D orthogonalProjectionOnLineSegment2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        pointToProject.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        Point2D projection = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
        if (projection == null) {
            return null;
        }
        return new FramePoint2D(pointToProject.getReferenceFrame(), (Tuple2DReadOnly)projection);
    }

    public static boolean orthogonalProjectionOnLineSegment2D(double pointToProjectX, double pointToProjectY, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics projectionToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((double)pointToProjectX, (double)pointToProjectY, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment2D(double pointToProjectX, double pointToProjectY, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics projectionToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        projectionToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((double)pointToProjectX, (double)pointToProjectY, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment2D(FramePoint2DReadOnly pointToProject, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        projectionToPack.setReferenceFrame(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)pointToProject, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)projectionToPack);
    }

    public static FramePoint3D orthogonalProjectionOnLineSegment3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        pointToProject.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        Point3D projection = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
        if (projection == null) {
            return null;
        }
        return new FramePoint3D(pointToProject.getReferenceFrame(), (Tuple3DReadOnly)projection);
    }

    public static boolean orthogonalProjectionOnLineSegment3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FixedFramePoint3DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FramePoint3DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        projectionToPack.setReferenceFrame(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)projectionToPack);
    }

    public static FramePoint3D orthogonalProjectionOnPlane3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        pointToProject.checkReferenceFrameMatch(pointOnPlane, planeNormal);
        Point3D projection = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
        if (projection == null) {
            return null;
        }
        return new FramePoint3D(pointOnPlane.getReferenceFrame(), (Tuple3DReadOnly)projection);
    }

    public static boolean orthogonalProjectionOnPlane3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FixedFramePoint3DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(pointOnPlane, planeNormal, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnPlane3D(FramePoint3DReadOnly pointToProject, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DBasics projectionToPack) {
        pointToProject.checkReferenceFrameMatch(pointOnPlane, planeNormal);
        projectionToPack.setReferenceFrame(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnPlane3D(double x, double y, double z, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FixedFramePoint3DBasics projectionToPack) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal, projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D((double)x, (double)y, (double)z, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)projectionToPack);
    }

    public static boolean orthogonalProjectionOnPlane3D(double x, double y, double z, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DBasics projectionToPack) {
        pointOnPlane.checkReferenceFrameMatch(planeNormal);
        projectionToPack.setReferenceFrame(pointOnPlane.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D((double)x, (double)y, (double)z, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)projectionToPack);
    }

    public static double percentageOfIntersectionBetweenTwoLine2Ds(FramePoint2DReadOnly pointOnLine1, FrameVector2DReadOnly lineDirection1, FramePoint2DReadOnly pointOnLine2, FrameVector2DReadOnly lineDirection2) {
        pointOnLine1.checkReferenceFrameMatch(lineDirection1, pointOnLine2, lineDirection2);
        return EuclidGeometryTools.percentageOfIntersectionBetweenTwoLine2Ds((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2);
    }

    public static double percentageOfIntersectionBetweenLineSegment2DAndLine2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd, pointOnLine, lineDirection);
        return EuclidGeometryTools.percentageOfIntersectionBetweenLineSegment2DAndLine2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static double percentageAlongLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.percentageAlongLine2D((Point2DReadOnly)point, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static double percentageAlongLine2D(double pointX, double pointY, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.percentageAlongLine2D((double)pointX, (double)pointY, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static double percentageAlongLineSegment2D(double pointX, double pointY, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.percentageAlongLineSegment2D((double)pointX, (double)pointY, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double percentageAlongLineSegment2D(FramePoint2DReadOnly point, FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.percentageAlongLineSegment2D((Point2DReadOnly)point, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    public static double percentageAlongLine3D(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
    }

    public static double percentageAlongLine3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.percentageAlongLine3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
    }

    public static double percentageAlongLineSegment3D(double pointX, double pointY, double pointZ, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.percentageAlongLineSegment3D((double)pointX, (double)pointY, (double)pointZ, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static double percentageAlongLineSegment3D(FramePoint3DReadOnly point, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        point.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static boolean perpendicularBisector2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics bisectorStartToPack, FixedFrameVector2DBasics bisectorDirectionToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd, bisectorStartToPack, bisectorDirectionToPack);
        return EuclidGeometryTools.perpendicularBisector2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)bisectorStartToPack, (Vector2DBasics)bisectorDirectionToPack);
    }

    public static boolean perpendicularBisector2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics bisectorStartToPack, FrameVector2DBasics bisectorDirectionToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd, bisectorStartToPack, bisectorDirectionToPack);
        return EuclidGeometryTools.perpendicularBisector2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)bisectorStartToPack, (Vector2DBasics)bisectorDirectionToPack);
    }

    public static List<Point2D> perpendicularBisectorSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, double bisectorSegmentHalfLength) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        return EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength);
    }

    public static boolean perpendicularBisectorSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, double bisectorSegmentHalfLength, FixedFramePoint2DBasics bisectorSegmentStartToPack, FixedFramePoint2DBasics bisectorSegmentEndToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd, bisectorSegmentStartToPack, bisectorSegmentEndToPack);
        return EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength, (Point2DBasics)bisectorSegmentStartToPack, (Point2DBasics)bisectorSegmentEndToPack);
    }

    public static boolean perpendicularBisectorSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, double bisectorSegmentHalfLength, FramePoint2DBasics bisectorSegmentStartToPack, FramePoint2DBasics bisectorSegmentEndToPack) {
        lineSegmentStart.checkReferenceFrameMatch(lineSegmentEnd);
        bisectorSegmentStartToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        bisectorSegmentEndToPack.setReferenceFrame(lineSegmentStart.getReferenceFrame());
        return EuclidGeometryTools.perpendicularBisectorSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (double)bisectorSegmentHalfLength, (Point2DBasics)bisectorSegmentStartToPack, (Point2DBasics)bisectorSegmentEndToPack);
    }

    public static FrameVector2D perpendicularVector2D(FrameVector2DReadOnly vector) {
        return new FrameVector2D(vector.getReferenceFrame(), (Tuple2DReadOnly)EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)vector));
    }

    public static void perpendicularVector2D(FrameVector2DReadOnly vector, FixedFrameVector2DBasics perpendicularVectorToPack) {
        perpendicularVectorToPack.set(vector.getReferenceFrame(), -vector.getY(), vector.getX());
    }

    public static void perpendicularVector2D(FrameVector2DReadOnly vector, FrameVector2DBasics perpendicularVectorToPack) {
        perpendicularVectorToPack.setToZero(vector.getReferenceFrame());
        perpendicularVectorToPack.set(-vector.getY(), vector.getX());
    }

    public static FrameVector3D perpendicularVector3DFromLine3DToPoint3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FixedFramePoint3DBasics orthogonalProjectionToPack) {
        Vector3D perpendicularVector;
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        if (orthogonalProjectionToPack != null) {
            point.checkReferenceFrameMatch(orthogonalProjectionToPack);
        }
        if ((perpendicularVector = EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)orthogonalProjectionToPack)) == null) {
            return null;
        }
        return new FrameVector3D(point.getReferenceFrame(), (Tuple3DReadOnly)perpendicularVector);
    }

    public static FrameVector3D perpendicularVector3DFromLine3DToPoint3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics orthogonalProjectionToPack) {
        Vector3D perpendicularVector;
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        if (orthogonalProjectionToPack != null) {
            orthogonalProjectionToPack.setReferenceFrame(point.getReferenceFrame());
        }
        if ((perpendicularVector = EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)orthogonalProjectionToPack)) == null) {
            return null;
        }
        return new FrameVector3D(point.getReferenceFrame(), (Tuple3DReadOnly)perpendicularVector);
    }

    public static boolean perpendicularVector3DFromLine3DToPoint3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FixedFramePoint3DBasics orthogonalProjectionToPack, FixedFrameVector3DBasics perpendicularVectorToPack) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine, perpendicularVectorToPack);
        if (orthogonalProjectionToPack != null) {
            point.checkReferenceFrameMatch(orthogonalProjectionToPack);
        }
        return EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)orthogonalProjectionToPack, (Vector3DBasics)perpendicularVectorToPack);
    }

    public static boolean perpendicularVector3DFromLine3DToPoint3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics orthogonalProjectionToPack, FrameVector3DBasics perpendicularVectorToPack) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        if (orthogonalProjectionToPack != null) {
            orthogonalProjectionToPack.setReferenceFrame(point.getReferenceFrame());
        }
        perpendicularVectorToPack.setReferenceFrame(point.getReferenceFrame());
        return EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)orthogonalProjectionToPack, (Vector3DBasics)perpendicularVectorToPack);
    }

    public static double signedDistanceFromPoint2DToLine2D(double pointX, double pointY, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        firstPointOnLine.checkReferenceFrameMatch(secondPointOnLine);
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((double)pointX, (double)pointY, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
    }

    public static double signedDistanceFromPoint2DToLine2D(double pointX, double pointY, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        pointOnLine.checkReferenceFrameMatch(lineDirection);
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((double)pointX, (double)pointY, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static double signedDistanceFromPoint2DToLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        point.checkReferenceFrameMatch(firstPointOnLine, secondPointOnLine);
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)point, (Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
    }

    public static double signedDistanceFromPoint2DToLine2D(FramePoint2DReadOnly point, FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        point.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)point, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    public static boolean sphere3DPositionFromThreePoints(FramePoint3DReadOnly p1, FramePoint3DReadOnly p2, FramePoint3DReadOnly p3, double sphere3DRadius, FixedFramePoint3DBasics sphere3DPositionToPack) {
        p1.checkReferenceFrameMatch(p2, p3, sphere3DPositionToPack);
        return EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)p1, (Point3DReadOnly)p2, (Point3DReadOnly)p3, (double)sphere3DRadius, (Point3DBasics)sphere3DPositionToPack);
    }

    public static boolean sphere3DPositionFromThreePoints(FramePoint3DReadOnly p1, FramePoint3DReadOnly p2, FramePoint3DReadOnly p3, double sphere3DRadius, FramePoint3DBasics sphere3DPositionToPack) {
        p1.checkReferenceFrameMatch(p2, p3);
        sphere3DPositionToPack.setReferenceFrame(p1.getReferenceFrame());
        return EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)p1, (Point3DReadOnly)p2, (Point3DReadOnly)p3, (double)sphere3DRadius, (Point3DBasics)sphere3DPositionToPack);
    }

    public static void topVertex3DOfIsoscelesTriangle3D(FramePoint3DReadOnly baseVertexA, FramePoint3DReadOnly baseVertexC, FrameVector3DReadOnly trianglePlaneNormal, double ccwAngleAboutNormalAtTopVertex, FixedFramePoint3DBasics topVertexBToPack) {
        baseVertexA.checkReferenceFrameMatch(baseVertexC, trianglePlaneNormal, topVertexBToPack);
        EuclidGeometryTools.topVertex3DOfIsoscelesTriangle3D((Point3DReadOnly)baseVertexA, (Point3DReadOnly)baseVertexC, (Vector3DReadOnly)trianglePlaneNormal, (double)ccwAngleAboutNormalAtTopVertex, (Point3DBasics)topVertexBToPack);
    }

    public static void topVertex3DOfIsoscelesTriangle3D(FramePoint3DReadOnly baseVertexA, FramePoint3DReadOnly baseVertexC, FrameVector3DReadOnly trianglePlaneNormal, double ccwAngleAboutNormalAtTopVertex, FramePoint3DBasics topVertexBToPack) {
        baseVertexA.checkReferenceFrameMatch(baseVertexC, trianglePlaneNormal);
        topVertexBToPack.setReferenceFrame(baseVertexA.getReferenceFrame());
        EuclidGeometryTools.topVertex3DOfIsoscelesTriangle3D((Point3DReadOnly)baseVertexA, (Point3DReadOnly)baseVertexC, (Vector3DReadOnly)trianglePlaneNormal, (double)ccwAngleAboutNormalAtTopVertex, (Point3DBasics)topVertexBToPack);
    }

    public static FramePoint2D triangleBisector2D(FramePoint2DReadOnly A, FramePoint2DReadOnly B, FramePoint2DReadOnly C) {
        A.checkReferenceFrameMatch(B, C);
        Point2D X = EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C);
        if (X != null) {
            return new FramePoint2D(A.getReferenceFrame(), (Tuple2DReadOnly)X);
        }
        return null;
    }

    public static boolean triangleBisector2D(FramePoint2DReadOnly A, FramePoint2DReadOnly B, FramePoint2DReadOnly C, FixedFramePoint2DBasics XToPack) {
        A.checkReferenceFrameMatch(B, C, XToPack);
        return EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DBasics)XToPack);
    }

    public static boolean triangleBisector2D(FramePoint2DReadOnly A, FramePoint2DReadOnly B, FramePoint2DReadOnly C, FramePoint2DBasics XToPack) {
        A.checkReferenceFrameMatch(B, C);
        XToPack.setReferenceFrame(A.getReferenceFrame());
        return EuclidGeometryTools.triangleBisector2D((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DBasics)XToPack);
    }

    public static boolean equals(EuclidFrameGeometry a, EuclidFrameGeometry b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean epsilonEquals(EuclidFrameGeometry a, EuclidFrameGeometry b, double epsilon) {
        return a == b || a != null && a.epsilonEquals(b, epsilon);
    }

    public static boolean geometricallyEquals(EuclidFrameGeometry a, EuclidFrameGeometry b, double epsilon) {
        return a == b || a != null && a.geometricallyEquals(b, epsilon);
    }
}

