/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class FrameConvexPolygon2D
implements FrameConvexPolygon2DBasics,
Settable<FrameConvexPolygon2D> {
    private final boolean clockwiseOrdered = true;
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();
    private int numberOfVertices = 0;
    private final List<FixedFramePoint2DBasics> vertexBuffer = new ArrayList<FixedFramePoint2DBasics>();
    private final List<FixedFramePoint2DBasics> vertexBufferView = Collections.unmodifiableList(this.vertexBuffer);
    private final FixedFrameBoundingBox2DBasics boundingBox = EuclidFrameFactories.newFixedFrameBoundingBox2DBasics(this);
    private final FixedFramePoint2DBasics centroid = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private double area;
    private boolean isUpToDate = false;
    private boolean boundingBoxDirty = true;
    private boolean areaCentroidDirty = true;
    private ReferenceFrame referenceFrame;
    private final Point3D vertex3D = new Point3D();

    public FrameConvexPolygon2D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameConvexPolygon2D(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.clearAndUpdate();
    }

    public FrameConvexPolygon2D(ReferenceFrame referenceFrame, Vertex2DSupplier vertex2DSupplier) {
        this.setIncludingFrame(referenceFrame, vertex2DSupplier);
    }

    public FrameConvexPolygon2D(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier) {
        this.setIncludingFrame(referenceFrame, vertex3DSupplier);
    }

    public FrameConvexPolygon2D(FrameVertex2DSupplier frameVertex2DSupplier) {
        this.setIncludingFrame(frameVertex2DSupplier);
    }

    public FrameConvexPolygon2D(FrameVertex3DSupplier frameVertex3DSupplier) {
        this.setIncludingFrame(frameVertex3DSupplier);
    }

    public FrameConvexPolygon2D(FrameVertex2DSupplier firstVertex2DSupplier, FrameVertex2DSupplier secondVertex2DSupplier) {
        this.setIncludingFrame(firstVertex2DSupplier, secondVertex2DSupplier);
    }

    public void set(FrameConvexPolygon2D other) {
        if (!other.clockwiseOrdered) {
            FrameConvexPolygon2DBasics.super.set(other);
            return;
        }
        this.checkReferenceFrameMatch(other);
        this.numberOfVertices = other.numberOfVertices;
        for (int i = 0; i < other.numberOfVertices; ++i) {
            FixedFramePoint2DBasics otherVertex = other.vertexBuffer.get(i);
            this.setOrCreate(i, otherVertex.getX(), otherVertex.getY());
        }
        this.boundingBox.set(other.boundingBox);
        this.centroid.set(other.centroid);
        this.area = other.area;
        this.isUpToDate = other.isUpToDate;
        this.boundingBoxDirty = other.boundingBoxDirty;
        this.areaCentroidDirty = other.areaCentroidDirty;
    }

    public void set(Vertex2DSupplier vertex2DSupplier) {
        if (vertex2DSupplier instanceof ConvexPolygon2DReadOnly) {
            ConvexPolygon2DReadOnly other = (ConvexPolygon2DReadOnly)vertex2DSupplier;
            if (!other.isClockwiseOrdered()) {
                FrameConvexPolygon2DBasics.super.set(vertex2DSupplier);
                return;
            }
            this.clear();
            this.numberOfVertices = other.getNumberOfVertices();
            for (int i = 0; i < this.numberOfVertices; ++i) {
                Point2DReadOnly otherVertex = other.getVertexUnsafe(i);
                this.setOrCreate(i, otherVertex.getX(), otherVertex.getY());
            }
            if (other.isUpToDate()) {
                this.isUpToDate = true;
                this.boundingBoxDirty = true;
                this.areaCentroidDirty = true;
            }
        } else {
            FrameConvexPolygon2DBasics.super.set(vertex2DSupplier);
        }
    }

    @Override
    public void set(FrameVertex2DSupplier frameVertex2DSupplier) {
        if (frameVertex2DSupplier instanceof FrameConvexPolygon2D) {
            this.set((FrameConvexPolygon2D)frameVertex2DSupplier);
        } else if (frameVertex2DSupplier instanceof FrameConvexPolygon2DReadOnly) {
            FrameConvexPolygon2DReadOnly other = (FrameConvexPolygon2DReadOnly)frameVertex2DSupplier;
            if (!other.isClockwiseOrdered()) {
                FrameConvexPolygon2DBasics.super.set(frameVertex2DSupplier);
                return;
            }
            this.clear();
            this.numberOfVertices = other.getNumberOfVertices();
            for (int i = 0; i < this.numberOfVertices; ++i) {
                FramePoint2DReadOnly otherVertex = other.getVertexUnsafe(i);
                this.checkReferenceFrameMatch(otherVertex);
                this.setOrCreate(i, otherVertex.getX(), otherVertex.getY());
            }
            if (other.isUpToDate()) {
                this.isUpToDate = true;
                this.boundingBoxDirty = true;
                this.areaCentroidDirty = true;
            }
        } else {
            FrameConvexPolygon2DBasics.super.set(frameVertex2DSupplier);
        }
    }

    @Override
    public void setMatchingFrame(FrameVertex2DSupplier frameVertex2DSupplier, boolean checkIfTransformInXYPlane) {
        if (frameVertex2DSupplier.getReferenceFrame() == this.referenceFrame) {
            this.set(frameVertex2DSupplier);
        } else {
            this.set((Vertex2DSupplier)frameVertex2DSupplier);
            frameVertex2DSupplier.getReferenceFrame().getTransformToDesiredFrame(this.transformToDesiredFrame, this.referenceFrame);
            this.applyTransform((Transform)this.transformToDesiredFrame, checkIfTransformInXYPlane);
        }
    }

    @Override
    public FixedFramePoint2DBasics getVertexUnsafe(int index) {
        this.checkIndexInBoundaries(index);
        return this.vertexBuffer.get(index);
    }

    public void notifyVerticesChanged() {
        this.isUpToDate = false;
    }

    public void clear() {
        this.numberOfVertices = 0;
        this.area = Double.NaN;
        this.centroid.setToNaN();
        this.boundingBox.setToNaN();
        this.isUpToDate = false;
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    public void clearAndUpdate() {
        this.clear();
        this.isUpToDate = true;
        this.boundingBoxDirty = false;
        this.areaCentroidDirty = false;
    }

    @Override
    public void addVertexMatchingFrame(ReferenceFrame referenceFrame, Point2DReadOnly vertex, boolean checkIfTransformInXYPlane) {
        if (this.getReferenceFrame() == referenceFrame) {
            this.addVertex(vertex);
        } else {
            referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, this.getReferenceFrame());
            this.addVertex(vertex);
            this.getVertexUnsafe(this.getNumberOfVertices() - 1).applyTransform((Transform)this.transformToDesiredFrame, checkIfTransformInXYPlane);
        }
    }

    @Override
    public void addVertexMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly vertex) {
        if (this.getReferenceFrame() == referenceFrame) {
            this.addVertex(vertex);
        } else {
            referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, this.getReferenceFrame());
            this.transformToDesiredFrame.transform(vertex, (Point3DBasics)this.vertex3D);
            this.addVertex((Point3DReadOnly)this.vertex3D);
        }
    }

    public void update() {
        if (this.isUpToDate) {
            return;
        }
        this.numberOfVertices = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(this.vertexBuffer, (int)this.numberOfVertices);
        this.isUpToDate = true;
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    private void updateCentroidAndArea() {
        if (this.areaCentroidDirty) {
            this.areaCentroidDirty = false;
            this.area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(this.vertexBuffer, (int)this.numberOfVertices, (boolean)true, (Point2DBasics)this.centroid);
        }
    }

    private void updateBoundingBox() {
        if (this.boundingBoxDirty) {
            this.boundingBoxDirty = false;
            this.boundingBox.setToNaN();
            this.boundingBox.updateToIncludePoints(this);
        }
    }

    public void addVertex(double x, double y) {
        this.isUpToDate = false;
        this.setOrCreate(this.numberOfVertices, x, y);
        ++this.numberOfVertices;
    }

    private void setOrCreate(int i, double x, double y) {
        while (i >= this.vertexBuffer.size()) {
            this.vertexBuffer.add(EuclidFrameFactories.newFixedFramePoint2DBasics(this));
        }
        this.vertexBuffer.get(i).set(x, y);
    }

    public void removeVertex(int indexOfVertexToRemove) {
        this.checkIndexInBoundaries(indexOfVertexToRemove);
        if (indexOfVertexToRemove == this.numberOfVertices - 1) {
            --this.numberOfVertices;
            return;
        }
        this.isUpToDate = false;
        Collections.swap(this.vertexBuffer, indexOfVertexToRemove, this.numberOfVertices - 1);
        --this.numberOfVertices;
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public final void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public List<? extends FramePoint2DReadOnly> getVertexBufferView() {
        return this.vertexBufferView;
    }

    public boolean isClockwiseOrdered() {
        return true;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    public double getArea() {
        this.checkIfUpToDate();
        this.updateCentroidAndArea();
        return this.area;
    }

    @Override
    public FramePoint2DReadOnly getCentroid() {
        this.checkIfUpToDate();
        this.updateCentroidAndArea();
        return this.centroid;
    }

    public FrameBoundingBox2DReadOnly getBoundingBox() {
        this.checkIfUpToDate();
        this.updateBoundingBox();
        return this.boundingBox;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void translate(double x, double y) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).add(x, y);
        }
        if (!this.boundingBoxDirty) {
            this.boundingBox.getMinPoint().add(x, y);
            this.boundingBox.getMaxPoint().add(x, y);
        }
        if (!this.areaCentroidDirty) {
            this.centroid.add(x, y);
        }
    }

    public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyTransform(transform, checkIfTransformInXYPlane);
        }
        this.postTransform(transform);
    }

    public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyInverseTransform(transform, checkIfTransformInXYPlane);
        }
        this.postTransform(transform);
    }

    private void postTransform(Transform transform) {
        if (this.numberOfVertices <= 3) {
            this.notifyVerticesChanged();
            this.update();
            return;
        }
        boolean updateVertices = true;
        if (transform instanceof RigidBodyTransformReadOnly) {
            RigidBodyTransformReadOnly rbTransform = (RigidBodyTransformReadOnly)transform;
            updateVertices = rbTransform.hasRotation();
        } else if (transform instanceof AffineTransformReadOnly) {
            AffineTransformReadOnly aTransform = (AffineTransformReadOnly)transform;
            updateVertices = aTransform.hasLinearTransform();
        }
        if (updateVertices) {
            EuclidGeometryPolygonTools.Convexity convexity = null;
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (convexity == null) {
                    convexity = EuclidGeometryPolygonTools.polygon2DConvexityAtVertex((int)vertexIndex, this.vertexBuffer, (int)vertexIndex, (boolean)true);
                }
                if (convexity != null) break;
            }
            if (convexity == EuclidGeometryPolygonTools.Convexity.CONCAVE) {
                EuclidCoreTools.reverse(this.vertexBuffer, (int)0, (int)this.numberOfVertices);
            }
            int minXMaxYVertexIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex(this.vertexBuffer, (int)this.numberOfVertices);
            EuclidCoreTools.rotate(this.vertexBuffer, (int)0, (int)this.numberOfVertices, (int)(-minXMaxYVertexIndex));
        }
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameConvexPolygon2DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)Boolean.hashCode(true), this.vertexBufferView);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.referenceFrame);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

