/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameLine3D
implements FrameLine3DBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics point = EuclidFrameFactories.newFixedFramePoint3DBasics(this);
    private final FixedFrameUnitVector3DBasics direction = EuclidFrameFactories.newFixedFrameUnitVector3DBasics(this, (Vector3DReadOnly)Axis3D.X);

    public FrameLine3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameLine3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameLine3D(Line2DReadOnly line2DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), line2DReadOnly);
    }

    public FrameLine3D(ReferenceFrame referenceFrame, Line2DReadOnly line2DReadOnly) {
        this.setIncludingFrame(referenceFrame, line2DReadOnly);
    }

    public FrameLine3D(Line3DReadOnly line3DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), line3DReadOnly);
    }

    public FrameLine3D(ReferenceFrame referenceFrame, Line3DReadOnly line3DReadOnly) {
        this.setIncludingFrame(referenceFrame, line3DReadOnly);
    }

    public FrameLine3D(ReferenceFrame referenceFrame, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine) {
        this.setIncludingFrame(referenceFrame, firstPointOnLine, secondPointOnLine);
    }

    public FrameLine3D(ReferenceFrame referenceFrame, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        this.setIncludingFrame(referenceFrame, pointOnLine, lineDirection);
    }

    public FrameLine3D(LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), lineSegment2DReadOnly);
    }

    public FrameLine3D(ReferenceFrame referenceFrame, LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.setIncludingFrame(referenceFrame, lineSegment2DReadOnly);
    }

    public FrameLine3D(LineSegment3DReadOnly lineSegment3DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), lineSegment3DReadOnly);
    }

    public FrameLine3D(ReferenceFrame referenceFrame, LineSegment3DReadOnly lineSegment3DReadOnly) {
        this.setIncludingFrame(referenceFrame, lineSegment3DReadOnly);
    }

    public FrameLine3D(FrameLine2DReadOnly frameLine2DReadOnly) {
        this.setIncludingFrame(frameLine2DReadOnly);
    }

    public FrameLine3D(FrameLine3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameLine3D(FrameLineSegment2DReadOnly frameLineSegment2DReadOnly) {
        this.setIncludingFrame(frameLineSegment2DReadOnly);
    }

    public FrameLine3D(FrameLineSegment3DReadOnly frameLineSegment3DReadOnly) {
        this.setIncludingFrame(frameLineSegment3DReadOnly);
    }

    public FrameLine3D(FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine) {
        this.setIncludingFrame(firstPointOnLine, secondPointOnLine);
    }

    public FrameLine3D(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        this.setIncludingFrame(pointOnLine, lineDirection);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getPoint() {
        return this.point;
    }

    @Override
    public FixedFrameUnitVector3DBasics getDirection() {
        return this.direction;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameLine3DReadOnly) {
            return this.equals((FrameLine3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.direction);
    }
}

