/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class FrameLine2D
implements FrameLine2DBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint2DBasics point = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private final FixedFrameUnitVector2DBasics direction = EuclidFrameFactories.newFixedFrameUnitVector2DBasics(this, (Vector2DReadOnly)Axis2D.X);
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FrameLine2D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameLine2D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameLine2D(Line2DReadOnly line2DReadOnly) {
        this(ReferenceFrame.getWorldFrame(), line2DReadOnly);
    }

    public FrameLine2D(ReferenceFrame referenceFrame, Line2DReadOnly line2DReadOnly) {
        this.setIncludingFrame(referenceFrame, line2DReadOnly);
    }

    public FrameLine2D(ReferenceFrame referenceFrame, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        this.setIncludingFrame(referenceFrame, firstPointOnLine, secondPointOnLine);
    }

    public FrameLine2D(ReferenceFrame referenceFrame, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        this.setIncludingFrame(referenceFrame, pointOnLine, lineDirection);
    }

    public FrameLine2D(LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), lineSegment2DReadOnly);
    }

    public FrameLine2D(ReferenceFrame referenceFrame, LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.setIncludingFrame(referenceFrame, lineSegment2DReadOnly);
    }

    public FrameLine2D(FrameLine2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameLine2D(FrameLineSegment2DReadOnly frameLineSegment2DReadOnly) {
        this.setIncludingFrame(frameLineSegment2DReadOnly);
    }

    public FrameLine2D(FramePoint2DReadOnly firstPointOnLine, FramePoint2DReadOnly secondPointOnLine) {
        this.setIncludingFrame(firstPointOnLine, secondPointOnLine);
    }

    public FrameLine2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        this.setIncludingFrame(pointOnLine, lineDirection);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint2DBasics getPoint() {
        return this.point;
    }

    @Override
    public FixedFrameUnitVector2DBasics getDirection() {
        return this.direction;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.referenceFrame = desiredFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameLine2DReadOnly) {
            return this.equals((FrameLine2DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.direction);
    }
}

