/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;

public interface FramePose2DReadOnly
extends Pose2DReadOnly,
ReferenceFrameHolder {
    public FramePoint2DReadOnly getPosition();

    public FrameOrientation2DReadOnly getOrientation();

    default public double getPositionDistance(FramePose2DReadOnly other) {
        return this.getPositionDistance(other.getPosition());
    }

    default public double getPositionDistance(FramePoint2DReadOnly point) {
        return this.getPosition().distance(point);
    }

    default public double getOrientationDistance(FrameOrientation2DReadOnly orientation) {
        return this.getOrientation().distance(orientation);
    }

    default public double getOrientationDistance(FramePose2DReadOnly other) {
        return this.getOrientationDistance(other.getOrientation());
    }

    default public boolean epsilonEquals(FramePose2DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((Pose2DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FramePose2DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((Pose2DReadOnly)other, epsilon);
    }

    default public boolean equals(FramePose2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.equals((Pose2DReadOnly)other);
    }
}

