/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePoint2D
implements FramePoint2DBasics,
GeometryObject<FramePoint2D> {
    private ReferenceFrame referenceFrame;
    private final Point2D point = new Point2D();
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FramePoint2D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FramePoint2D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FramePoint2D(ReferenceFrame referenceFrame, double x, double y) {
        this.setIncludingFrame(referenceFrame, x, y);
    }

    public FramePoint2D(ReferenceFrame referenceFrame, double[] pointArray) {
        this.setIncludingFrame(referenceFrame, pointArray);
    }

    public FramePoint2D(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly);
    }

    public FramePoint2D(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public FramePoint2D(FrameTuple2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FramePoint2D(FrameTuple3DReadOnly frameTuple3DReadOnly) {
        this.setIncludingFrame(frameTuple3DReadOnly);
    }

    public void set(FramePoint2D other) {
        FramePoint2DBasics.super.set((FrameTuple2DReadOnly)other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.point.setX(x);
    }

    public void setY(double y) {
        this.point.setY(y);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public final void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.referenceFrame = desiredFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple2DReadOnly) {
            return this.equals((FrameTuple2DReadOnly)object);
        }
        return false;
    }

    public boolean epsilonEquals(FramePoint2D other, double epsilon) {
        return FramePoint2DBasics.super.epsilonEquals((FrameTuple2DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FramePoint2D other, double epsilon) {
        return FramePoint2DBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameTuple2DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.referenceFrame);
    }
}

