/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;

public class FrameLineSegment3D
implements FrameLineSegment3DBasics,
GeometryObject<FrameLineSegment3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics firstEndpoint = EuclidFrameFactories.newFixedFramePoint3DBasics(this);
    private final FixedFramePoint3DBasics secondEndpoint = EuclidFrameFactories.newFixedFramePoint3DBasics(this);

    public FrameLineSegment3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameLineSegment3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameLineSegment3D(LineSegment3DReadOnly lineSegment3DReadOnly) {
        this(ReferenceFrame.getWorldFrame(), lineSegment3DReadOnly);
    }

    public FrameLineSegment3D(ReferenceFrame referenceFrame, LineSegment3DReadOnly lineSegment3DReadOnly) {
        this.setIncludingFrame(referenceFrame, lineSegment3DReadOnly);
    }

    public FrameLineSegment3D(FrameLineSegment3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FrameLineSegment3D other) {
        FrameLineSegment3DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getFirstEndpoint() {
        return this.firstEndpoint;
    }

    @Override
    public FixedFramePoint3DBasics getSecondEndpoint() {
        return this.secondEndpoint;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean epsilonEquals(FrameLineSegment3D other, double epsilon) {
        return FrameLineSegment3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(FrameLineSegment3D other, double epsilon) {
        return FrameLineSegment3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameLineSegment3DReadOnly) {
            return this.equals((FrameLineSegment3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameLineSegment3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.firstEndpoint, (Object)this.secondEndpoint);
    }
}

