/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameYawPitchRoll
implements FrameYawPitchRollBasics,
GeometryObject<FrameYawPitchRoll> {
    private ReferenceFrame referenceFrame;
    private double yaw;
    private double pitch;
    private double roll;

    public FrameYawPitchRoll() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameYawPitchRoll(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameYawPitchRoll(ReferenceFrame referenceFrame, double[] yawPitchRollArray) {
        this.setIncludingFrame(referenceFrame, yawPitchRollArray);
    }

    public FrameYawPitchRoll(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation3DReadOnly) {
        this.setIncludingFrame(referenceFrame, orientation3DReadOnly);
    }

    public FrameYawPitchRoll(ReferenceFrame referenceFrame, Vector3DReadOnly rotationVector) {
        this.setRotationVectorIncludingFrame(referenceFrame, rotationVector);
    }

    public FrameYawPitchRoll(ReferenceFrame referenceFrame, double yaw, double pitch, double roll) {
        this.setYawPitchRollIncludingFrame(referenceFrame, yaw, pitch, roll);
    }

    public FrameYawPitchRoll(FrameYawPitchRollReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FrameYawPitchRoll other) {
        FrameYawPitchRollBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public void setRoll(double roll) {
        this.roll = roll;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getRoll() {
        return this.roll;
    }

    public boolean equals(Object other) {
        if (other instanceof FrameYawPitchRollReadOnly) {
            return this.equals((FrameYawPitchRollReadOnly)other);
        }
        return false;
    }

    public boolean epsilonEquals(FrameYawPitchRoll other, double epsilon) {
        return FrameYawPitchRollBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(FrameYawPitchRoll other, double epsilon) {
        return FrameYawPitchRollBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameYawPitchRollString(this);
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)EuclidHashCodeTools.toLongHashCode((double)this.yaw, (double)this.pitch, (double)this.roll), (Object)this.referenceFrame);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }
}

