/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FrameUnitVector2D
implements FrameUnitVector2DBasics,
GeometryObject<FrameUnitVector2D> {
    private ReferenceFrame referenceFrame;
    private final UnitVector2D vector = new UnitVector2D();
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FrameUnitVector2D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameUnitVector2D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameUnitVector2D(ReferenceFrame referenceFrame, double x, double y) {
        this.setIncludingFrame(referenceFrame, x, y);
    }

    public FrameUnitVector2D(ReferenceFrame referenceFrame, double[] vectorArray) {
        this.setIncludingFrame(referenceFrame, vectorArray);
    }

    public FrameUnitVector2D(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly);
    }

    public FrameUnitVector2D(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public FrameUnitVector2D(FrameTuple3DReadOnly frameTuple3DReadOnly) {
        this.setIncludingFrame(frameTuple3DReadOnly);
    }

    public FrameUnitVector2D(FrameTuple2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void absolute() {
        this.vector.absolute();
    }

    public void negate() {
        this.vector.negate();
    }

    public void normalize() {
        this.vector.normalize();
    }

    public void markAsDirty() {
        this.vector.markAsDirty();
    }

    public boolean isDirty() {
        return this.vector.isDirty();
    }

    public void set(FrameUnitVector2D other) {
        FrameUnitVector2DBasics.super.set((FrameUnitVector2DReadOnly)other);
    }

    public void set(UnitVector2DReadOnly other) {
        this.vector.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.vector.setX(x);
    }

    public void setY(double y) {
        this.vector.setY(y);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getRawX() {
        return this.vector.getRawX();
    }

    public double getRawY() {
        return this.vector.getRawY();
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public final void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.referenceFrame = desiredFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple2DReadOnly) {
            return this.equals((FrameTuple2DReadOnly)object);
        }
        return false;
    }

    public boolean epsilonEquals(FrameUnitVector2D other, double epsilon) {
        return FrameUnitVector2DBasics.super.epsilonEquals((FrameTuple2DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameUnitVector2D other, double epsilon) {
        return FrameUnitVector2DBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameTuple2DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.vector, (Object)this.referenceFrame);
    }
}

