/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;

public class FrameMatrix3D
implements FrameMatrix3DBasics,
GeometryObject<FrameMatrix3D> {
    private ReferenceFrame referenceFrame;
    private final Matrix3D matrix3D = new Matrix3D();
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FrameMatrix3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameMatrix3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameMatrix3D(FrameMatrix3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameMatrix3D(ReferenceFrame referenceFrame, Matrix3DReadOnly matrix3DReadOnly) {
        this.setIncludingFrame(referenceFrame, matrix3DReadOnly);
    }

    public void set(FrameMatrix3D other) {
        FrameMatrix3DBasics.super.set((FrameMatrix3DReadOnly)other);
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.setReferenceFrame(desiredFrame);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setM00(double m00) {
        this.matrix3D.setM00(m00);
    }

    public void setM01(double m01) {
        this.matrix3D.setM01(m01);
    }

    public void setM02(double m02) {
        this.matrix3D.setM02(m02);
    }

    public void setM10(double m10) {
        this.matrix3D.setM10(m10);
    }

    public void setM11(double m11) {
        this.matrix3D.setM11(m11);
    }

    public void setM12(double m12) {
        this.matrix3D.setM12(m12);
    }

    public void setM20(double m20) {
        this.matrix3D.setM20(m20);
    }

    public void setM21(double m21) {
        this.matrix3D.setM21(m21);
    }

    public void setM22(double m22) {
        this.matrix3D.setM22(m22);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getM00() {
        return this.matrix3D.getM00();
    }

    public double getM01() {
        return this.matrix3D.getM01();
    }

    public double getM02() {
        return this.matrix3D.getM02();
    }

    public double getM10() {
        return this.matrix3D.getM10();
    }

    public double getM11() {
        return this.matrix3D.getM11();
    }

    public double getM12() {
        return this.matrix3D.getM12();
    }

    public double getM20() {
        return this.matrix3D.getM20();
    }

    public double getM21() {
        return this.matrix3D.getM21();
    }

    public double getM22() {
        return this.matrix3D.getM22();
    }

    public boolean geometricallyEquals(FrameMatrix3D other, double epsilon) {
        return this.epsilonEquals(other, epsilon);
    }

    public boolean epsilonEquals(FrameMatrix3D other, double epsilon) {
        return FrameMatrix3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameMatrix3DReadOnly) {
            return FrameMatrix3DBasics.super.equals((FrameMatrix3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameMatrix3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.matrix3D, (Object)this.referenceFrame);
    }
}

