/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DBasics;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTorus3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameShapeTools {
    private static final double EPSILON = 1.0E-12;
    private static final BoundingBoxRotationPartCalculator<Box3DReadOnly> box3DCalculator = new BoundingBoxRotationPartCalculator<Box3DReadOnly>(){

        @Override
        public void computeBoundingBoxZeroRotation(Box3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfSizeX = 0.5 * shape.getSizeX();
            double halfSizeY = 0.5 * shape.getSizeY();
            double halfSizeZ = 0.5 * shape.getSizeZ();
            boundingBoxToPack.set(-halfSizeX, -halfSizeY, -halfSizeZ, halfSizeX, halfSizeY, halfSizeZ);
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Box3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfSizeX = 0.5 * shape.getSizeX();
            double halfSizeY = 0.5 * shape.getSizeY();
            double halfSizeZ = 0.5 * shape.getSizeZ();
            double xRange = Math.abs(m00) * halfSizeX + Math.abs(m01) * halfSizeY + Math.abs(m02) * halfSizeZ;
            double yRange = Math.abs(m10) * halfSizeX + Math.abs(m11) * halfSizeY + Math.abs(m12) * halfSizeZ;
            double zRange = Math.abs(m20) * halfSizeX + Math.abs(m21) * halfSizeY + Math.abs(m22) * halfSizeZ;
            boundingBoxToPack.set(-xRange, -yRange, -zRange, xRange, yRange, zRange);
        }
    };
    private static final BoundingBoxRotationPartCalculator<Capsule3DReadOnly> capsule3DCalculator = new BoundingBoxRotationPartCalculator<Capsule3DReadOnly>(){

        @Override
        public void computeBoundingBoxZeroRotation(Capsule3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfLength = shape.getHalfLength();
            double radius = shape.getRadius();
            UnitVector3DReadOnly axis = shape.getAxis();
            double axisX = axis.getX();
            double axisY = axis.getY();
            double axisZ = axis.getZ();
            double rangeX = halfLength * Math.abs(axisX) + radius;
            double rangeY = halfLength * Math.abs(axisY) + radius;
            double rangeZ = halfLength * Math.abs(axisZ) + radius;
            boundingBoxToPack.set(-rangeX, -rangeY, -rangeZ, rangeX, rangeY, rangeZ);
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Capsule3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfLength = shape.getHalfLength();
            double radius = shape.getRadius();
            UnitVector3DReadOnly axis = shape.getAxis();
            double axisX = m00 * axis.getX() + m01 * axis.getY() + m02 * axis.getZ();
            double axisY = m10 * axis.getX() + m11 * axis.getY() + m12 * axis.getZ();
            double axisZ = m20 * axis.getX() + m21 * axis.getY() + m22 * axis.getZ();
            double rangeX = halfLength * Math.abs(axisX) + radius;
            double rangeY = halfLength * Math.abs(axisY) + radius;
            double rangeZ = halfLength * Math.abs(axisZ) + radius;
            boundingBoxToPack.set(-rangeX, -rangeY, -rangeZ, rangeX, rangeY, rangeZ);
        }
    };
    private static final BoundingBoxRotationPartCalculator<Cylinder3DReadOnly> cylinder3DCalculator = new BoundingBoxRotationPartCalculator<Cylinder3DReadOnly>(){

        @Override
        public void computeBoundingBoxZeroRotation(Cylinder3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfLength = shape.getHalfLength();
            double radius = shape.getRadius();
            UnitVector3DReadOnly axis = shape.getAxis();
            double axisX = axis.getX();
            double axisY = axis.getY();
            double axisZ = axis.getZ();
            double invNormSquared = 1.0 / axis.normSquared();
            double capMinMaxX = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisX * axisX * invNormSquared)));
            double capMinMaxY = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisY * axisY * invNormSquared)));
            double capMinMaxZ = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisZ * axisZ * invNormSquared)));
            double rangeX = halfLength * Math.abs(axisX) + capMinMaxX;
            double rangeY = halfLength * Math.abs(axisY) + capMinMaxY;
            double rangeZ = halfLength * Math.abs(axisZ) + capMinMaxZ;
            boundingBoxToPack.set(-rangeX, -rangeY, -rangeZ, rangeX, rangeY, rangeZ);
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Cylinder3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfLength = shape.getHalfLength();
            double radius = shape.getRadius();
            UnitVector3DReadOnly axis = shape.getAxis();
            double axisX = m00 * axis.getX() + m01 * axis.getY() + m02 * axis.getZ();
            double axisY = m10 * axis.getX() + m11 * axis.getY() + m12 * axis.getZ();
            double axisZ = m20 * axis.getX() + m21 * axis.getY() + m22 * axis.getZ();
            double invNormSquared = 1.0 / axis.normSquared();
            double capMinMaxX = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisX * axisX * invNormSquared)));
            double capMinMaxY = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisY * axisY * invNormSquared)));
            double capMinMaxZ = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisZ * axisZ * invNormSquared)));
            double rangeX = halfLength * Math.abs(axisX) + capMinMaxX;
            double rangeY = halfLength * Math.abs(axisY) + capMinMaxY;
            double rangeZ = halfLength * Math.abs(axisZ) + capMinMaxZ;
            boundingBoxToPack.set(-rangeX, -rangeY, -rangeZ, rangeX, rangeY, rangeZ);
        }
    };
    private static final BoundingBoxRotationPartCalculator<Ellipsoid3DReadOnly> ellipsoid3DCalculator = new BoundingBoxRotationPartCalculator<Ellipsoid3DReadOnly>(){

        @Override
        public void computeBoundingBoxZeroRotation(Ellipsoid3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            Vector3DReadOnly radii = shape.getRadii();
            boundingBoxToPack.set(-radii.getX(), -radii.getY(), -radii.getZ(), radii.getX(), radii.getY(), radii.getZ());
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Ellipsoid3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            Vector3DReadOnly radii = shape.getRadii();
            double rx = radii.getX() * radii.getX();
            double ry = radii.getY() * radii.getY();
            double rz = radii.getZ() * radii.getZ();
            double xRange = EuclidCoreTools.squareRoot((double)(m00 * m00 * rx + m01 * m01 * ry + m02 * m02 * rz));
            double yRange = EuclidCoreTools.squareRoot((double)(m10 * m10 * rx + m11 * m11 * ry + m12 * m12 * rz));
            double zRange = EuclidCoreTools.squareRoot((double)(m20 * m20 * rx + m21 * m21 * ry + m22 * m22 * rz));
            boundingBoxToPack.set(-xRange, -yRange, -zRange, xRange, yRange, zRange);
        }
    };
    private static final BoundingBoxRotationPartCalculator<Ramp3DReadOnly> ramp3DCalculator = new BoundingBoxRotationPartCalculator<Ramp3DReadOnly>(){

        @Override
        public void computeBoundingBoxZeroRotation(Ramp3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double sizeX = shape.getSizeX();
            double halfSizeY = 0.5 * shape.getSizeY();
            double sizeZ = shape.getSizeZ();
            boundingBoxToPack.set(0.0, -halfSizeY, 0.0, sizeX, halfSizeY, sizeZ);
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Ramp3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double sizeX = shape.getSizeX();
            double halfSizeY = 0.5 * shape.getSizeY();
            double sizeZ = shape.getSizeZ();
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double minZ = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < 6; ++i) {
                double xLocal = (i & 2) == 0 ? sizeX : 0.0;
                double yLocal = (i & 1) == 0 ? halfSizeY : -halfSizeY;
                double zLocal = (i & 4) == 0 ? 0.0 : sizeZ;
                double xRoot = m00 * xLocal + m01 * yLocal + m02 * zLocal;
                double yRoot = m10 * xLocal + m11 * yLocal + m12 * zLocal;
                double zRoot = m20 * xLocal + m21 * yLocal + m22 * zLocal;
                minX = Math.min(minX, xRoot);
                minY = Math.min(minY, yRoot);
                minZ = Math.min(minZ, zRoot);
                maxX = Math.max(maxX, xRoot);
                maxY = Math.max(maxY, yRoot);
                maxZ = Math.max(maxZ, zRoot);
            }
            boundingBoxToPack.set(minX, minY, minZ, maxX, maxY, maxZ);
        }
    };
    private static final BoundingBoxRotationPartCalculator<Torus3DReadOnly> torus3DCalculator = new BoundingBoxRotationPartCalculator<Torus3DReadOnly>(){

        @Override
        public void computeBoundingBoxZeroRotation(Torus3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfLength = shape.getTubeRadius();
            double radius = shape.getRadius() + shape.getTubeRadius();
            UnitVector3DReadOnly axis = shape.getAxis();
            double axisX = axis.getX();
            double axisY = axis.getY();
            double axisZ = axis.getZ();
            double invNormSquared = 1.0 / axis.normSquared();
            double capMinMaxX = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisX * axisX * invNormSquared)));
            double capMinMaxY = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisY * axisY * invNormSquared)));
            double capMinMaxZ = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisZ * axisZ * invNormSquared)));
            double rangeX = halfLength * Math.abs(axisX) + capMinMaxX;
            double rangeY = halfLength * Math.abs(axisY) + capMinMaxY;
            double rangeZ = halfLength * Math.abs(axisZ) + capMinMaxZ;
            boundingBoxToPack.set(-rangeX, -rangeY, -rangeZ, rangeX, rangeY, rangeZ);
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, Torus3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            double halfLength = shape.getTubeRadius();
            double radius = shape.getRadius() + shape.getTubeRadius();
            UnitVector3DReadOnly axis = shape.getAxis();
            double axisX = m00 * axis.getX() + m01 * axis.getY() + m02 * axis.getZ();
            double axisY = m10 * axis.getX() + m11 * axis.getY() + m12 * axis.getZ();
            double axisZ = m20 * axis.getX() + m21 * axis.getY() + m22 * axis.getZ();
            double invNormSquared = 1.0 / axis.normSquared();
            double capMinMaxX = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisX * axisX * invNormSquared)));
            double capMinMaxY = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisY * axisY * invNormSquared)));
            double capMinMaxZ = Math.max(0.0, radius * EuclidCoreTools.squareRoot((double)(1.0 - axisZ * axisZ * invNormSquared)));
            double rangeX = halfLength * Math.abs(axisX) + capMinMaxX;
            double rangeY = halfLength * Math.abs(axisY) + capMinMaxY;
            double rangeZ = halfLength * Math.abs(axisZ) + capMinMaxZ;
            boundingBoxToPack.set(-rangeX, -rangeY, -rangeZ, rangeX, rangeY, rangeZ);
        }
    };
    private static final BoundingBoxRotationPartCalculator<ConvexPolytope3DReadOnly> convexPolytope3DCalculator = new BoundingBoxRotationPartCalculator<ConvexPolytope3DReadOnly>(){
        private final Vector3D supportDirection = new Vector3D();

        @Override
        public void computeBoundingBoxZeroRotation(ConvexPolytope3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            boundingBoxToPack.set(shape.getBoundingBox());
        }

        @Override
        public void computeBoundingBox(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, ConvexPolytope3DReadOnly shape, BoundingBox3DBasics boundingBoxToPack) {
            this.supportDirection.set(m00, m01, m02);
            Vertex3DReadOnly vertexMaxX = shape.getSupportingVertex((Vector3DReadOnly)this.supportDirection);
            double maxX = vertexMaxX.dot((Vector3DReadOnly)this.supportDirection);
            this.supportDirection.set(m10, m11, m12);
            Vertex3DReadOnly vertexMaxY = shape.getSupportingVertex(vertexMaxX, (Vector3DReadOnly)this.supportDirection);
            double maxY = vertexMaxY.dot((Vector3DReadOnly)this.supportDirection);
            this.supportDirection.set(-m00, -m01, -m02);
            Vertex3DReadOnly vertexMinX = shape.getSupportingVertex(vertexMaxY, (Vector3DReadOnly)this.supportDirection);
            double minX = -vertexMinX.dot((Vector3DReadOnly)this.supportDirection);
            this.supportDirection.set(-m10, -m11, -m12);
            Vertex3DReadOnly vertexMinY = shape.getSupportingVertex(vertexMinX, (Vector3DReadOnly)this.supportDirection);
            double minY = -vertexMinY.dot((Vector3DReadOnly)this.supportDirection);
            this.supportDirection.set(m20, m21, m22);
            Vertex3DReadOnly vertexMaxZ = shape.getSupportingVertex(vertexMinX, (Vector3DReadOnly)this.supportDirection);
            double maxZ = vertexMaxZ.dot((Vector3DReadOnly)this.supportDirection);
            this.supportDirection.set(-m20, -m21, -m22);
            Vertex3DReadOnly vertexMinZ = shape.getSupportingVertex(vertexMinX, (Vector3DReadOnly)this.supportDirection);
            double minZ = -vertexMinZ.dot((Vector3DReadOnly)this.supportDirection);
            boundingBoxToPack.set(minX, minY, minZ, maxX, maxY, maxZ);
        }
    };

    private EuclidFrameShapeTools() {
    }

    public static double distanceXYFromPoint3DToLine3D(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine);
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((double)point.getX(), (double)point.getY(), (double)pointOnLineX, (double)pointOnLineY, (double)lineDirectionX, (double)lineDirectionY);
    }

    public static boolean isLineSegmentIntersectingPlane(FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal, FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal, (ReferenceFrameHolder)lineSegmentStart, (ReferenceFrameHolder)lineSegmentEnd);
        return EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static double distanceFromPointToPlane(FramePoint3DReadOnly point, FramePoint3DReadOnly pointOnPlane, FrameVector3DReadOnly planeNormal) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnPlane, (ReferenceFrameHolder)planeNormal);
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static boolean getIntersectionBetweenTwoPlanes(Plane3DReadOnly plane1, Plane3DReadOnly plane2, Line3DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)plane1.getPoint(), (Vector3DReadOnly)plane1.getNormal(), (Point3DReadOnly)plane2.getPoint(), (Vector3DReadOnly)plane2.getNormal(), (Point3DBasics)intersectionToPack.getPoint(), (Vector3DBasics)intersectionToPack.getDirection());
    }

    public static FrameVector3D getPlaneNormalGivenThreePoints(FramePoint3DReadOnly firstPointOnPlane, FramePoint3DReadOnly secondPointOnPlane, FramePoint3DReadOnly thirdPointOnPlane) {
        FrameVector3D normal = new FrameVector3D();
        boolean success = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints(firstPointOnPlane, secondPointOnPlane, thirdPointOnPlane, (FrameVector3DBasics)normal);
        if (!success) {
            return null;
        }
        return normal;
    }

    public static boolean getPlaneNormalGivenThreePoints(FramePoint3DReadOnly firstPointOnPlane, FramePoint3DReadOnly secondPointOnPlane, FramePoint3DReadOnly thirdPointOnPlane, FrameVector3DBasics normalToPack) {
        firstPointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnPlane, (ReferenceFrameHolder)thirdPointOnPlane);
        normalToPack.setToZero(firstPointOnPlane.getReferenceFrame());
        return EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)thirdPointOnPlane, (Vector3DBasics)normalToPack);
    }

    public static FrameVector3D getPerpendicularVectorFromLineToPoint(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics orthogonalProjectionToPack) {
        FrameVector3D perpendicularVector = new FrameVector3D();
        boolean success = EuclidFrameShapeTools.getPerpendicularVectorFromLineToPoint(point, firstPointOnLine, secondPointOnLine, orthogonalProjectionToPack, (FrameVector3DBasics)perpendicularVector);
        if (!success) {
            return null;
        }
        return perpendicularVector;
    }

    public static boolean getPerpendicularVectorFromLineToPoint(FramePoint3DReadOnly point, FramePoint3DReadOnly firstPointOnLine, FramePoint3DReadOnly secondPointOnLine, FramePoint3DBasics orthogonalProjectionToPack, FrameVector3DBasics perpendicularVectorToPack) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine, (ReferenceFrameHolder)secondPointOnLine);
        perpendicularVectorToPack.setReferenceFrame(point.getReferenceFrame());
        if (orthogonalProjectionToPack == null) {
            return EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, null, (Vector3DBasics)perpendicularVectorToPack);
        }
        orthogonalProjectionToPack.setReferenceFrame(point.getReferenceFrame());
        return EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)orthogonalProjectionToPack, (Vector3DBasics)perpendicularVectorToPack);
    }

    public static void boundingBoxBox3D(FrameBox3DReadOnly box3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxBox3D(box3D.getReferenceFrame(), box3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxBox3D(ReferenceFrame box3DFrame, Box3DReadOnly box3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        box3DFrame.verifySameRoots(boundingBoxFrame);
        if (box3DFrame == boundingBoxFrame) {
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)box3D.getPosition(), (RotationMatrixReadOnly)box3D.getOrientation(), (Vector3DReadOnly)box3D.getSize(), (BoundingBox3DBasics)boundingBoxToPack);
            return;
        }
        Point3DReadOnly shapePosition = box3D.getPosition();
        RotationMatrixReadOnly shapeOrientation = box3D.getOrientation();
        if (box3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, shapeOrientation, false, box3D, box3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = box3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, shapeOrientation, false, box3D, box3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, shapeOrientation, false, box3D, box3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxCapsule3D(FrameCapsule3DReadOnly capsule3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxCapsule3D(capsule3D.getReferenceFrame(), capsule3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxCapsule3D(ReferenceFrame capsule3DFrame, Capsule3DReadOnly capsule3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        capsule3DFrame.verifySameRoots(boundingBoxFrame);
        if (capsule3DFrame == boundingBoxFrame) {
            EuclidShapeTools.boundingBoxCapsule3D((Point3DReadOnly)capsule3D.getPosition(), (Vector3DReadOnly)capsule3D.getAxis(), (double)capsule3D.getLength(), (double)capsule3D.getRadius(), (BoundingBox3DBasics)boundingBoxToPack);
            return;
        }
        Point3DReadOnly position = capsule3D.getPosition();
        if (capsule3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, capsule3D, capsule3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = capsule3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, capsule3D, capsule3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, capsule3D, capsule3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxCylinder3D(FrameCylinder3DReadOnly cylinder3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxCylinder3D(cylinder3D.getReferenceFrame(), cylinder3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxCylinder3D(ReferenceFrame cylinder3DFrame, Cylinder3DReadOnly cylinder3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        cylinder3DFrame.verifySameRoots(boundingBoxFrame);
        if (cylinder3DFrame == boundingBoxFrame) {
            EuclidShapeTools.boundingBoxCylinder3D((Point3DReadOnly)cylinder3D.getPosition(), (Vector3DReadOnly)cylinder3D.getAxis(), (double)cylinder3D.getLength(), (double)cylinder3D.getRadius(), (BoundingBox3DBasics)boundingBoxToPack);
            return;
        }
        Point3DReadOnly position = cylinder3D.getPosition();
        if (cylinder3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, cylinder3D, cylinder3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = cylinder3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, cylinder3D, cylinder3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, cylinder3D, cylinder3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxEllipsoid3D(FrameEllipsoid3DReadOnly ellipsoid3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxEllipsoid3D(ellipsoid3D.getReferenceFrame(), ellipsoid3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxEllipsoid3D(ReferenceFrame ellipsoid3DFrame, Ellipsoid3DReadOnly ellipsoid3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        ellipsoid3DFrame.verifySameRoots(boundingBoxFrame);
        if (ellipsoid3DFrame == boundingBoxFrame) {
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoid3D.getPosition(), (RotationMatrixReadOnly)ellipsoid3D.getOrientation(), (Vector3DReadOnly)ellipsoid3D.getRadii(), (BoundingBox3DBasics)boundingBoxToPack);
            return;
        }
        Point3DReadOnly shapePosition = ellipsoid3D.getPosition();
        RotationMatrixReadOnly shapeOrientation = ellipsoid3D.getOrientation();
        if (ellipsoid3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, shapeOrientation, false, ellipsoid3D, ellipsoid3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = ellipsoid3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, shapeOrientation, false, ellipsoid3D, ellipsoid3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, shapeOrientation, false, ellipsoid3D, ellipsoid3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxRamp3D(FrameRamp3DReadOnly ramp3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxRamp3D(ramp3D.getReferenceFrame(), ramp3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxRamp3D(ReferenceFrame ramp3DFrame, Ramp3DReadOnly ramp3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        ramp3DFrame.verifySameRoots(boundingBoxFrame);
        if (ramp3DFrame == boundingBoxFrame) {
            ramp3D.getBoundingBox(boundingBoxToPack);
            return;
        }
        Point3DReadOnly shapePosition = ramp3D.getPosition();
        RotationMatrixReadOnly shapeOrientation = ramp3D.getOrientation();
        if (ramp3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, shapeOrientation, false, ramp3D, ramp3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = ramp3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, shapeOrientation, false, ramp3D, ramp3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, shapeOrientation, false, ramp3D, ramp3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, shapeOrientation, (Tuple3DReadOnly)shapePosition, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxSphere3D(FrameSphere3DReadOnly sphere3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxSphere3D(sphere3D.getReferenceFrame(), sphere3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxSphere3D(ReferenceFrame sphere3DFrame, Sphere3DReadOnly sphere3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        sphere3DFrame.verifySameRoots(boundingBoxFrame);
        if (sphere3DFrame == boundingBoxFrame) {
            sphere3D.getBoundingBox(boundingBoxToPack);
            return;
        }
        double minX = -sphere3D.getRadius();
        double minY = -sphere3D.getRadius();
        double minZ = -sphere3D.getRadius();
        double maxX = sphere3D.getRadius();
        double maxY = sphere3D.getRadius();
        double maxZ = sphere3D.getRadius();
        boundingBoxToPack.set(minX, minY, minZ, maxX, maxY, maxZ);
        Point3DReadOnly position = sphere3D.getPosition();
        if (sphere3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = sphere3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxTorus3D(FrameTorus3DReadOnly torus3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxTorus3D(torus3D.getReferenceFrame(), torus3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxTorus3D(ReferenceFrame torus3DFrame, Torus3DReadOnly torus3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        torus3DFrame.verifySameRoots(boundingBoxFrame);
        if (torus3DFrame == boundingBoxFrame) {
            EuclidShapeTools.boundingBoxCylinder3D((Point3DReadOnly)torus3D.getPosition(), (Vector3DReadOnly)torus3D.getAxis(), (double)torus3D.getTubeRadius(), (double)(torus3D.getRadius() + torus3D.getTubeRadius()), (BoundingBox3DBasics)boundingBoxToPack);
            return;
        }
        Point3DReadOnly position = torus3D.getPosition();
        if (torus3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, torus3D, torus3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = torus3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, torus3D, torus3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, torus3D, torus3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, null, (Tuple3DReadOnly)position, false, boundingBoxToPack);
            }
        }
    }

    public static void boundingBoxConvexPolytope3D(FrameConvexPolytope3DReadOnly convexPolytope3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxConvexPolytope3D(convexPolytope3D.getReferenceFrame(), convexPolytope3D, boundingBoxFrame, boundingBoxToPack);
    }

    public static void boundingBoxConvexPolytope3D(ReferenceFrame convexPolytope3DFrame, ConvexPolytope3DReadOnly convexPolytope3D, ReferenceFrame boundingBoxFrame, BoundingBox3DBasics boundingBoxToPack) {
        convexPolytope3DFrame.verifySameRoots(boundingBoxFrame);
        if (convexPolytope3DFrame == boundingBoxFrame) {
            boundingBoxToPack.set(convexPolytope3D.getBoundingBox());
            return;
        }
        if (convexPolytope3DFrame.isRootFrame()) {
            RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
            Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
            RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, convexPolytope3D, convexPolytope3DCalculator, boundingBoxToPack);
            EuclidFrameShapeTools.addTranslationPartOfTransform((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, boundingBoxToPack);
        } else {
            RigidBodyTransform transformToRoot = convexPolytope3DFrame.getTransformToRoot();
            Vector3DBasics transToRoot = transformToRoot.getTranslation();
            RotationMatrixBasics rotToRoot = transformToRoot.getRotation();
            if (boundingBoxFrame.isRootFrame()) {
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotToRoot, false, convexPolytope3D, convexPolytope3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransform((RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, boundingBoxToPack);
            } else {
                RigidBodyTransform transformFromBBX = boundingBoxFrame.getTransformToRoot();
                Vector3DBasics transFromBBX = transformFromBBX.getTranslation();
                RotationMatrixBasics rotFromBBX = transformFromBBX.getRotation();
                EuclidFrameShapeTools.boundingBoxRotationPartGeneric((RotationMatrixReadOnly)rotFromBBX, true, (RotationMatrixReadOnly)rotToRoot, false, convexPolytope3D, convexPolytope3DCalculator, boundingBoxToPack);
                EuclidFrameShapeTools.addTranslationPartOfTransforms((RotationMatrixReadOnly)rotFromBBX, (Tuple3DReadOnly)transFromBBX, true, (RotationMatrixReadOnly)rotToRoot, (Tuple3DReadOnly)transToRoot, false, boundingBoxToPack);
            }
        }
    }

    private static void addTranslationPartOfTransforms(RotationMatrixReadOnly rotationPart1, Tuple3DReadOnly translationPart1, boolean inverseTransform1, RotationMatrixReadOnly rotationPart2, Tuple3DReadOnly translationPart2, boolean inverseTransform2, RotationMatrixReadOnly rotationPart3, Tuple3DReadOnly translationPart3, boolean inverseTransform3, BoundingBox3DBasics boundingBoxTransformed) {
        if (TupleTools.isTupleZero((Tuple3DReadOnly)translationPart3, (double)1.0E-12)) {
            EuclidFrameShapeTools.addTranslationPartOfTransforms(rotationPart1, translationPart1, inverseTransform1, rotationPart2, translationPart2, inverseTransform2, boundingBoxTransformed);
        } else {
            double minX = boundingBoxTransformed.getMinX();
            double minY = boundingBoxTransformed.getMinY();
            double minZ = boundingBoxTransformed.getMinZ();
            Point3DBasics translationTransformed = boundingBoxTransformed.getMinPoint();
            translationTransformed.setToZero();
            EuclidFrameShapeTools.addAndTransform(rotationPart3, translationPart3, inverseTransform3, translationTransformed);
            EuclidFrameShapeTools.addAndTransform(rotationPart2, translationPart2, inverseTransform2, translationTransformed);
            EuclidFrameShapeTools.addAndTransform(rotationPart1, translationPart1, inverseTransform1, translationTransformed);
            boundingBoxTransformed.getMaxPoint().add((Tuple3DReadOnly)translationTransformed);
            boundingBoxTransformed.getMinPoint().add(minX, minY, minZ);
        }
    }

    private static void addTranslationPartOfTransforms(RotationMatrixReadOnly rotationPart1, Tuple3DReadOnly translationPart1, boolean inverseTransform1, RotationMatrixReadOnly rotationPart2, Tuple3DReadOnly translationPart2, boolean inverseTransform2, BoundingBox3DBasics boundingBoxTransformed) {
        if (TupleTools.isTupleZero((Tuple3DReadOnly)translationPart2, (double)1.0E-12)) {
            EuclidFrameShapeTools.addTranslationPartOfTransform(rotationPart1, translationPart1, inverseTransform1, boundingBoxTransformed);
        } else {
            double minX = boundingBoxTransformed.getMinX();
            double minY = boundingBoxTransformed.getMinY();
            double minZ = boundingBoxTransformed.getMinZ();
            boundingBoxTransformed.getMinPoint().setToZero();
            EuclidFrameShapeTools.addAndTransform(rotationPart2, translationPart2, inverseTransform2, boundingBoxTransformed.getMinPoint());
            EuclidFrameShapeTools.addAndTransform(rotationPart1, translationPart1, inverseTransform1, boundingBoxTransformed.getMinPoint());
            boundingBoxTransformed.getMaxPoint().add((Tuple3DReadOnly)boundingBoxTransformed.getMinPoint());
            boundingBoxTransformed.getMinPoint().add(minX, minY, minZ);
        }
    }

    private static void addTranslationPartOfTransform(RotationMatrixReadOnly rotationPart, Tuple3DReadOnly translationPart, boolean inverseTransform, BoundingBox3DBasics boundingBoxTransformed) {
        if (TupleTools.isTupleZero((Tuple3DReadOnly)translationPart, (double)1.0E-12)) {
            return;
        }
        if (rotationPart.isIdentity()) {
            if (inverseTransform) {
                boundingBoxTransformed.getMinPoint().sub(translationPart);
                boundingBoxTransformed.getMaxPoint().sub(translationPart);
            } else {
                boundingBoxTransformed.getMinPoint().add(translationPart);
                boundingBoxTransformed.getMaxPoint().add(translationPart);
            }
        } else if (inverseTransform) {
            double minX = boundingBoxTransformed.getMinX();
            double minY = boundingBoxTransformed.getMinY();
            double minZ = boundingBoxTransformed.getMinZ();
            boundingBoxTransformed.getMinPoint().setAndNegate(translationPart);
            rotationPart.inverseTransform((Tuple3DBasics)boundingBoxTransformed.getMinPoint());
            boundingBoxTransformed.getMaxPoint().add((Tuple3DReadOnly)boundingBoxTransformed.getMinPoint());
            boundingBoxTransformed.getMinPoint().add(minX, minY, minZ);
        } else {
            boundingBoxTransformed.getMinPoint().add(translationPart);
            boundingBoxTransformed.getMaxPoint().add(translationPart);
        }
    }

    private static void addAndTransform(RotationMatrixReadOnly rotationPart, Tuple3DReadOnly translationPart, boolean inverseTransform, Point3DBasics pointToTransform) {
        if (inverseTransform) {
            pointToTransform.sub(translationPart);
            if (rotationPart != null) {
                rotationPart.inverseTransform((Tuple3DBasics)pointToTransform);
            }
        } else {
            if (rotationPart != null) {
                rotationPart.transform((Tuple3DBasics)pointToTransform);
            }
            pointToTransform.add(translationPart);
        }
    }

    private static <T extends Shape3DReadOnly> void boundingBoxRotationPartGeneric(RotationMatrixReadOnly rotation1, boolean inverseTransform1, RotationMatrixReadOnly rotation2, boolean inverseTransform2, RotationMatrixReadOnly rotation3, boolean inverseTransform3, T shape, BoundingBoxRotationPartCalculator<T> calculator, BoundingBox3DBasics boundingBoxToPack) {
        if (rotation1.isIdentity()) {
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric(rotation2, inverseTransform2, rotation3, inverseTransform3, shape, calculator, boundingBoxToPack);
        } else if (rotation2.isIdentity()) {
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric(rotation1, inverseTransform1, rotation3, inverseTransform3, shape, calculator, boundingBoxToPack);
        } else {
            double b22;
            double b21;
            double b20;
            double b12;
            double b11;
            double b10;
            double b02;
            double b01;
            double b00;
            double a22;
            double a21;
            double a20;
            double a12;
            double a11;
            double a10;
            double a02;
            double a01;
            double a00;
            if (inverseTransform1) {
                a00 = rotation1.getM00();
                a01 = rotation1.getM10();
                a02 = rotation1.getM20();
                a10 = rotation1.getM01();
                a11 = rotation1.getM11();
                a12 = rotation1.getM21();
                a20 = rotation1.getM02();
                a21 = rotation1.getM12();
                a22 = rotation1.getM22();
            } else {
                a00 = rotation1.getM00();
                a01 = rotation1.getM01();
                a02 = rotation1.getM02();
                a10 = rotation1.getM10();
                a11 = rotation1.getM11();
                a12 = rotation1.getM12();
                a20 = rotation1.getM20();
                a21 = rotation1.getM21();
                a22 = rotation1.getM22();
            }
            if (inverseTransform2) {
                b00 = rotation2.getM00();
                b01 = rotation2.getM10();
                b02 = rotation2.getM20();
                b10 = rotation2.getM01();
                b11 = rotation2.getM11();
                b12 = rotation2.getM21();
                b20 = rotation2.getM02();
                b21 = rotation2.getM12();
                b22 = rotation2.getM22();
            } else {
                b00 = rotation2.getM00();
                b01 = rotation2.getM01();
                b02 = rotation2.getM02();
                b10 = rotation2.getM10();
                b11 = rotation2.getM11();
                b12 = rotation2.getM12();
                b20 = rotation2.getM20();
                b21 = rotation2.getM21();
                b22 = rotation2.getM22();
            }
            double c00 = a00 * b00 + a01 * b10 + a02 * b20;
            double c01 = a00 * b01 + a01 * b11 + a02 * b21;
            double c02 = a00 * b02 + a01 * b12 + a02 * b22;
            double c10 = a10 * b00 + a11 * b10 + a12 * b20;
            double c11 = a10 * b01 + a11 * b11 + a12 * b21;
            double c12 = a10 * b02 + a11 * b12 + a12 * b22;
            double c20 = a20 * b00 + a21 * b10 + a22 * b20;
            double c21 = a20 * b01 + a21 * b11 + a22 * b21;
            double c22 = a20 * b02 + a21 * b12 + a22 * b22;
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric(c00, c01, c02, c10, c11, c12, c20, c21, c22, false, rotation3, inverseTransform3, shape, calculator, boundingBoxToPack);
        }
    }

    private static <T extends Shape3DReadOnly> void boundingBoxRotationPartGeneric(RotationMatrixReadOnly rotation1, boolean inverseTransform1, RotationMatrixReadOnly rotation2, boolean inverseTransform2, T shape, BoundingBoxRotationPartCalculator<T> calculator, BoundingBox3DBasics boundingBoxToPack) {
        if (rotation1.isIdentity()) {
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric(rotation2, inverseTransform2, shape, calculator, boundingBoxToPack);
        } else {
            EuclidFrameShapeTools.boundingBoxRotationPartGeneric(rotation1.getM00(), rotation1.getM01(), rotation1.getM02(), rotation1.getM10(), rotation1.getM11(), rotation1.getM12(), rotation1.getM20(), rotation1.getM21(), rotation1.getM22(), inverseTransform1, rotation2, inverseTransform2, shape, calculator, boundingBoxToPack);
        }
    }

    private static <T extends Shape3DReadOnly> void boundingBoxRotationPartGeneric(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, boolean inverseTransform1, RotationMatrixReadOnly rotation2, boolean inverseTransform2, T shape, BoundingBoxRotationPartCalculator<T> calculator, BoundingBox3DBasics boundingBoxToPack) {
        double a22;
        double a21;
        double a20;
        double a12;
        double a11;
        double a10;
        double a02;
        double a01;
        double a00;
        if (inverseTransform1) {
            a00 = m00;
            a01 = m10;
            a02 = m20;
            a10 = m01;
            a11 = m11;
            a12 = m21;
            a20 = m02;
            a21 = m12;
            a22 = m22;
        } else {
            a00 = m00;
            a01 = m01;
            a02 = m02;
            a10 = m10;
            a11 = m11;
            a12 = m12;
            a20 = m20;
            a21 = m21;
            a22 = m22;
        }
        if (rotation2.isIdentity()) {
            calculator.computeBoundingBox(a00, a01, a02, a10, a11, a12, a20, a21, a22, shape, boundingBoxToPack);
        } else {
            double b22;
            double b21;
            double b20;
            double b12;
            double b11;
            double b10;
            double b02;
            double b01;
            double b00;
            if (inverseTransform2) {
                b00 = rotation2.getM00();
                b01 = rotation2.getM10();
                b02 = rotation2.getM20();
                b10 = rotation2.getM01();
                b11 = rotation2.getM11();
                b12 = rotation2.getM21();
                b20 = rotation2.getM02();
                b21 = rotation2.getM12();
                b22 = rotation2.getM22();
            } else {
                b00 = rotation2.getM00();
                b01 = rotation2.getM01();
                b02 = rotation2.getM02();
                b10 = rotation2.getM10();
                b11 = rotation2.getM11();
                b12 = rotation2.getM12();
                b20 = rotation2.getM20();
                b21 = rotation2.getM21();
                b22 = rotation2.getM22();
            }
            double c00 = a00 * b00 + a01 * b10 + a02 * b20;
            double c01 = a00 * b01 + a01 * b11 + a02 * b21;
            double c02 = a00 * b02 + a01 * b12 + a02 * b22;
            double c10 = a10 * b00 + a11 * b10 + a12 * b20;
            double c11 = a10 * b01 + a11 * b11 + a12 * b21;
            double c12 = a10 * b02 + a11 * b12 + a12 * b22;
            double c20 = a20 * b00 + a21 * b10 + a22 * b20;
            double c21 = a20 * b01 + a21 * b11 + a22 * b21;
            double c22 = a20 * b02 + a21 * b12 + a22 * b22;
            calculator.computeBoundingBox(c00, c01, c02, c10, c11, c12, c20, c21, c22, shape, boundingBoxToPack);
        }
    }

    private static <T extends Shape3DReadOnly> void boundingBoxRotationPartGeneric(RotationMatrixReadOnly rotation, boolean inverseTransform, T shape, BoundingBoxRotationPartCalculator<T> calculator, BoundingBox3DBasics boundingBoxToPack) {
        if (rotation.isIdentity()) {
            calculator.computeBoundingBoxZeroRotation(shape, boundingBoxToPack);
        } else {
            double m22;
            double m21;
            double m20;
            double m12;
            double m11;
            double m10;
            double m02;
            double m01;
            double m00;
            if (inverseTransform) {
                m00 = rotation.getM00();
                m01 = rotation.getM10();
                m02 = rotation.getM20();
                m10 = rotation.getM01();
                m11 = rotation.getM11();
                m12 = rotation.getM21();
                m20 = rotation.getM02();
                m21 = rotation.getM12();
                m22 = rotation.getM22();
            } else {
                m00 = rotation.getM00();
                m01 = rotation.getM01();
                m02 = rotation.getM02();
                m10 = rotation.getM10();
                m11 = rotation.getM11();
                m12 = rotation.getM12();
                m20 = rotation.getM20();
                m21 = rotation.getM21();
                m22 = rotation.getM22();
            }
            calculator.computeBoundingBox(m00, m01, m02, m10, m11, m12, m20, m21, m22, shape, boundingBoxToPack);
        }
    }

    private static interface BoundingBoxRotationPartCalculator<T extends Shape3DReadOnly> {
        public void computeBoundingBoxZeroRotation(T var1, BoundingBox3DBasics var2);

        public void computeBoundingBox(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, T var19, BoundingBox3DBasics var20);
    }
}

