/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameCylinder3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FrameCylinder3DReadOnly
extends Cylinder3DReadOnly,
FrameShape3DReadOnly {
    public FramePoint3DReadOnly getPosition();

    public FrameUnitVector3DReadOnly getAxis();

    @Override
    default public FramePoint3DReadOnly getCentroid() {
        return this.getPosition();
    }

    default public FramePoint3DReadOnly getTopCenter() {
        FramePoint3D topCenter = new FramePoint3D(this.getReferenceFrame());
        topCenter.scaleAdd(this.getHalfLength(), (FrameTuple3DReadOnly)this.getAxis(), (FrameTuple3DReadOnly)this.getPosition());
        return topCenter;
    }

    default public Point3DReadOnly getBottomCenter() {
        FramePoint3D bottomCenter = new FramePoint3D(this.getReferenceFrame());
        bottomCenter.scaleAdd(-this.getHalfLength(), (FrameTuple3DReadOnly)this.getAxis(), (FrameTuple3DReadOnly)this.getPosition());
        return bottomCenter;
    }

    default public int intersectionWith(FrameLine3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine3DReadOnly line, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine3DReadOnly line, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)secondIntersectionToPack);
        }
        return super.intersectionWith(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)secondIntersectionToPack);
        }
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        FrameShape3DReadOnly.super.getBoundingBox(boundingBoxToPack);
    }

    @Override
    default public void getBoundingBox(ReferenceFrame destinationFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxCylinder3D(this, destinationFrame, boundingBoxToPack);
    }

    @Override
    default public FrameShape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public FixedFrameCylinder3DBasics copy();

    default public String toString(String format) {
        return EuclidFrameShapeIOTools.getFrameCylinder3DString(format, this);
    }
}

