/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePlane3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePlane3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FramePlane3D
implements FramePlane3DBasics,
Settable<FramePlane3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics point = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private final FixedFrameUnitVector3DBasics normal = EuclidFrameFactories.newFixedFrameUnitVector3DBasics((ReferenceFrameHolder)this, (Vector3DReadOnly)Axis3D.Z);

    public FramePlane3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FramePlane3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FramePlane3D(ReferenceFrame referenceFrame, Plane3DReadOnly plane3D) {
        this.setIncludingFrame(referenceFrame, plane3D);
    }

    public FramePlane3D(FramePlane3DReadOnly framePlane3D) {
        this.setIncludingFrame(framePlane3D);
    }

    public FramePlane3D(FramePoint3DReadOnly point, FrameVector3DReadOnly normal) {
        this.setIncludingFrame(point, normal);
    }

    public FramePlane3D(ReferenceFrame referenceFrame, Point3DReadOnly point, Vector3DReadOnly normal) {
        this.setIncludingFrame(referenceFrame, point, normal);
    }

    public void set(FramePlane3D other) {
        FramePlane3DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getPoint() {
        return this.point;
    }

    @Override
    public FixedFrameUnitVector3DBasics getNormal() {
        return this.normal;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FramePlane3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.normal);
    }
}

