/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision.epa;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.collision.gjk.SupportingVertexTransformer;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.SupportingFrameVertexHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.shape.collision.epa.EPAFace3D;
import us.ihmc.euclid.shape.collision.epa.ExpandingPolytopeAlgorithm;
import us.ihmc.euclid.shape.collision.gjk.GJKSimplex3D;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameExpandingPolytopeAlgorithm {
    private ReferenceFrame detectorFrame;
    private final SupportingVertexTransformer supportingVertexTransformer = new SupportingVertexTransformer();
    private final ExpandingPolytopeAlgorithm epaAlgorithm = new ExpandingPolytopeAlgorithm();
    private final FrameVector3DReadOnly gjkSupportDirection = EuclidFrameFactories.newLinkedFrameVector3DReadOnly(() -> this.detectorFrame, (Vector3DReadOnly)this.epaAlgorithm.getGJKCollisionDetector().getSupportDirection());
    private boolean isInitialSupportDirectionProvided = false;
    private final FrameVector3D gjkInitialSupportDirection = new FrameVector3D();
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final Point3D centroid = new Point3D();

    public FrameExpandingPolytopeAlgorithm() {
        this.gjkInitialSupportDirection.setToNaN();
    }

    public EuclidFrameShape3DCollisionResult evaluateCollision(FrameShape3DReadOnly shapeA, FrameShape3DReadOnly shapeB) {
        EuclidFrameShape3DCollisionResult result = new EuclidFrameShape3DCollisionResult();
        this.evaluateCollision(shapeA, shapeB, (EuclidFrameShape3DCollisionResultBasics)result);
        return result;
    }

    public boolean evaluateCollision(FrameShape3DReadOnly shapeA, FrameShape3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        boolean areColliding;
        if (shapeA.getReferenceFrame() == shapeB.getReferenceFrame()) {
            this.initializeGJK(shapeA.getReferenceFrame());
            areColliding = this.epaAlgorithm.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB, (EuclidShape3DCollisionResultBasics)resultToPack);
        } else if (!shapeA.isPrimitive()) {
            if (!shapeB.isPrimitive()) {
                this.guessInitialSupportDirection(shapeA, shapeB);
                areColliding = this.evaluateCollision((SupportingFrameVertexHolder)shapeA, (SupportingFrameVertexHolder)shapeB, resultToPack);
            } else if (shapeB.isDefinedByPose()) {
                shapeA.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeB.getReferenceFrame());
                this.transform.preMultiplyInvertOther((RigidBodyTransformReadOnly)shapeB.getPose());
                FixedFrameShape3DBasics localShapeB = shapeB.copy();
                localShapeB.getPose().setToZero();
                this.centroid.set((Tuple3DReadOnly)shapeA.getCentroid());
                this.centroid.applyInverseTransform((Transform)this.transform);
                this.guessInitialSupportDirection((Point3DReadOnly)this.centroid, (Point3DReadOnly)localShapeB.getCentroid());
                areColliding = this.evaluateCollision(shapeB.getReferenceFrame(), shapeA, localShapeB, (RigidBodyTransformReadOnly)this.transform, resultToPack);
                resultToPack.applyTransform((Transform)shapeB.getPose());
            } else {
                shapeB.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeA.getReferenceFrame());
                FixedFrameShape3DBasics localShapeB = shapeB.copy();
                localShapeB.applyTransform((Transform)this.transform);
                this.guessInitialSupportDirection((Shape3DReadOnly)shapeA, (Shape3DReadOnly)localShapeB);
                areColliding = this.evaluateCollision(shapeA.getReferenceFrame(), shapeA, localShapeB, resultToPack);
            }
        } else if (!shapeB.isPrimitive()) {
            if (shapeA.isDefinedByPose()) {
                shapeB.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeA.getReferenceFrame());
                this.transform.preMultiplyInvertOther((RigidBodyTransformReadOnly)shapeA.getPose());
                FixedFrameShape3DBasics localShapeA = shapeA.copy();
                localShapeA.getPose().setToZero();
                this.centroid.set((Tuple3DReadOnly)shapeB.getCentroid());
                this.centroid.applyInverseTransform((Transform)this.transform);
                this.guessInitialSupportDirection((Point3DReadOnly)this.centroid, (Point3DReadOnly)localShapeA.getCentroid());
                areColliding = this.evaluateCollision(shapeA.getReferenceFrame(), shapeB, localShapeA, (RigidBodyTransformReadOnly)this.transform, resultToPack);
                resultToPack.swapShapes();
                resultToPack.applyTransform((Transform)shapeA.getPose());
            } else {
                shapeA.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeB.getReferenceFrame());
                FixedFrameShape3DBasics localShapeA = shapeA.copy();
                localShapeA.applyTransform((Transform)this.transform);
                this.guessInitialSupportDirection((Shape3DReadOnly)shapeB, (Shape3DReadOnly)localShapeA);
                areColliding = this.evaluateCollision(shapeB.getReferenceFrame(), shapeB, localShapeA, resultToPack);
                resultToPack.swapShapes();
            }
        } else if (shapeA.isDefinedByPose()) {
            shapeA.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeB.getReferenceFrame());
            this.transform.multiply((RigidBodyTransformReadOnly)shapeA.getPose());
            FixedFrameShape3DBasics localShapeA = shapeA.copy();
            localShapeA.getPose().setToZero();
            FixedFrameShape3DBasics localShapeB = shapeB.copy();
            localShapeB.applyInverseTransform((Transform)this.transform);
            this.guessInitialSupportDirection((Shape3DReadOnly)localShapeA, (Shape3DReadOnly)localShapeB);
            areColliding = this.evaluateCollision(shapeA.getReferenceFrame(), localShapeA, localShapeB, resultToPack);
            resultToPack.applyTransform((Transform)shapeA.getPose());
        } else if (shapeB.isDefinedByPose()) {
            shapeB.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeA.getReferenceFrame());
            this.transform.multiply((RigidBodyTransformReadOnly)shapeB.getPose());
            FixedFrameShape3DBasics localShapeA = shapeA.copy();
            localShapeA.applyInverseTransform((Transform)this.transform);
            FixedFrameShape3DBasics localShapeB = shapeB.copy();
            localShapeB.getPose().setToZero();
            this.guessInitialSupportDirection((Shape3DReadOnly)localShapeA, (Shape3DReadOnly)localShapeB);
            areColliding = this.evaluateCollision(shapeB.getReferenceFrame(), localShapeA, localShapeB, resultToPack);
            resultToPack.applyTransform((Transform)shapeB.getPose());
        } else {
            shapeB.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeA.getReferenceFrame());
            FixedFrameShape3DBasics localShapeA = shapeA.copy();
            localShapeA.applyInverseTransform((Transform)this.transform);
            FixedFrameShape3DBasics localShapeB = shapeB.copy();
            this.guessInitialSupportDirection(localShapeA, localShapeB);
            areColliding = this.evaluateCollision(shapeB.getReferenceFrame(), localShapeA, localShapeB, resultToPack);
        }
        resultToPack.getPointOnA().setReferenceFrame(this.detectorFrame);
        resultToPack.getPointOnB().setReferenceFrame(this.detectorFrame);
        resultToPack.getNormalOnA().setReferenceFrame(this.detectorFrame);
        resultToPack.getNormalOnB().setReferenceFrame(this.detectorFrame);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        return areColliding;
    }

    private void guessInitialSupportDirection(FrameShape3DReadOnly shapeA, FrameShape3DReadOnly shapeB) {
        if (this.isInitialSupportDirectionProvided) {
            return;
        }
        this.gjkInitialSupportDirection.setReferenceFrame(shapeB.getReferenceFrame());
        this.gjkInitialSupportDirection.setMatchingFrame((FrameTuple3DReadOnly)shapeA.getCentroid());
        this.gjkInitialSupportDirection.negate();
        this.gjkInitialSupportDirection.add((FrameTuple3DReadOnly)shapeB.getCentroid());
        this.isInitialSupportDirectionProvided = true;
    }

    private void guessInitialSupportDirection(Shape3DReadOnly shapeA, Shape3DReadOnly shapeB) {
        this.guessInitialSupportDirection(shapeA.getCentroid(), shapeB.getCentroid());
    }

    private void guessInitialSupportDirection(Point3DReadOnly centroidA, Point3DReadOnly centroidB) {
        if (this.isInitialSupportDirectionProvided) {
            return;
        }
        this.gjkInitialSupportDirection.setReferenceFrame(null);
        this.gjkInitialSupportDirection.sub((Tuple3DReadOnly)centroidB, (Tuple3DReadOnly)centroidA);
        this.isInitialSupportDirectionProvided = true;
    }

    public EuclidFrameShape3DCollisionResult evaluateCollision(SupportingFrameVertexHolder shapeA, SupportingFrameVertexHolder shapeB) {
        EuclidFrameShape3DCollisionResult result = new EuclidFrameShape3DCollisionResult();
        this.evaluateCollision(shapeA, shapeB, (EuclidFrameShape3DCollisionResultBasics)result);
        return result;
    }

    public boolean evaluateCollision(SupportingFrameVertexHolder shapeA, SupportingFrameVertexHolder shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        shapeA.getReferenceFrame().getTransformToDesiredFrame(this.transform, shapeB.getReferenceFrame());
        boolean areColliding = this.evaluateCollision(shapeB.getReferenceFrame(), shapeA, shapeB, (RigidBodyTransformReadOnly)this.transform, resultToPack);
        resultToPack.getPointOnA().setReferenceFrame(this.detectorFrame);
        resultToPack.getPointOnB().setReferenceFrame(this.detectorFrame);
        resultToPack.getNormalOnA().setReferenceFrame(this.detectorFrame);
        resultToPack.getNormalOnB().setReferenceFrame(this.detectorFrame);
        return areColliding;
    }

    private boolean evaluateCollision(ReferenceFrame detectorFrame, SupportingVertexHolder shapeA, SupportingVertexHolder shapeB, RigidBodyTransformReadOnly transformFromAToB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        this.supportingVertexTransformer.initialize(shapeA, transformFromAToB);
        return this.evaluateCollision(detectorFrame, this.supportingVertexTransformer, shapeB, resultToPack);
    }

    private boolean evaluateCollision(ReferenceFrame detectorFrame, SupportingVertexHolder shapeA, SupportingVertexHolder shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        this.initializeGJK(detectorFrame);
        return this.epaAlgorithm.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)resultToPack);
    }

    private boolean evaluateCollision(ReferenceFrame detectorFrame, Shape3DReadOnly shapeA, Shape3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        this.initializeGJK(detectorFrame);
        return this.epaAlgorithm.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)resultToPack);
    }

    private void initializeGJK(ReferenceFrame detectorFrame) {
        this.detectorFrame = detectorFrame;
        if (this.isInitialSupportDirectionProvided) {
            if (this.gjkInitialSupportDirection.getReferenceFrame() != null) {
                this.gjkInitialSupportDirection.changeFrame(detectorFrame);
            }
            this.epaAlgorithm.getGJKCollisionDetector().setInitialSupportDirection((Vector3DReadOnly)this.gjkInitialSupportDirection);
            this.gjkInitialSupportDirection.setToNaN(null);
            this.isInitialSupportDirectionProvided = false;
        }
    }

    public void setMaxIterations(int maxIterations) {
        this.epaAlgorithm.setMaxIterations(maxIterations);
    }

    public void setTerminalConditionEpsilon(double epsilon) {
        this.epaAlgorithm.setTerminalConditionEpsilon(epsilon);
    }

    public double getTerminalConditionEpsilon() {
        return this.epaAlgorithm.getTerminalConditionEpsilon();
    }

    public int getNumberOfIterations() {
        return this.epaAlgorithm.getNumberOfIterations();
    }

    public EPAFace3D getClosestFace() {
        return this.epaAlgorithm.getClosestFace();
    }

    public void setGJKInitialSupportDirection(FrameVector3DReadOnly initialSupportDirection) {
        this.isInitialSupportDirectionProvided = true;
        this.gjkInitialSupportDirection.setIncludingFrame((FrameTuple3DReadOnly)initialSupportDirection);
    }

    public void setGJKMaxIterations(int maxIterations) {
        this.epaAlgorithm.getGJKCollisionDetector().setMaxIterations(maxIterations);
    }

    public void setGJKTerminalConditionEpsilon(double epsilon) {
        this.epaAlgorithm.getGJKCollisionDetector().setTerminalConditionEpsilon(epsilon);
    }

    public void setGJKEpsilonTriangleNormalSwitch(double epsilon) {
        this.epaAlgorithm.getGJKCollisionDetector().setEpsilonTriangleNormalSwitch(epsilon);
    }

    public double getGJKTerminalConditionEpsilon() {
        return this.epaAlgorithm.getGJKCollisionDetector().getTerminalConditionEpsilon();
    }

    public double getEpsilonTriangleNormalSwitch() {
        return this.epaAlgorithm.getGJKCollisionDetector().getEpsilonTriangleNormalSwitch();
    }

    public int getGJKNumberOfIterations() {
        return this.epaAlgorithm.getGJKCollisionDetector().getNumberOfIterations();
    }

    public GJKSimplex3D getGJKSimplex() {
        return this.epaAlgorithm.getGJKCollisionDetector().getSimplex();
    }

    public FrameVector3DReadOnly getGJKSupportDirection() {
        return this.gjkSupportDirection;
    }

    public ReferenceFrame getDetectorFrame() {
        return this.detectorFrame;
    }
}

