/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FixedFrameEllipsoid3DBasics
extends Ellipsoid3DBasics,
FrameEllipsoid3DReadOnly,
FixedFrameShape3DBasics {
    public FixedFrameVector3DBasics getRadii();

    @Override
    public FixedFrameShape3DPoseBasics getPose();

    default public FixedFrameRotationMatrixBasics getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public FixedFramePoint3DBasics getPosition() {
        return this.getPose().getShapePosition();
    }

    default public void set(ReferenceFrame referenceFrame, Ellipsoid3DReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    default public void set(FrameEllipsoid3DReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void set(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(position, orientation, radiusX, radiusY, radiusZ);
    }

    default public void set(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly radii) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(position, orientation, radii);
    }

    default public void set(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.set(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, radiusX, radiusY, radiusZ);
    }

    default public void set(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly radii) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.set(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, radii);
    }

    default public void set(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly radii) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation, (ReferenceFrameHolder)radii);
        this.set(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)radii);
    }

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, radiusX, radiusY, radiusZ);
    }

    default public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly radii) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, radii);
    }

    default public void set(FramePose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose, radiusX, radiusY, radiusZ);
    }

    default public void set(FramePose3DReadOnly pose, Vector3DReadOnly radii) {
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose, radii);
    }

    default public void set(FramePose3DReadOnly pose, FrameVector3DReadOnly radii) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)radii);
        this.set(pose.getReferenceFrame(), (Pose3DReadOnly)pose, (Vector3DReadOnly)radii);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, radiusX, radiusY, radiusZ);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly radii) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, radii);
    }

    default public void set(FrameShape3DPoseReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, radiusX, radiusY, radiusZ);
    }

    default public void set(FrameShape3DPoseReadOnly pose, Vector3DReadOnly radii) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, radii);
    }

    default public void set(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly radii) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)radii);
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, (Vector3DReadOnly)radii);
    }

    default public void set(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double[] radii) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose, radii);
    }

    default public void set(FrameShape3DPoseReadOnly pose, double[] radii) {
        this.set(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, radii);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Ellipsoid3DReadOnly other) {
        this.set(other);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameEllipsoid3DReadOnly other) {
        this.setMatchingFrame(other.getReferenceFrame(), other);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        this.set(position, orientation, radiusX, radiusY, radiusZ);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly radii) {
        this.set(position, orientation, radii);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double radiusX, double radiusY, double radiusZ) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setMatchingFrame(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, radiusX, radiusY, radiusZ);
    }

    default public void setMatchingFrame(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly radii) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setMatchingFrame(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, radii);
    }

    default public void setMatchingFrame(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly radii) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation, (ReferenceFrameHolder)radii);
        this.setMatchingFrame(position.getReferenceFrame(), (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)radii);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.set(pose, radiusX, radiusY, radiusZ);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly radii) {
        this.set(pose, radii);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose, radiusX, radiusY, radiusZ);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose, Vector3DReadOnly radii) {
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose, radii);
    }

    default public void setMatchingFrame(FramePose3DReadOnly pose, FrameVector3DReadOnly radii) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)radii);
        this.setMatchingFrame(pose.getReferenceFrame(), (Pose3DReadOnly)pose, (Vector3DReadOnly)radii);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.set(pose, radiusX, radiusY, radiusZ);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly radii) {
        this.set(pose, radii);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, double radiusX, double radiusY, double radiusZ) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, radiusX, radiusY, radiusZ);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, Vector3DReadOnly radii) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, radii);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly radii) {
        pose.checkReferenceFrameMatch((ReferenceFrameHolder)radii);
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, (Vector3DReadOnly)radii);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double[] radii) {
        this.set(pose, radii);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameShape3DPoseReadOnly pose, double[] radii) {
        this.setMatchingFrame(pose.getReferenceFrame(), (RigidBodyTransformReadOnly)pose, radii);
    }
}

