/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;

public interface EuclidFrameShape3DCollisionResultReadOnly
extends EuclidShape3DCollisionResultReadOnly {
    public FramePoint3DReadOnly getPointOnA();

    public FramePoint3DReadOnly getPointOnB();

    public FrameVector3DReadOnly getNormalOnA();

    public FrameVector3DReadOnly getNormalOnB();

    public FrameShape3DReadOnly getShapeA();

    public FrameShape3DReadOnly getShapeB();

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (geometry instanceof EuclidFrameShape3DCollisionResultReadOnly) {
            EuclidFrameShape3DCollisionResultReadOnly other = (EuclidFrameShape3DCollisionResultReadOnly)geometry;
            if (this.getPointOnA().getReferenceFrame() != other.getPointOnA().getReferenceFrame()) {
                return false;
            }
            if (this.getPointOnB().getReferenceFrame() != other.getPointOnB().getReferenceFrame()) {
                return false;
            }
            if (this.getNormalOnA().getReferenceFrame() != other.getNormalOnA().getReferenceFrame()) {
                return false;
            }
            if (this.getNormalOnB().getReferenceFrame() != other.getNormalOnB().getReferenceFrame()) {
                return false;
            }
        }
        return super.epsilonEquals(geometry, epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (geometry instanceof EuclidFrameShape3DCollisionResultReadOnly) {
            return this.geometricallyEquals((EuclidFrameShape3DCollisionResultReadOnly)geometry, epsilon, epsilon, epsilon);
        }
        if (geometry instanceof EuclidShape3DCollisionResultReadOnly) {
            return this.geometricallyEquals((EuclidShape3DCollisionResultReadOnly)geometry, epsilon, epsilon, epsilon);
        }
        return false;
    }

    default public boolean geometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly other, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        FrameVector3DReadOnly otherNormalOnB;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        boolean swap = this.getShapeA() != null || this.getShapeB() != null || other.getShapeA() != null || other.getShapeB() != null ? this.getShapeA() != other.getShapeA() : this.getPointOnA().getReferenceFrame() != other.getPointOnA().getReferenceFrame();
        FramePoint3DReadOnly otherPointOnA = swap ? other.getPointOnB() : other.getPointOnA();
        FramePoint3DReadOnly otherPointOnB = swap ? other.getPointOnA() : other.getPointOnB();
        FrameVector3DReadOnly otherNormalOnA = swap ? other.getNormalOnB() : other.getNormalOnA();
        FrameVector3DReadOnly frameVector3DReadOnly = otherNormalOnB = swap ? other.getNormalOnA() : other.getNormalOnB();
        if (this.getPointOnA().getReferenceFrame() != otherPointOnA.getReferenceFrame()) {
            return false;
        }
        if (this.getPointOnB().getReferenceFrame() != otherPointOnB.getReferenceFrame()) {
            return false;
        }
        if (this.getNormalOnA().getReferenceFrame() != otherNormalOnA.getReferenceFrame()) {
            return false;
        }
        if (this.getNormalOnB().getReferenceFrame() != otherNormalOnB.getReferenceFrame()) {
            return false;
        }
        return super.geometricallyEquals((EuclidShape3DCollisionResultReadOnly)other, distanceEpsilon, pointTangentialEpsilon, normalEpsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry instanceof EuclidFrameShape3DCollisionResultReadOnly) {
            EuclidFrameShape3DCollisionResultReadOnly other = (EuclidFrameShape3DCollisionResultReadOnly)geometry;
            if (this.getPointOnA().getReferenceFrame() != other.getPointOnA().getReferenceFrame()) {
                return false;
            }
            if (this.getPointOnB().getReferenceFrame() != other.getPointOnB().getReferenceFrame()) {
                return false;
            }
            if (this.getNormalOnA().getReferenceFrame() != other.getNormalOnA().getReferenceFrame()) {
                return false;
            }
            if (this.getNormalOnB().getReferenceFrame() != other.getNormalOnB().getReferenceFrame()) {
                return false;
            }
        }
        return super.equals(geometry);
    }

    default public String toString(String format) {
        return EuclidFrameShapeIOTools.getEuclidFrameShape3DCollisionResultString(format, this);
    }
}

