/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;

public class FrameShape3DPose
implements FrameShape3DPoseBasics,
Settable<FrameShape3DPose> {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private ReferenceFrame referenceFrame;
    private final FixedFrameRotationMatrixBasics shapeOrientation = EuclidFrameFactories.newObservableFixedFrameRotationMatrixBasics((ReferenceFrameHolder)this, this::notifyChangeListeners, null);
    private final FixedFramePoint3DBasics shapePosition = EuclidFrameFactories.newObservableFixedFramePoint3DBasics((ReferenceFrameHolder)this, (axis, newValue) -> this.notifyChangeListeners(), null);
    private final FrameVector3DReadOnly xAxis = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)this, () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM00(), () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM10(), () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM20());
    private final FrameVector3DReadOnly yAxis = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)this, () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM01(), () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM11(), () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM21());
    private final FrameVector3DReadOnly zAxis = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)this, () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM02(), () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM12(), () -> ((FixedFrameRotationMatrixBasics)this.shapeOrientation).getM22());

    public FrameShape3DPose() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameShape3DPose(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameShape3DPose(ReferenceFrame referenceFrame, Pose3DReadOnly pose) {
        this.setIncludingFrame(referenceFrame, pose);
    }

    public FrameShape3DPose(FramePose3DReadOnly pose) {
        this.setIncludingFrame(pose);
    }

    public FrameShape3DPose(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose) {
        this.setIncludingFrame(referenceFrame, pose);
    }

    public FrameShape3DPose(FrameShape3DPoseReadOnly pose) {
        this.setIncludingFrame(pose);
    }

    public void set(FrameShape3DPose other) {
        FrameShape3DPoseBasics.super.set(other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFrameRotationMatrixBasics getShapeOrientation() {
        return this.shapeOrientation;
    }

    @Override
    public FixedFramePoint3DBasics getShapePosition() {
        return this.shapePosition;
    }

    @Override
    public FrameVector3DReadOnly getXAxis() {
        return this.xAxis;
    }

    @Override
    public FrameVector3DReadOnly getYAxis() {
        return this.yAxis;
    }

    @Override
    public FrameVector3DReadOnly getZAxis() {
        return this.zAxis;
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameShape3DPoseReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.shapePosition, (Object)this.shapeOrientation);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

