/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameRamp3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRampPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface FrameRamp3DReadOnly
extends Ramp3DReadOnly,
FrameShape3DReadOnly {
    public FrameVector3DReadOnly getSize();

    @Override
    public FrameShape3DPoseReadOnly getPose();

    default public FrameRotationMatrixReadOnly getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public FramePoint3DReadOnly getPosition() {
        return this.getPose().getShapePosition();
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        super.getBoundingBox(boundingBoxToPack);
    }

    @Override
    default public void getBoundingBox(ReferenceFrame destinationFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxRamp3D(this, destinationFrame, boundingBoxToPack);
    }

    public FrameRampPolytope3DView asConvexPolytope();

    default public FrameVector3DReadOnly getRampSurfaceNormal() {
        FrameVector3D surfaceNormal = new FrameVector3D();
        this.getRampSurfaceNormal((FrameVector3DBasics)surfaceNormal);
        return surfaceNormal;
    }

    default public void getRampSurfaceNormal(FrameVector3DBasics surfaceNormalToPack) {
        surfaceNormalToPack.setReferenceFrame(this.getReferenceFrame());
        super.getRampSurfaceNormal((Vector3DBasics)surfaceNormalToPack);
    }

    default public void getRampSurfaceNormal(FixedFrameVector3DBasics surfaceNormalToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)surfaceNormalToPack);
        super.getRampSurfaceNormal((Vector3DBasics)surfaceNormalToPack);
    }

    default public FramePoint3DBasics[] getVertices() {
        FramePoint3D[] vertices = new FramePoint3D[6];
        for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
            vertices[vertexIndex] = new FramePoint3D();
            this.getVertex(vertexIndex, (FramePoint3DBasics)vertices[vertexIndex]);
        }
        return vertices;
    }

    default public void getVertices(FramePoint3DBasics[] verticesToPack) {
        if (verticesToPack.length < 6) {
            throw new IllegalArgumentException("Array is too small, has to be at least 6 element long, was: " + verticesToPack.length);
        }
        for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
            this.getVertex(vertexIndex, verticesToPack[vertexIndex]);
        }
    }

    default public void getVertices(FixedFramePoint3DBasics[] verticesToPack) {
        if (verticesToPack.length < 6) {
            throw new IllegalArgumentException("Array is too small, has to be at least 6 element long, was: " + verticesToPack.length);
        }
        for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
            this.getVertex(vertexIndex, verticesToPack[vertexIndex]);
        }
    }

    default public FramePoint3DBasics getVertex(int vertexIndex) {
        FramePoint3D vertex = new FramePoint3D();
        this.getVertex(vertexIndex, (FramePoint3DBasics)vertex);
        return vertex;
    }

    default public void getVertex(int vertexIndex, FramePoint3DBasics vertexToPack) {
        vertexToPack.setReferenceFrame(this.getReferenceFrame());
        super.getVertex(vertexIndex, (Point3DBasics)vertexToPack);
    }

    default public void getVertex(int vertexIndex, FixedFramePoint3DBasics vertexToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vertexToPack);
        super.getVertex(vertexIndex, (Point3DBasics)vertexToPack);
    }

    @Override
    public FixedFrameRamp3DBasics copy();

    default public boolean epsilonEquals(FrameRamp3DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((Ramp3DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FrameRamp3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((Ramp3DReadOnly)other, epsilon);
    }

    default public boolean equals(FrameRamp3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return this.getPose().equals(other.getPose()) && this.getSize().equals((FrameTuple3DReadOnly)other.getSize());
    }
}

