/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoxPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FrameBox3DReadOnly
extends Box3DReadOnly,
FrameShape3DReadOnly {
    public FrameVector3DReadOnly getSize();

    @Override
    public FrameShape3DPoseReadOnly getPose();

    default public FrameRotationMatrixReadOnly getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public FramePoint3DReadOnly getPosition() {
        return this.getPose().getShapePosition();
    }

    @Override
    default public FramePoint3DReadOnly getCentroid() {
        return this.getPosition();
    }

    default public int intersectionWith(FrameLine3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine3DReadOnly line, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine3DReadOnly line, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (FrameVector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)secondIntersectionToPack);
        }
        return super.intersectionWith(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch((ReferenceFrameHolder)secondIntersectionToPack);
        }
        return super.intersectionWith((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        FrameShape3DReadOnly.super.getBoundingBox(boundingBoxToPack);
    }

    @Override
    default public void getBoundingBox(ReferenceFrame destinationFrame, BoundingBox3DBasics boundingBoxToPack) {
        EuclidFrameShapeTools.boundingBoxBox3D(this, destinationFrame, boundingBoxToPack);
    }

    public FrameBoxPolytope3DView asConvexPolytope();

    default public FramePoint3DBasics[] getVertices() {
        FramePoint3D[] vertices = new FramePoint3D[8];
        for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
            vertices[vertexIndex] = new FramePoint3D();
            this.getVertex(vertexIndex, (FramePoint3DBasics)vertices[vertexIndex]);
        }
        return vertices;
    }

    default public void getVertices(FramePoint3DBasics[] verticesToPack) {
        if (verticesToPack.length < 8) {
            throw new IllegalArgumentException("Array is too small, has to be at least 8 element long, was: " + verticesToPack.length);
        }
        for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
            this.getVertex(vertexIndex, verticesToPack[vertexIndex]);
        }
    }

    default public void getVertices(FixedFramePoint3DBasics[] verticesToPack) {
        if (verticesToPack.length < 8) {
            throw new IllegalArgumentException("Array is too small, has to be at least 8 element long, was: " + verticesToPack.length);
        }
        for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
            this.getVertex(vertexIndex, verticesToPack[vertexIndex]);
        }
    }

    default public FramePoint3DBasics getVertex(int vertexIndex) {
        FramePoint3D vertex = new FramePoint3D();
        this.getVertex(vertexIndex, (FramePoint3DBasics)vertex);
        return vertex;
    }

    default public void getVertex(int vertexIndex, FramePoint3DBasics vertexToPack) {
        this.getVertex(vertexIndex, (Point3DBasics)vertexToPack);
        vertexToPack.setReferenceFrame(this.getReferenceFrame());
    }

    default public void getVertex(int vertexIndex, FixedFramePoint3DBasics vertexToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vertexToPack);
        this.getVertex(vertexIndex, (Point3DBasics)vertexToPack);
    }

    @Override
    public FixedFrameBox3DBasics copy();

    default public boolean epsilonEquals(FrameBox3DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((Box3DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FrameBox3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((Box3DReadOnly)other, epsilon);
    }

    default public boolean equals(FrameBox3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return this.getPose().equals(other.getPose()) && this.getSize().equals((FrameTuple3DReadOnly)other.getSize());
    }
}

